/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToLongFunction;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.micrometer.MetricName;
import org.apache.iotdb.metrics.micrometer.type.MicrometerAutoGauge;
import org.apache.iotdb.metrics.micrometer.type.MicrometerCounter;
import org.apache.iotdb.metrics.micrometer.type.MicrometerGauge;
import org.apache.iotdb.metrics.micrometer.type.MicrometerHistogram;
import org.apache.iotdb.metrics.micrometer.type.MicrometerRate;
import org.apache.iotdb.metrics.micrometer.type.MicrometerTimer;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricManager
implements MetricManager {
    private static final Logger logger = LoggerFactory.getLogger(MicrometerMetricManager.class);
    Map<MetricName, IMetric> currentMeters;
    boolean isEnable;
    MeterRegistry meterRegistry;
    MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();

    public MicrometerMetricManager() {
        this.meterRegistry = Metrics.globalRegistry;
        this.currentMeters = new ConcurrentHashMap<MetricName, IMetric>();
        this.isEnable = this.metricConfig.getEnableMetric();
    }

    public boolean init() {
        return true;
    }

    public Counter getOrCreateCounter(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingCounter;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.COUNTER, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerCounter(this.meterRegistry.counter(metric, tags)));
        if (m instanceof Counter) {
            return (Counter)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public <T> Gauge getOrCreateAutoGauge(String metric, MetricLevel metricLevel, T obj, ToLongFunction<T> mapper, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerAutoGauge<Object>(this.meterRegistry, metric, obj, mapper, tags));
        if (m instanceof Gauge) {
            return (Gauge)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public Gauge getOrCreateGauge(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerGauge(this.meterRegistry, metric, tags));
        if (m instanceof Gauge) {
            return (Gauge)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public Histogram getOrCreateHistogram(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingHistogram;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.DISTRIBUTION_SUMMARY, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> {
            DistributionSummary distributionSummary = DistributionSummary.builder((String)metric).tags(tags).register(this.meterRegistry);
            return new MicrometerHistogram(distributionSummary);
        });
        if (m instanceof Histogram) {
            return (Histogram)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public Rate getOrCreateRate(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingRate;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerRate((AtomicLong)this.meterRegistry.gauge(metric, (Iterable)Tags.of((String[])tags), (Number)new AtomicLong(0L))));
        if (m instanceof Rate) {
            return (Rate)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public Timer getOrCreateTimer(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingTimer;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.TIMER, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> {
            io.micrometer.core.instrument.Timer timer = io.micrometer.core.instrument.Timer.builder((String)metric).tags(tags).register(this.meterRegistry);
            logger.info("create getOrCreateTimer {}", (Object)metric);
            return new MicrometerTimer(timer);
        });
        if (m instanceof Timer) {
            return (Timer)m;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public void count(long delta, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.COUNTER, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerCounter(this.meterRegistry.counter(metric, tags)));
        if (m instanceof Counter) {
            ((Counter)m).inc(delta);
        }
    }

    public void histogram(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.DISTRIBUTION_SUMMARY, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> {
            DistributionSummary distributionSummary = DistributionSummary.builder((String)metric).tags(tags).publishPercentileHistogram().publishPercentiles(new double[]{0.0}).register(this.meterRegistry);
            return new MicrometerHistogram(distributionSummary);
        });
        if (m instanceof Histogram) {
            ((Histogram)m).update(value);
            return;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public void gauge(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerGauge(this.meterRegistry, metric, tags));
        if (m instanceof Gauge) {
            ((Gauge)m).set(value);
            return;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public void rate(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> new MicrometerRate((AtomicLong)this.meterRegistry.gauge(metric, (Iterable)Tags.of((String[])tags), (Number)new AtomicLong(0L))));
        if (m instanceof Rate) {
            ((Rate)m).mark(value);
            return;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public synchronized void timer(long delta, TimeUnit timeUnit, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.TIMER, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(metricName, key -> {
            io.micrometer.core.instrument.Timer timer = io.micrometer.core.instrument.Timer.builder((String)metric).tags(tags).register(this.meterRegistry);
            return new MicrometerTimer(timer);
        });
        if (m instanceof Timer) {
            ((Timer)m).update(delta, timeUnit);
            return;
        }
        throw new IllegalArgumentException(metricName + " is already used for a different type of metric");
    }

    public List<String[]> getAllMetricKeys() {
        ArrayList<String[]> keys = new ArrayList<String[]>(this.currentMeters.size());
        List meterList = this.meterRegistry.getMeters();
        for (Meter meter : meterList) {
            ArrayList<String> tags = new ArrayList<String>(meter.getId().getTags().size() * 2 + 1);
            tags.add(meter.getId().getName());
            for (Tag tag : meter.getId().getTags()) {
                tags.add(tag.getKey());
                tags.add(tag.getValue());
            }
            keys.add(tags.toArray(new String[0]));
        }
        return keys;
    }

    public Map<String[], Counter> getAllCounters() {
        Map<String[], IMetric> metricMap = this.getMetricByType(Meter.Type.COUNTER);
        HashMap<String[], Counter> counterMap = new HashMap<String[], Counter>();
        metricMap.forEach((k, v) -> counterMap.put((String[])k, (Counter)v));
        return counterMap;
    }

    public Map<String[], Gauge> getAllGauges() {
        Map<String[], IMetric> metricMap = this.getMetricByType(Meter.Type.GAUGE);
        HashMap<String[], Gauge> gaugeMap = new HashMap<String[], Gauge>();
        metricMap.forEach((k, v) -> gaugeMap.put((String[])k, (Gauge)v));
        return gaugeMap;
    }

    public Map<String[], Rate> getAllRates() {
        Map<String[], IMetric> metricMap = this.getMetricByType(Meter.Type.OTHER);
        HashMap<String[], Rate> rateMap = new HashMap<String[], Rate>();
        metricMap.forEach((k, v) -> rateMap.put((String[])k, (Rate)v));
        return rateMap;
    }

    public Map<String[], Histogram> getAllHistograms() {
        Map<String[], IMetric> metricMap = this.getMetricByType(Meter.Type.DISTRIBUTION_SUMMARY);
        HashMap<String[], Histogram> histogramMap = new HashMap<String[], Histogram>();
        metricMap.forEach((k, v) -> histogramMap.put((String[])k, (Histogram)v));
        return histogramMap;
    }

    public Map<String[], Timer> getAllTimers() {
        Map<String[], IMetric> metricMap = this.getMetricByType(Meter.Type.TIMER);
        HashMap<String[], Timer> timerMap = new HashMap<String[], Timer>();
        metricMap.forEach((k, v) -> timerMap.put((String[])k, (Timer)v));
        return timerMap;
    }

    private Map<String[], IMetric> getMetricByType(Meter.Type type) {
        HashMap<String[], IMetric> metricMap = new HashMap<String[], IMetric>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (entry.getKey().getId().getType() != type) continue;
            ArrayList<String> tags = new ArrayList<String>(entry.getKey().getId().getTags().size() * 2);
            tags.add(entry.getKey().getId().getName());
            for (Tag tag : entry.getKey().getId().getTags()) {
                tags.add(tag.getKey());
                tags.add(tag.getValue());
            }
            metricMap.put(tags.toArray(new String[0]), entry.getValue());
        }
        return metricMap;
    }

    public void removeCounter(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.COUNTER, tags);
        this.currentMeters.remove(metricName);
    }

    public void removeGauge(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, tags);
        this.currentMeters.remove(metricName);
    }

    public void removeRate(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.GAUGE, tags);
        this.currentMeters.remove(metricName);
    }

    public void removeHistogram(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.DISTRIBUTION_SUMMARY, tags);
        this.currentMeters.remove(metricName);
    }

    public void removeTimer(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName metricName = new MetricName(metric, Meter.Type.TIMER, tags);
        this.currentMeters.remove(metricName);
    }

    public boolean stop() {
        this.isEnable = this.metricConfig.getEnableMetric();
        this.meterRegistry.clear();
        this.currentMeters = new ConcurrentHashMap<MetricName, IMetric>();
        return true;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public boolean isEnable(MetricLevel metricLevel) {
        return this.isEnable() && MetricLevel.higherOrEqual((MetricLevel)metricLevel, (MetricLevel)this.metricConfig.getMetricLevel());
    }
}

