/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.metrics.impl.DoNothingMetric;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.utils.IoTDBMetricsUtils;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class InternalIoTDBReporter
implements Reporter {
    protected final Map<MetricInfo, IMetric> autoGauges = new ConcurrentHashMap<MetricInfo, IMetric>();

    public void addAutoGauge(Gauge autoGauge, String name, String ... tags) {
        MetricInfo metricInfo = new MetricInfo(MetricType.AUTO_GAUGE, name, tags);
        this.autoGauges.put(metricInfo, autoGauge);
    }

    public void addAutoGauge(Map<MetricInfo, IMetric> gauges) {
        this.autoGauges.putAll(gauges);
    }

    public Map<MetricInfo, IMetric> getAllAutoGauge() {
        return this.autoGauges;
    }

    public void clear() {
        this.autoGauges.clear();
    }

    public void writeMetricToIoTDB(IMetric metric, String name, String ... tags) {
        if (!(metric instanceof DoNothingMetric)) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            metric.constructValueMap(values);
            this.writeMetricToIoTDB(values, IoTDBMetricsUtils.generatePath(name, tags), System.currentTimeMillis());
        }
    }

    protected abstract void writeMetricToIoTDB(Map<String, Object> var1, String var2, long var3);

    public void writeMetricToIoTDB(Map<MetricInfo, IMetric> metricMap) {
        HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<MetricInfo, IMetric> metricEntry : metricMap.entrySet()) {
            String prefix = IoTDBMetricsUtils.generatePath(metricEntry.getKey());
            IMetric metric = metricEntry.getValue();
            if (metric instanceof DoNothingMetric) continue;
            HashMap<String, Object> value = new HashMap<String, Object>();
            metric.constructValueMap(value);
            values.put(prefix, value);
        }
        this.writeMetricsToIoTDB(values, System.currentTimeMillis());
    }

    protected abstract void writeMetricsToIoTDB(Map<String, Map<String, Object>> var1, long var2);

    protected TSDataType inferType(Object value) {
        TSDataType dataType = value instanceof Boolean ? TSDataType.BOOLEAN : (value instanceof Integer ? TSDataType.INT32 : (value instanceof Long ? TSDataType.INT64 : (value instanceof Double ? TSDataType.DOUBLE : TSDataType.TEXT)));
        return dataType;
    }
}

