/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;

public class UDFLogWriter {
    public static final Byte REGISTER_TYPE = 0;
    public static final Byte DEREGISTER_TYPE = 1;
    private static final String REGISTER_TYPE_STRING = REGISTER_TYPE.toString();
    private static final String DEREGISTER_TYPE_STRING = DEREGISTER_TYPE.toString();
    private final File logFile;
    private final BufferedWriter writer;

    public UDFLogWriter(String logFileName) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFileName);
        FileWriter fileWriter = new FileWriter(this.logFile, true);
        this.writer = new BufferedWriter(fileWriter);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void deleteLogFile() throws IOException {
        if (!this.logFile.delete()) {
            throw new IOException("Failed to delete " + this.logFile + ".");
        }
    }

    public void register(String functionName, String className) throws IOException {
        this.writer.write(String.format("%s,%s,%s", REGISTER_TYPE_STRING, functionName, className));
        this.writeLineAndFlush();
    }

    public void deregister(String functionName) throws IOException {
        this.writer.write(String.format("%s,%s", DEREGISTER_TYPE_STRING, functionName));
        this.writeLineAndFlush();
    }

    private void writeLineAndFlush() throws IOException {
        this.writer.newLine();
        this.writer.flush();
    }
}

