/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class GroupByEngineDataSet
extends QueryDataSet {
    protected long queryId;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;
    protected long curStartTime;
    protected long curEndTime;
    protected boolean hasCachedTimeInterval;
    protected boolean leftCRightO;
    protected boolean isIntervalByMonth = false;
    protected boolean isSlidingStepByMonth = false;
    public static final long MS_TO_MONTH = 2592000000L;
    protected AggregateResult[] curAggregateResults;

    public GroupByEngineDataSet() {
    }

    public GroupByEngineDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(new ArrayList<PartialPath>(groupByTimePlan.getDeduplicatedPaths()), groupByTimePlan.getDeduplicatedDataTypes(), groupByTimePlan.isAscending());
        this.initGroupByEngineDataSetFields(context, groupByTimePlan);
    }

    protected Pair<Long, Long> getFirstTimeRange() {
        long retEndTime = this.isIntervalByMonth ? Math.min(GroupByEngineDataSet.calcIntervalByMonth(this.startTime, this.interval), this.endTime) : Math.min(this.startTime + this.interval, this.endTime);
        return new Pair((Object)this.startTime, (Object)retEndTime);
    }

    protected Pair<Long, Long> getLastTimeRange() {
        long retStartTime;
        long queryRange = this.endTime - this.startTime;
        if (this.isSlidingStepByMonth) {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)(this.slidingStep * 2592000000L));
            retStartTime = GroupByEngineDataSet.calcIntervalByMonth(this.startTime, intervalNum * this.slidingStep);
            while (retStartTime >= this.endTime) {
                retStartTime = GroupByEngineDataSet.calcIntervalByMonth(this.startTime, --intervalNum * this.slidingStep);
            }
        } else {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
            retStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
        }
        long retEndTime = this.isIntervalByMonth ? Math.min(GroupByEngineDataSet.calcIntervalByMonth(retStartTime, this.interval), this.endTime) : Math.min(retStartTime + this.interval, this.endTime);
        return new Pair((Object)retStartTime, (Object)retEndTime);
    }

    protected Pair<Long, Long> getNextTimeRange(long curStartTime, boolean isAscending, boolean isInside) {
        long retStartTime;
        if (isAscending ? (retStartTime = this.isSlidingStepByMonth ? GroupByEngineDataSet.calcIntervalByMonth(curStartTime, (int)this.slidingStep) : curStartTime + this.slidingStep) >= this.endTime && isInside : (retStartTime = this.isSlidingStepByMonth ? GroupByEngineDataSet.calcIntervalByMonth(curStartTime, (int)(-this.slidingStep)) : curStartTime - this.slidingStep) < this.startTime && isInside) {
            return null;
        }
        long retEndTime = this.isIntervalByMonth ? GroupByEngineDataSet.calcIntervalByMonth(retStartTime, (int)this.interval) : retStartTime + this.interval;
        if (isInside) {
            retEndTime = Math.min(retEndTime, this.endTime);
        }
        return new Pair((Object)retStartTime, (Object)retEndTime);
    }

    protected void initGroupByEngineDataSetFields(QueryContext context, GroupByTimePlan groupByTimePlan) {
        this.queryId = context.getQueryId();
        this.interval = groupByTimePlan.getInterval();
        this.slidingStep = groupByTimePlan.getSlidingStep();
        if (groupByTimePlan instanceof GroupByTimeFillPlan) {
            this.startTime = ((GroupByTimeFillPlan)groupByTimePlan).getQueryStartTime();
            this.endTime = ((GroupByTimeFillPlan)groupByTimePlan).getQueryEndTime();
        } else {
            this.startTime = groupByTimePlan.getStartTime();
            this.endTime = groupByTimePlan.getEndTime();
        }
        this.leftCRightO = groupByTimePlan.isLeftCRightO();
        this.ascending = groupByTimePlan.isAscending();
        this.isIntervalByMonth = groupByTimePlan.isIntervalByMonth();
        this.isSlidingStepByMonth = groupByTimePlan.isSlidingStepByMonth();
        if (this.isIntervalByMonth) {
            this.interval /= 2592000000L;
        }
        if (this.isSlidingStepByMonth) {
            this.slidingStep /= 2592000000L;
        }
        Pair<Long, Long> retTimeRange = this.ascending ? this.getFirstTimeRange() : this.getLastTimeRange();
        this.curStartTime = (Long)retTimeRange.left;
        this.curEndTime = (Long)retTimeRange.right;
        this.hasCachedTimeInterval = true;
    }

    public boolean hasNextWithoutConstraint() {
        if (this.hasCachedTimeInterval) {
            return true;
        }
        Pair<Long, Long> nextTimeRange = this.getNextTimeRange(this.curStartTime, this.ascending, true);
        if (nextTimeRange == null) {
            return false;
        }
        this.curStartTime = (Long)nextTimeRange.left;
        this.curEndTime = (Long)nextTimeRange.right;
        this.hasCachedTimeInterval = true;
        return true;
    }

    public static long calcIntervalByMonth(long startTime, long numMonths) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(SessionManager.getInstance().getCurrSessionTimeZone());
        calendar.setTimeInMillis(startTime);
        boolean isLastDayOfMonth = calendar.get(5) == calendar.getActualMaximum(5);
        calendar.add(2, (int)numMonths);
        if (isLastDayOfMonth) {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar.getTimeInMillis();
    }

    public abstract RowRecord nextWithoutConstraint() throws IOException;

    public long getStartTime() {
        return this.startTime;
    }

    public AggregateResult[] getCurAggregateResults() {
        return this.curAggregateResults;
    }

    public Pair<Long, Long> nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return new Pair((Object)this.curStartTime, (Object)this.curEndTime);
    }
}

