/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SystemMetrics
implements IMetricSet {
    private OperatingSystemMXBean osMXBean;
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long systemDiskTotalSpace = 0L;
    private long systemDiskFreeSpace = 0L;

    public SystemMetrics() {
        this.osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public void bindTo(AbstractMetricService metricService) {
        this.collectSystemCpuInfo(metricService);
        this.collectSystemDiskInfo(metricService);
        this.collectSystemMemInfo(metricService);
        if (metricService.isEnable() && null == this.currentServiceFuture) {
            this.currentServiceFuture = this.service.scheduleAtFixedRate(this::collect, 1L, MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), TimeUnit.SECONDS);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(false);
            this.currentServiceFuture = null;
        }
        this.removeSystemCpuInfo(metricService);
        this.removeSystemDiskInfo(metricService);
        this.removeSystemMemInfo(metricService);
    }

    private void collectSystemCpuInfo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> (long)(this.osMXBean.getSystemCpuLoad() * 100.0), new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateGauge(Metric.SYS_CPU_CORES.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "system"}).set((long)this.osMXBean.getAvailableProcessors());
    }

    private void removeSystemCpuInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.SYS_CPU_LOAD.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_CPU_CORES.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectSystemMemInfo(AbstractMetricService metricService) {
        metricService.getOrCreateGauge(Metric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "system"}).set(this.osMXBean.getTotalPhysicalMemorySize());
        metricService.getOrCreateAutoGauge(Metric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreePhysicalMemorySize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateAutoGauge(Metric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getTotalSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateAutoGauge(Metric.SYS_FREE_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreeSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateAutoGauge(Metric.SYS_COMMITTED_VM_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getCommittedVirtualMemorySize(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void removeSystemMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_FREE_SWAP_SPACE_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_COMMITTED_VM_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectSystemDiskInfo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, (Object)this, SystemMetrics::getSystemDiskTotalSpace, new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateAutoGauge(Metric.SYS_DISK_FREE_SPACE.toString(), MetricLevel.CORE, (Object)this, SystemMetrics::getSystemDiskFreeSpace, new String[]{Tag.NAME.toString(), "system"});
    }

    private void removeSystemDiskInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.SYS_DISK_TOTAL_SPACE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_DISK_FREE_SPACE.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collect() {
        File[] files = File.listRoots();
        long sysTotalSpace = 0L;
        long sysFreeSpace = 0L;
        for (File file : files) {
            sysTotalSpace += file.getTotalSpace();
            sysFreeSpace += file.getFreeSpace();
        }
        this.systemDiskTotalSpace = sysTotalSpace;
        this.systemDiskFreeSpace = sysFreeSpace;
    }

    public long getSystemDiskTotalSpace() {
        return this.systemDiskTotalSpace;
    }

    public long getSystemDiskFreeSpace() {
        return this.systemDiskFreeSpace;
    }
}

