/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.cross.CrossCompactionStrategy;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.ICrossSpaceMergeFileSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.compaction.inner.utils.AlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.inner.utils.SingleSeriesCompactionExecutor;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerSpaceCompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");

    private InnerSpaceCompactionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void compact(TsFileResource targetResource, List<TsFileResource> tsFileResources) throws IOException, MetadataException, InterruptedException {
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataMemorySizeProportion());
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(tsFileResources);
             TsFileIOWriter writer = new TsFileIOWriter(targetResource.getTsFile(), true, sizeForFileWriter);){
            while (deviceIterator.hasNextDevice()) {
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean aligned = (Boolean)deviceInfo.right;
                if (aligned) {
                    InnerSpaceCompactionUtils.compactAlignedSeries(device, targetResource, writer, deviceIterator);
                    continue;
                }
                writer.startChunkGroup(device);
                InnerSpaceCompactionUtils.compactNotAlignedSeries(device, targetResource, writer, deviceIterator);
                writer.endChunkGroup();
            }
            for (TsFileResource tsFileResource : tsFileResources) {
                targetResource.updatePlanIndexes(tsFileResource);
            }
            writer.endFile();
            targetResource.close();
        }
    }

    private static void checkThreadInterrupted(TsFileResource tsFileResource) throws InterruptedException {
        if (Thread.interrupted() || !IoTDB.activated) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", tsFileResource.toString()));
        }
    }

    private static void compactNotAlignedSeries(String device, TsFileResource targetResource, TsFileIOWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, MetadataException, InterruptedException {
        MultiTsFileDeviceIterator.MeasurementIterator seriesIterator = deviceIterator.iterateNotAlignedSeries(device, true);
        while (seriesIterator.hasNextSeries()) {
            InnerSpaceCompactionUtils.checkThreadInterrupted(targetResource);
            PartialPath p = new PartialPath(device, seriesIterator.nextSeries());
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList = seriesIterator.getMetadataListForCurrentSeries();
            SingleSeriesCompactionExecutor compactionExecutorOfCurrentTimeSeries = new SingleSeriesCompactionExecutor(p, readerAndChunkMetadataList, writer, targetResource);
            compactionExecutorOfCurrentTimeSeries.execute();
        }
        writer.checkMetadataSizeAndMayFlush();
    }

    private static void compactAlignedSeries(String device, TsFileResource targetResource, TsFileIOWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, InterruptedException {
        InnerSpaceCompactionUtils.checkThreadInterrupted(targetResource);
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = deviceIterator.getReaderAndChunkMetadataForCurrentAlignedSeries();
        if (!InnerSpaceCompactionUtils.checkAlignedSeriesValid(readerAndChunkMetadataList)) {
            return;
        }
        AlignedSeriesCompactionExecutor compactionExecutor = new AlignedSeriesCompactionExecutor(device, targetResource, readerAndChunkMetadataList, writer);
        compactionExecutor.execute();
    }

    private static boolean checkAlignedSeriesValid(LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList) {
        for (Pair pair : readerAndChunkMetadataList) {
            if (((List)pair.right).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean deleteTsFilesInDisk(Collection<TsFileResource> mergeTsFiles, String storageGroupName) {
        logger.info("{} [Compaction] Compaction starts to delete real file ", (Object)storageGroupName);
        boolean result = true;
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            if (!InnerSpaceCompactionUtils.deleteTsFile(mergeTsFile)) {
                result = false;
            }
            logger.info("{} [Compaction] delete TsFile {}", (Object)storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
        return result;
    }

    public static void deleteModificationForSourceFile(Collection<TsFileResource> sourceFiles, String storageGroupName) throws IOException {
        logger.info("{} [Compaction] Start to delete modifications of source files", (Object)storageGroupName);
        for (TsFileResource tsFileResource : sourceFiles) {
            ModificationFile normalModification;
            ModificationFile compactionModificationFile = ModificationFile.getCompactionMods(tsFileResource);
            if (compactionModificationFile.exists()) {
                compactionModificationFile.remove();
            }
            if (!(normalModification = ModificationFile.getNormalMods(tsFileResource)).exists()) continue;
            normalModification.remove();
        }
    }

    public static void combineModsInCompaction(Collection<TsFileResource> mergeTsFiles, TsFileResource targetTsFile) throws IOException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            ModificationFile sourceCompactionModificationFile = ModificationFile.getCompactionMods(mergeTsFile);
            Throwable throwable = null;
            try {
                modifications.addAll(sourceCompactionModificationFile.getModifications());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sourceCompactionModificationFile == null) continue;
                if (throwable != null) {
                    try {
                        sourceCompactionModificationFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sourceCompactionModificationFile.close();
            }
        }
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetTsFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    public static boolean deleteTsFile(TsFileResource seqFile) {
        try {
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            seqFile.setStatus(TsFileResourceStatus.DELETED);
            seqFile.delete();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static ICrossSpaceMergeFileSelector getCrossSpaceFileSelector(long budget, CrossSpaceCompactionResource resource) {
        CrossCompactionStrategy strategy = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionStrategy();
        switch (strategy) {
            case REWRITE_COMPACTION: {
                return new RewriteCompactionFileSelector(resource, budget);
            }
        }
        throw new UnsupportedOperationException("Unknown CrossSpaceFileStrategy " + (Object)((Object)strategy));
    }

    public static void moveTargetFile(TsFileResource targetResource, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        if (!targetResource.getTsFilePath().endsWith(".inner")) {
            logger.warn("{} [Compaction] Tmp target tsfile {} should be end with {}", new Object[]{fullStorageGroupName, targetResource.getTsFilePath(), ".inner"});
            return;
        }
        File oldFile = targetResource.getTsFile();
        String newFilePath = targetResource.getTsFilePath().replace(".inner", ".tsfile");
        File newFile = new File(newFilePath);
        FSFactoryProducer.getFSFactory().moveFile(oldFile, newFile);
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.close();
    }
}

