/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.catchup;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.catchup.LogCatchUpTask;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.handlers.caller.SnapshotCatchUpHandler;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCatchUpTask
extends LogCatchUpTask
implements Callable<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotCatchUpTask.class);
    private static final long SEND_SNAPSHOT_WAIT_MS = ClusterDescriptor.getInstance().getConfig().getCatchUpTimeoutMS();
    private Snapshot snapshot;

    SnapshotCatchUpTask(List<Log> logs, Snapshot snapshot, Node node, int raftId, RaftMember raftMember) {
        super(logs, node, raftId, raftMember);
        this.snapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSnapshotCatchUp() throws TException, InterruptedException, LeaderUnknownException {
        SendSnapshotRequest request = new SendSnapshotRequest();
        if (this.raftMember.getHeader() != null) {
            request.setHeader(this.raftMember.getHeader());
        }
        logger.info("Start to send snapshot to {}", (Object)this.node);
        ByteBuffer data = this.snapshot.serialize();
        if (logger.isInfoEnabled()) {
            logger.info("Do snapshot catch up with size {}", (Object)data.array().length);
        }
        request.setSnapshotBytes(data);
        AtomicLong atomicLong = this.raftMember.getTerm();
        synchronized (atomicLong) {
            if (this.raftMember.getCharacter() != NodeCharacter.LEADER) {
                throw new LeaderUnknownException(this.raftMember.getAllNodes());
            }
        }
        this.abort = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? !this.sendSnapshotAsync(request) : !this.sendSnapshotSync(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendSnapshotAsync(SendSnapshotRequest request) throws TException, InterruptedException {
        AtomicBoolean succeed = new AtomicBoolean(false);
        SnapshotCatchUpHandler handler = new SnapshotCatchUpHandler(succeed, this.node, this.snapshot);
        RaftService.AsyncClient client = this.raftMember.getAsyncClient(this.node);
        if (client == null) {
            logger.info("{}: client null for node {}", (Object)this.raftMember.getThisNode(), (Object)this.node);
            this.abort = true;
            return false;
        }
        logger.info("{}: the snapshot request size={}", (Object)this.raftMember.getName(), (Object)request.getSnapshotBytes().length);
        AtomicBoolean atomicBoolean = succeed;
        synchronized (atomicBoolean) {
            client.sendSnapshot(request, (AsyncMethodCallback)handler);
            this.raftMember.getLastCatchUpResponseTime().put(this.node, System.currentTimeMillis());
            succeed.wait(SEND_SNAPSHOT_WAIT_MS);
        }
        if (logger.isInfoEnabled()) {
            logger.info("send snapshot to node {} success {}", (Object)this.raftMember.getThisNode(), (Object)succeed.get());
        }
        return succeed.get();
    }

    private boolean sendSnapshotSync(SendSnapshotRequest request) throws TException {
        logger.info("{}: sending a snapshot request size={} to {}", new Object[]{this.raftMember.getName(), request.getSnapshotBytes().length, this.node});
        RaftService.Client client = this.raftMember.getSyncClient(this.node);
        if (client == null) {
            return false;
        }
        try {
            client.sendSnapshot(request);
            logger.info("{}: snapshot is sent to {}", (Object)this.raftMember.getName(), (Object)this.node);
            boolean bl = true;
            return bl;
        }
        catch (TException e) {
            client.getInputProtocol().getTransport().close();
            throw e;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
    }

    @Override
    public Boolean call() throws InterruptedException, TException, LeaderUnknownException {
        this.doSnapshotCatchUp();
        if (this.abort) {
            logger.warn("{}: Snapshot catch up {} failed", (Object)this.raftMember.getName(), (Object)this.node);
            this.raftMember.getLastCatchUpResponseTime().remove(this.node);
            return false;
        }
        logger.info("{}: Snapshot catch up {} finished, begin to catch up log", (Object)this.raftMember.getName(), (Object)this.node);
        this.doLogCatchUp();
        if (!this.abort) {
            logger.info("{}: Catch up {} finished", (Object)this.raftMember.getName(), (Object)this.node);
        } else {
            logger.warn("{}: Log catch up {} failed", (Object)this.raftMember.getName(), (Object)this.node);
        }
        this.raftMember.getLastCatchUpResponseTime().remove(this.node);
        return !this.abort;
    }
}

