/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class ListDataSet
extends QueryDataSet {
    private final List<RowRecord> records = new ArrayList<RowRecord>();
    private int index = 0;

    public ListDataSet(List<PartialPath> paths, List<TSDataType> dataTypes) {
        super(new ArrayList<PartialPath>(paths), dataTypes);
    }

    public boolean hasNextWithoutConstraint() {
        return this.index < this.records.size();
    }

    public RowRecord nextWithoutConstraint() {
        return this.records.get(this.index++);
    }

    public void putRecord(RowRecord newRecord) {
        this.records.add(newRecord);
    }

    public void sortByTime() {
        this.records.sort((o1, o2) -> Long.compare(o2.getTimestamp(), o1.getTimestamp()));
    }

    public void sort(Comparator<RowRecord> c) {
        this.records.sort(c);
    }
}

