/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.task;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCompactionTask
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final String device;
    private final List<String> measurementList;
    private final QueryContext queryContext;
    private final QueryDataSource queryDataSource;
    private final AbstractCompactionWriter compactionWriter;
    private final Map<String, MeasurementSchema> schemaMap;
    private final int taskId;

    public SubCompactionTask(String device, List<String> measurementList, QueryContext queryContext, QueryDataSource queryDataSource, AbstractCompactionWriter compactionWriter, Map<String, MeasurementSchema> schemaMap, int taskId) {
        this.device = device;
        this.measurementList = measurementList;
        this.queryContext = queryContext;
        this.queryDataSource = queryDataSource;
        this.compactionWriter = compactionWriter;
        this.schemaMap = schemaMap;
        this.taskId = taskId;
    }

    @Override
    public Void call() throws Exception {
        for (String measurement : this.measurementList) {
            List<MeasurementSchema> measurementSchemas = Collections.singletonList(this.schemaMap.get(measurement));
            IBatchReader dataBatchReader = CompactionUtils.constructReader(this.device, Collections.singletonList(measurement), measurementSchemas, this.schemaMap.keySet(), this.queryContext, this.queryDataSource, false);
            if (!dataBatchReader.hasNextBatch()) continue;
            this.compactionWriter.startMeasurement(measurementSchemas, this.taskId);
            CompactionUtils.writeWithReader(this.compactionWriter, dataBatchReader, this.taskId);
            this.compactionWriter.endMeasurement(this.taskId);
        }
        return null;
    }
}

