/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.snapshot;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.cluster.RemoteTsFileResource;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.PullFileException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.log.snapshot.SnapshotInstaller;
import org.apache.iotdb.cluster.log.snapshot.TimeseriesSchemaSnapshot;
import org.apache.iotdb.cluster.partition.slot.SlotManager;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshot
extends Snapshot
implements TimeseriesSchemaSnapshot {
    private static final Logger logger = LoggerFactory.getLogger(FileSnapshot.class);
    public static final int PULL_FILE_RETRY_INTERVAL_MS = 5000;
    private Collection<TimeseriesSchema> timeseriesSchemas;
    private List<RemoteTsFileResource> dataFiles = new ArrayList<RemoteTsFileResource>();

    public FileSnapshot() {
        this.timeseriesSchemas = new ArrayList<TimeseriesSchema>();
    }

    public void addFile(TsFileResource resource, Node header) throws IOException {
        this.addFile(resource, header, false);
    }

    public void addFile(TsFileResource resource, Node header, boolean isRangeUnique) throws IOException {
        RemoteTsFileResource remoteTsFileResource = new RemoteTsFileResource(resource, header);
        remoteTsFileResource.setPlanRangeUnique(isRangeUnique);
        this.dataFiles.add(remoteTsFileResource);
    }

    @Override
    public ByteBuffer serialize() {
        logger.info("Start to serialize a snapshot {}", (Object)this);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            logger.info("Start to serialize {} schemas", (Object)this.timeseriesSchemas.size());
            dataOutputStream.writeInt(this.timeseriesSchemas.size());
            for (TimeseriesSchema measurementSchema : this.timeseriesSchemas) {
                measurementSchema.serializeTo((OutputStream)dataOutputStream);
            }
            logger.info("Start to serialize {} data files", (Object)this.dataFiles.size());
            dataOutputStream.writeInt(this.dataFiles.size());
            for (RemoteTsFileResource dataFile : this.dataFiles) {
                dataFile.serialize(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int timeseriesNum = buffer.getInt();
        for (int i = 0; i < timeseriesNum; ++i) {
            this.timeseriesSchemas.add(TimeseriesSchema.deserializeFrom((ByteBuffer)buffer));
        }
        int fileNum = buffer.getInt();
        for (int i = 0; i < fileNum; ++i) {
            RemoteTsFileResource resource = new RemoteTsFileResource();
            resource.deserialize(buffer);
            this.dataFiles.add(resource);
        }
    }

    public List<RemoteTsFileResource> getDataFiles() {
        return this.dataFiles;
    }

    @Override
    public Collection<TimeseriesSchema> getTimeseriesSchemas() {
        return this.timeseriesSchemas;
    }

    @Override
    public void setTimeseriesSchemas(Collection<TimeseriesSchema> timeseriesSchemas) {
        this.timeseriesSchemas = timeseriesSchemas;
    }

    public SnapshotInstaller<FileSnapshot> getDefaultInstaller(RaftMember member) {
        return new Installer((DataGroupMember)member);
    }

    @Override
    public String toString() {
        return String.format("FileSnapshot{%d files, %d series, index-term: %d-%d}", this.dataFiles.size(), this.timeseriesSchemas.size(), this.lastLogIndex, this.lastLogTerm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSnapshot snapshot = (FileSnapshot)o;
        return Objects.equals(this.timeseriesSchemas, snapshot.timeseriesSchemas) && Objects.equals(this.dataFiles, snapshot.dataFiles);
    }

    @Override
    public void truncateBefore(long minIndex) {
        this.dataFiles.removeIf(res -> {
            boolean toBeTruncated;
            boolean bl = toBeTruncated = res.getMaxPlanIndex() < minIndex;
            if (toBeTruncated) {
                res.remove();
            }
            return toBeTruncated;
        });
    }

    public int hashCode() {
        return Objects.hash(this.timeseriesSchemas, this.dataFiles);
    }

    public static class Factory
    implements SnapshotFactory<FileSnapshot> {
        public static final Factory INSTANCE = new Factory();

        @Override
        public FileSnapshot create() {
            return new FileSnapshot();
        }

        @Override
        public FileSnapshot copy(FileSnapshot origin) {
            FileSnapshot fileSnapshot = new FileSnapshot();
            fileSnapshot.setLastLogIndex(origin.lastLogIndex);
            fileSnapshot.setLastLogTerm(origin.lastLogTerm);
            fileSnapshot.dataFiles = origin.dataFiles == null ? null : new ArrayList(origin.dataFiles);
            fileSnapshot.timeseriesSchemas = origin.timeseriesSchemas == null ? null : new ArrayList(origin.timeseriesSchemas);
            return fileSnapshot;
        }
    }

    public static class Installer
    implements SnapshotInstaller<FileSnapshot> {
        private static final String REMOTE_FILE_TEMP_DIR = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "remote";
        private static final Logger logger = LoggerFactory.getLogger(Installer.class);
        private DataGroupMember dataGroupMember;
        private SlotManager slotManager;
        private String name;

        Installer(DataGroupMember dataGroupMember) {
            this.dataGroupMember = dataGroupMember;
            this.slotManager = dataGroupMember.getSlotManager();
            this.name = dataGroupMember.getName();
        }

        @Override
        public void install(FileSnapshot snapshot, int slot, boolean isDataMigration) throws SnapshotInstallationException {
            try {
                SlotManager.SlotStatus status;
                logger.info("Starting to install a snapshot {} into slot[{}]", (Object)snapshot, (Object)slot);
                this.installFileSnapshotSchema(snapshot);
                logger.info("Schemas in snapshot are registered");
                if (isDataMigration && (status = this.slotManager.getStatus(slot)) == SlotManager.SlotStatus.PULLING) {
                    this.slotManager.setToPullingWritable(slot);
                    logger.debug("{}: slot {} is now pulling writable", (Object)this.name, (Object)slot);
                }
                this.installFileSnapshotFiles(snapshot, slot, isDataMigration);
            }
            catch (PullFileException e) {
                throw new SnapshotInstallationException(e);
            }
        }

        @Override
        public void install(Map<Integer, FileSnapshot> snapshotMap, boolean isDataMigration) throws SnapshotInstallationException {
            logger.info("Starting to install snapshots {}", snapshotMap);
            this.installSnapshot(snapshotMap, isDataMigration);
        }

        private void installSnapshot(Map<Integer, FileSnapshot> snapshotMap, boolean isDataMigration) throws SnapshotInstallationException {
            FileSnapshot snapshot;
            Integer slot;
            this.dataGroupMember.getMetaGroupMember().syncLocalApply(this.dataGroupMember.getMetaGroupMember().getPartitionTable().getLastMetaLogIndex() - 1L, false);
            for (Map.Entry<Integer, FileSnapshot> integerSnapshotEntry : snapshotMap.entrySet()) {
                SlotManager.SlotStatus status;
                slot = integerSnapshotEntry.getKey();
                snapshot = integerSnapshotEntry.getValue();
                this.installFileSnapshotSchema(snapshot);
                if (!isDataMigration || (status = this.slotManager.getStatus(slot)) != SlotManager.SlotStatus.PULLING) continue;
                this.slotManager.setToPullingWritable(slot, false);
                logger.debug("{}: slot {} is now pulling writable", (Object)this.name, (Object)slot);
            }
            if (isDataMigration) {
                this.slotManager.save();
            }
            for (Map.Entry<Integer, FileSnapshot> integerSnapshotEntry : snapshotMap.entrySet()) {
                slot = integerSnapshotEntry.getKey();
                snapshot = integerSnapshotEntry.getValue();
                try {
                    this.installFileSnapshotFiles(snapshot, slot, isDataMigration);
                }
                catch (PullFileException e) {
                    throw new SnapshotInstallationException(e);
                }
            }
            this.slotManager.save();
        }

        private void installFileSnapshotSchema(FileSnapshot snapshot) {
            for (TimeseriesSchema schema : snapshot.getTimeseriesSchemas()) {
                SchemaUtils.registerTimeseries((TimeseriesSchema)schema);
            }
        }

        private void installFileSnapshotFiles(FileSnapshot snapshot, int slot, boolean isDataMigration) throws PullFileException {
            List<RemoteTsFileResource> remoteTsFileResources = snapshot.getDataFiles();
            int remoteTsFileResourcesSize = remoteTsFileResources.size();
            for (int i = 0; i < remoteTsFileResourcesSize; ++i) {
                RemoteTsFileResource resource = remoteTsFileResources.get(i);
                logger.info("Pulling {}/{} files, current: {}", new Object[]{i + 1, remoteTsFileResources.size(), resource});
                try {
                    if (isDataMigration) {
                        resource.setMinPlanIndex(this.dataGroupMember.getLogManager().getLastLogIndex());
                        resource.setMaxPlanIndex(this.dataGroupMember.getLogManager().getLastLogIndex());
                        this.loadRemoteFile(resource);
                        continue;
                    }
                    if (!this.isFileAlreadyPulled(resource)) {
                        this.loadRemoteFile(resource);
                        continue;
                    }
                    this.removeRemoteHardLink(resource);
                    continue;
                }
                catch (IllegalPathException e) {
                    throw new PullFileException(resource.getTsFilePath(), resource.getSource(), (Exception)((Object)e));
                }
            }
            this.slotManager.setToNull(slot, !isDataMigration);
            logger.info("{}: slot {} is ready", (Object)this.name, (Object)slot);
        }

        private boolean isFileAlreadyPulled(RemoteTsFileResource resource) throws IllegalPathException {
            Pair sgNameAndTimePartitionIdPair = FilePathUtils.getLogicalSgNameAndTimePartitionIdPair((String)resource.getTsFile().getAbsolutePath());
            return StorageEngine.getInstance().isFileAlreadyExist((TsFileResource)resource, new PartialPath((String)sgNameAndTimePartitionIdPair.left), ((Long)sgNameAndTimePartitionIdPair.right).longValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRemoteHardLink(RemoteTsFileResource resource) {
            Node sourceNode = resource.getSource();
            if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                AsyncDataClient client = (AsyncDataClient)this.dataGroupMember.getAsyncClient(sourceNode);
                if (client != null) {
                    try {
                        client.removeHardLink(resource.getTsFile().getAbsolutePath(), new GenericHandler(sourceNode, null));
                    }
                    catch (TException e) {
                        logger.error("Cannot remove hardlink {} from {}", (Object)resource.getTsFile().getAbsolutePath(), (Object)sourceNode);
                    }
                }
            } else {
                SyncDataClient client = (SyncDataClient)this.dataGroupMember.getSyncClient(sourceNode);
                if (client == null) {
                    logger.error("Cannot remove hardlink {} from {}, due to can not get client", (Object)resource.getTsFile().getAbsolutePath(), (Object)sourceNode);
                    return;
                }
                try {
                    client.removeHardLink(resource.getTsFile().getAbsolutePath());
                }
                catch (TException te) {
                    client.close();
                    logger.error("Cannot remove hardlink {} from {}", (Object)resource.getTsFile().getAbsolutePath(), (Object)sourceNode);
                }
                finally {
                    client.returnSelf();
                }
            }
        }

        private void loadRemoteFile(RemoteTsFileResource resource) throws PullFileException {
            File tempFile;
            Node sourceNode = resource.getSource();
            try {
                tempFile = this.pullRemoteFile(resource, sourceNode);
            }
            catch (IOException e) {
                throw new PullFileException(resource.toString(), sourceNode, e);
            }
            if (tempFile != null) {
                resource.setFile(tempFile);
                try {
                    resource.serialize();
                    this.loadRemoteResource(resource);
                    logger.info("{}: Remote file {} is successfully loaded", (Object)this.name, (Object)resource);
                    return;
                }
                catch (IOException e) {
                    logger.error("{}: Cannot serialize {}", new Object[]{this.name, resource, e});
                }
                catch (IllegalPathException e) {
                    logger.error("Illegal path when loading file {}", (Object)resource, (Object)e);
                }
            }
            logger.error("{}: Cannot load remote file {} from node {}", new Object[]{this.name, resource, sourceNode});
            throw new PullFileException(resource.toString(), sourceNode);
        }

        private void loadRemoteResource(RemoteTsFileResource resource) throws IllegalPathException {
            PartialPath storageGroupName = new PartialPath(FilePathUtils.getLogicalStorageGroupName((String)resource.getTsFile().getAbsolutePath()));
            try {
                StorageEngine.getInstance().getProcessor(storageGroupName).loadNewTsFile((TsFileResource)resource);
                if (resource.isPlanRangeUnique()) {
                    StorageEngine.getInstance().getProcessor(storageGroupName).removeFullyOverlapFiles((TsFileResource)resource);
                }
            }
            catch (LoadFileException | StorageEngineException e) {
                logger.error("{}: Cannot load remote file {} into storage group", new Object[]{this.name, resource, e});
                return;
            }
            resource.setRemote(false);
        }

        private File pullRemoteFile(RemoteTsFileResource resource, Node node) throws IOException {
            logger.info("{}: pulling remote file {} from {}, plan index [{}, {}]", new Object[]{this.name, resource, node, resource.getMinPlanIndex(), resource.getMaxPlanIndex()});
            String tempFileName = FilePathUtils.getTsFileNameWithoutHardLink((String)resource.getTsFile().getAbsolutePath());
            String tempFilePath = node.getNodeIdentifier() + File.separator + FilePathUtils.getTsFilePrefixPath((String)resource.getTsFile().getAbsolutePath()) + File.separator + tempFileName;
            File tempFile = new File(REMOTE_FILE_TEMP_DIR, tempFilePath);
            tempFile.getParentFile().mkdirs();
            if (this.pullRemoteFile(resource.getTsFile().getAbsolutePath(), node, tempFile)) {
                if (resource.isWithModification()) {
                    File tempModFile = new File(REMOTE_FILE_TEMP_DIR, tempFilePath + ".mods");
                    this.pullRemoteFile(resource.getModFile().getFilePath(), node, tempModFile);
                }
                return tempFile;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean pullRemoteFile(String remotePath, Node node, File dest) throws IOException {
            int pullFileRetry = 5;
            int i = 0;
            while (i < pullFileRetry) {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(dest));){
                    if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                        this.downloadFileAsync(node, remotePath, bufferedOutputStream);
                    } else {
                        this.downloadFileSync(node, remotePath, bufferedOutputStream);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("{}: remote file {} is pulled at {}, length: {}", new Object[]{this.name, remotePath, dest, dest.length()});
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (TException e) {
                    logger.warn("{}: Cannot pull file {} from {}, wait 5s to retry", new Object[]{this.name, remotePath, node, e});
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("{}: Pulling file {} from {} interrupted", new Object[]{this.name, remotePath, node, e});
                    return false;
                }
                try {
                    Files.delete(dest.toPath());
                    Thread.sleep(5000L);
                }
                catch (IOException e) {
                    logger.warn("Cannot delete file when pulling {} from {} failed", (Object)remotePath, (Object)node);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    logger.warn("{}: Pulling file {} from {} interrupted", new Object[]{this.name, remotePath, node, ex});
                    return false;
                }
                ++i;
            }
            return false;
        }

        private void downloadFileAsync(Node node, String remotePath, OutputStream dest) throws IOException, TException, InterruptedException {
            long offset = 0L;
            int fetchSize = 65536;
            while (true) {
                AsyncDataClient client;
                if ((client = (AsyncDataClient)this.dataGroupMember.getAsyncClient(node)) == null) {
                    throw new IOException("No available client for " + node.toString());
                }
                ByteBuffer buffer = SyncClientAdaptor.readFile(client, remotePath, offset, fetchSize);
                int len = this.writeBuffer(buffer, dest);
                if (len == 0) break;
                offset += (long)len;
            }
            dest.flush();
        }

        private int writeBuffer(ByteBuffer buffer, OutputStream dest) throws IOException {
            if (buffer == null || buffer.limit() - buffer.position() == 0) {
                return 0;
            }
            dest.write(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() - buffer.position());
            return buffer.limit() - buffer.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadFileSync(Node node, String remotePath, OutputStream dest) throws IOException {
            SyncDataClient client = (SyncDataClient)this.dataGroupMember.getSyncClient(node);
            if (client == null) {
                throw new IOException("No available client for " + node.toString());
            }
            long offset = 0L;
            int fetchSize = 65536;
            try {
                ByteBuffer buffer;
                int len;
                while ((len = this.writeBuffer(buffer = client.readFile(remotePath, offset, fetchSize), dest)) != 0) {
                    offset += (long)len;
                }
            }
            catch (TException e) {
                client.close();
            }
            finally {
                client.returnSelf();
            }
            dest.flush();
        }
    }
}

