/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage.serializable;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.log.HardState;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.LogParser;
import org.apache.iotdb.cluster.log.StableEntryManager;
import org.apache.iotdb.cluster.log.manage.serializable.LogManagerMeta;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLogDequeSerializer
implements StableEntryManager {
    private static final Logger logger = LoggerFactory.getLogger(SyncLogDequeSerializer.class);
    private static final String LOG_DATA_FILE_SUFFIX = "data";
    private static final String LOG_INDEX_FILE_SUFFIX = "idx";
    private List<File> logDataFileList;
    private List<File> logIndexFileList;
    private LogParser parser = LogParser.getINSTANCE();
    private File metaFile;
    private FileOutputStream currentLogDataOutputStream;
    private FileOutputStream currentLogIndexOutputStream;
    private LogManagerMeta meta;
    private HardState state;
    private long minAvailableVersion = 0L;
    private long maxAvailableVersion = Long.MAX_VALUE;
    private String logDir;
    private VersionController versionController;
    private ByteBuffer logDataBuffer = ByteBuffer.allocate(ClusterDescriptor.getInstance().getConfig().getRaftLogBufferSize());
    private ByteBuffer logIndexBuffer = ByteBuffer.allocate(ClusterDescriptor.getInstance().getConfig().getRaftLogBufferSize());
    private long offsetOfTheCurrentLogDataOutputStream = 0L;
    private static final int MAX_NUMBER_OF_LOGS_PER_FETCH_ON_DISK = ClusterDescriptor.getInstance().getConfig().getMaxNumberOfLogsPerFetchOnDisk();
    private static final String LOG_META = "logMeta";
    private static final String LOG_META_TMP = "logMeta.tmp";
    private static final int FILE_NAME_PART_LENGTH = 4;
    private int maxRaftLogIndexSizeInMemory = ClusterDescriptor.getInstance().getConfig().getMaxRaftLogIndexSizeInMemory();
    private int maxRaftLogPersistDataSizePerFile = ClusterDescriptor.getInstance().getConfig().getMaxRaftLogPersistDataSizePerFile();
    private int maxNumberOfPersistRaftLogFiles = ClusterDescriptor.getInstance().getConfig().getMaxNumberOfPersistRaftLogFiles();
    private int maxPersistRaftLogNumberOnDisk = ClusterDescriptor.getInstance().getConfig().getMaxPersistRaftLogNumberOnDisk();
    private ScheduledExecutorService persistLogDeleteExecutorService;
    private ScheduledFuture<?> persistLogDeleteLogFuture;
    private long firstLogIndex = 0L;
    private List<Long> logIndexOffsetList;
    private static final int LOG_DELETE_CHECK_INTERVAL_SECOND = 5;
    private final Lock lock = new ReentrantLock();
    private volatile boolean isClosed = false;

    private void initCommonProperties() {
        this.logDataFileList = new ArrayList<File>();
        this.logIndexFileList = new ArrayList<File>();
        this.logIndexOffsetList = new ArrayList<Long>(this.maxRaftLogIndexSizeInMemory);
        try {
            this.versionController = new SimpleFileVersionController(this.logDir);
        }
        catch (IOException e) {
            logger.error("log serializer build version controller failed", (Throwable)e);
        }
        this.persistLogDeleteExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("persist-log-delete-" + this.logDir).daemon(true).build());
        this.persistLogDeleteLogFuture = this.persistLogDeleteExecutorService.scheduleAtFixedRate(this::checkDeletePersistRaftLog, 5L, 5L, TimeUnit.SECONDS);
    }

    public SyncLogDequeSerializer(String logPath) {
        this.logDir = logPath + File.separator;
        this.initCommonProperties();
        this.initMetaAndLogFiles();
    }

    public SyncLogDequeSerializer(int nodeIdentifier) {
        this.logDir = SyncLogDequeSerializer.getLogDir(nodeIdentifier);
        this.initCommonProperties();
        this.initMetaAndLogFiles();
    }

    public static String getLogDir(int nodeIdentifier) {
        String systemDir = IoTDBDescriptor.getInstance().getConfig().getSystemDir();
        return systemDir + File.separator + "raftLog" + File.separator + nodeIdentifier + File.separator;
    }

    String getLogDir() {
        return this.logDir;
    }

    File getMetaFile() {
        return this.metaFile;
    }

    @Override
    public LogManagerMeta getMeta() {
        return this.meta;
    }

    @Override
    public List<Log> getAllEntriesAfterAppliedIndex() {
        logger.debug("getAllEntriesBeforeAppliedIndex, maxHaveAppliedCommitIndex={}, commitLogIndex={}", (Object)this.meta.getMaxHaveAppliedCommitIndex(), (Object)this.meta.getCommitLogIndex());
        if (this.meta.getMaxHaveAppliedCommitIndex() >= this.meta.getCommitLogIndex()) {
            return Collections.emptyList();
        }
        return this.getLogs(this.meta.getMaxHaveAppliedCommitIndex(), this.meta.getCommitLogIndex());
    }

    @Override
    public List<Log> getAllEntriesAfterCommittedIndex() {
        long lastIndex = this.firstLogIndex + (long)this.logIndexOffsetList.size() - 1L;
        logger.debug("getAllEntriesAfterCommittedIndex, firstUnCommitIndex={}, lastIndexBeforeStart={}", (Object)(this.meta.getCommitLogIndex() + 1L), (Object)lastIndex);
        if (this.meta.getCommitLogIndex() >= lastIndex) {
            return Collections.emptyList();
        }
        return this.getLogs(this.meta.getCommitLogIndex() + 1L, lastIndex);
    }

    @Override
    public void append(List<Log> entries, long maxHaveAppliedCommitIndex) throws IOException {
        this.lock.lock();
        try {
            this.putLogs(entries);
            Log entry = entries.get(entries.size() - 1);
            this.meta.setCommitLogIndex(entry.getCurrLogIndex());
            this.meta.setCommitLogTerm(entry.getCurrLogTerm());
            this.meta.setLastLogIndex(entry.getCurrLogIndex());
            this.meta.setLastLogTerm(entry.getCurrLogTerm());
            this.meta.setMaxHaveAppliedCommitIndex(maxHaveAppliedCommitIndex);
            logger.debug("maxHaveAppliedCommitIndex={}, commitLogIndex={},lastLogIndex={}", new Object[]{maxHaveAppliedCommitIndex, this.meta.getCommitLogIndex(), this.meta.getLastLogIndex()});
        }
        catch (BufferOverflowException e) {
            throw new IOException("Log cannot fit into buffer, please increase raft_log_buffer_size;otherwise, please increase the JVM memory", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void putLogs(List<Log> entries) {
        for (Log log : entries) {
            this.logDataBuffer.mark();
            this.logIndexBuffer.mark();
            ByteBuffer logData = log.serialize();
            int size = logData.capacity() + 4;
            try {
                this.logDataBuffer.putInt(logData.capacity());
                this.logDataBuffer.put(logData);
                this.logIndexBuffer.putLong(this.offsetOfTheCurrentLogDataOutputStream);
                this.logIndexOffsetList.add(this.offsetOfTheCurrentLogDataOutputStream);
                this.offsetOfTheCurrentLogDataOutputStream += (long)size;
            }
            catch (BufferOverflowException e) {
                logger.info("Raft log buffer overflow!");
                this.logDataBuffer.reset();
                this.logIndexBuffer.reset();
                this.flushLogBuffer();
                this.checkCloseCurrentFile(log.getCurrLogIndex() - 1L);
                this.logDataBuffer.putInt(logData.capacity());
                this.logDataBuffer.put(logData);
                this.logIndexBuffer.putLong(this.offsetOfTheCurrentLogDataOutputStream);
                this.logIndexOffsetList.add(this.offsetOfTheCurrentLogDataOutputStream);
                this.offsetOfTheCurrentLogDataOutputStream += (long)size;
            }
        }
    }

    private void checkCloseCurrentFile(long commitIndex) {
        if (this.offsetOfTheCurrentLogDataOutputStream > (long)this.maxRaftLogPersistDataSizePerFile) {
            try {
                this.closeCurrentFile(commitIndex);
                this.serializeMeta(this.meta);
                this.createNewLogFile(this.logDir, commitIndex + 1L);
            }
            catch (IOException e) {
                logger.error("check close current file failed", (Throwable)e);
            }
        }
    }

    private void closeCurrentFile(long commitIndex) throws IOException {
        if (this.currentLogDataOutputStream != null) {
            this.currentLogDataOutputStream.close();
            logger.info("{}: Closed a log data file {}", (Object)this, (Object)this.getCurrentLogDataFile());
            this.currentLogDataOutputStream = null;
            File currentLogDataFile = this.getCurrentLogDataFile();
            String newDataFileName = currentLogDataFile.getName().replaceAll(String.valueOf(Long.MAX_VALUE), String.valueOf(commitIndex));
            File newCurrentLogDatFile = SystemFileFactory.INSTANCE.getFile(currentLogDataFile.getParent() + File.separator + newDataFileName);
            if (!currentLogDataFile.renameTo(newCurrentLogDatFile)) {
                logger.error("rename log data file={} to {} failed", (Object)currentLogDataFile.getAbsoluteFile(), (Object)newCurrentLogDatFile);
            }
            this.logDataFileList.set(this.logDataFileList.size() - 1, newCurrentLogDatFile);
            logger.debug("rename data file={} to file={}", (Object)currentLogDataFile.getAbsoluteFile(), (Object)newCurrentLogDatFile.getAbsoluteFile());
        }
        if (this.currentLogIndexOutputStream != null) {
            this.currentLogIndexOutputStream.close();
            logger.info("{}: Closed a log index file {}", (Object)this, (Object)this.getCurrentLogIndexFile());
            this.currentLogIndexOutputStream = null;
            File currentLogIndexFile = this.getCurrentLogIndexFile();
            String newIndexFileName = currentLogIndexFile.getName().replaceAll(String.valueOf(Long.MAX_VALUE), String.valueOf(commitIndex));
            File newCurrentLogIndexFile = SystemFileFactory.INSTANCE.getFile(currentLogIndexFile.getParent() + File.separator + newIndexFileName);
            if (!currentLogIndexFile.renameTo(newCurrentLogIndexFile)) {
                logger.error("rename log index file={} failed", (Object)currentLogIndexFile.getAbsoluteFile());
            }
            logger.debug("rename index file={} to file={}", (Object)currentLogIndexFile.getAbsoluteFile(), (Object)newCurrentLogIndexFile.getAbsoluteFile());
            this.logIndexFileList.set(this.logIndexFileList.size() - 1, newCurrentLogIndexFile);
        }
        this.offsetOfTheCurrentLogDataOutputStream = 0L;
    }

    @Override
    public void flushLogBuffer() {
        if (this.isClosed || this.logDataBuffer.position() == 0) {
            return;
        }
        this.lock.lock();
        try {
            try {
                this.checkStream();
                ReadWriteIOUtils.writeWithoutSize((ByteBuffer)this.logDataBuffer, (int)0, (int)this.logDataBuffer.position(), (OutputStream)this.currentLogDataOutputStream);
                ReadWriteIOUtils.writeWithoutSize((ByteBuffer)this.logIndexBuffer, (int)0, (int)this.logIndexBuffer.position(), (OutputStream)this.currentLogIndexOutputStream);
                if (ClusterDescriptor.getInstance().getConfig().getFlushRaftLogThreshold() == 0) {
                    this.currentLogDataOutputStream.getChannel().force(true);
                    this.currentLogIndexOutputStream.getChannel().force(true);
                }
            }
            catch (IOException e) {
                logger.error("Error in logs serialization: ", (Throwable)e);
                this.lock.unlock();
                return;
            }
            this.logDataBuffer.clear();
            this.logIndexBuffer.clear();
            logger.debug("End flushing log buffer.");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void forceFlushLogBufferWithoutCloseFile() {
        if (this.isClosed) {
            return;
        }
        this.lock.lock();
        this.flushLogBuffer();
        this.serializeMeta(this.meta);
        try {
            if (this.currentLogDataOutputStream != null) {
                this.currentLogDataOutputStream.getChannel().force(true);
            }
            if (this.currentLogIndexOutputStream != null) {
                this.currentLogIndexOutputStream.getChannel().force(true);
            }
        }
        catch (ClosedByInterruptException closedByInterruptException) {
        }
        catch (IOException e) {
            logger.error("Error when force flushing logs serialization: ", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void forceFlushLogBuffer() {
        this.lock.lock();
        try {
            this.forceFlushLogBufferWithoutCloseFile();
            this.checkCloseCurrentFile(this.meta.getCommitLogIndex());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setHardStateAndFlush(HardState state) {
        this.state = state;
        this.serializeMeta(this.meta);
    }

    @Override
    public HardState getHardState() {
        return this.state;
    }

    @Override
    public void removeCompactedEntries(long index) {
    }

    private void initMetaAndLogFiles() {
        this.recoverMetaFile();
        this.recoverMeta();
        this.firstLogIndex = this.meta.getCommitLogIndex() + 1L;
        try {
            this.recoverLogFiles();
            if (this.logDataFileList.isEmpty()) {
                this.createNewLogFile(this.metaFile.getParentFile().getPath(), this.meta.getCommitLogIndex() + 1L);
            }
        }
        catch (IOException e) {
            logger.error("Error in init log file: ", (Throwable)e);
        }
    }

    private void recoverLogFiles() {
        this.recoverLogFiles(LOG_INDEX_FILE_SUFFIX);
        this.recoverLogFiles(LOG_DATA_FILE_SUFFIX);
        this.logDataFileList.sort(this::comparePersistLogFileName);
        this.logIndexFileList.sort(this::comparePersistLogFileName);
        this.recoverTheLastLogFile();
    }

    private void recoverLogFiles(String logFileType) {
        FileFilter logFilter = pathname -> {
            String s = pathname.getName();
            return s.endsWith(logFileType);
        };
        List<File> logFiles = Arrays.asList(this.metaFile.getParentFile().listFiles(logFilter));
        logger.info("Find log type ={} log files {}", (Object)logFileType, logFiles);
        block8: for (File file : logFiles) {
            if (!this.checkLogFile(file, logFileType)) continue;
            switch (logFileType) {
                case "data": {
                    this.logDataFileList.add(file);
                    continue block8;
                }
                case "idx": {
                    this.logIndexFileList.add(file);
                    continue block8;
                }
            }
            logger.error("unknown file type={}", (Object)logFileType);
        }
    }

    private boolean checkLogFile(File file, String fileType) {
        if (file.length() == 0L || !file.getName().endsWith(fileType)) {
            try {
                if (file.exists() && !file.isDirectory() && file.length() == 0L) {
                    Files.delete(file.toPath());
                }
            }
            catch (IOException e) {
                logger.warn("Cannot delete empty log file {}", (Object)file, (Object)e);
            }
            return false;
        }
        long fileVersion = this.getFileVersion(file);
        if (fileVersion <= this.minAvailableVersion || fileVersion >= this.maxAvailableVersion) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete outdated log file {}", (Object)file);
            }
            return false;
        }
        String[] splits = file.getName().split("-");
        if (Long.parseLong(splits[0]) > Long.parseLong(splits[1])) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete incorrect log file {}", (Object)file);
            }
            return false;
        }
        return true;
    }

    private void recoverTheLastLogFile() {
        if (this.logIndexFileList.isEmpty()) {
            logger.info("no log index file to recover");
            return;
        }
        File lastIndexFile = this.logIndexFileList.get(this.logIndexFileList.size() - 1);
        long endIndex = Long.parseLong(lastIndexFile.getName().split("-")[1]);
        boolean success = true;
        if (endIndex != Long.MAX_VALUE) {
            logger.info("last log index file={} no need to recover", (Object)lastIndexFile.getAbsoluteFile());
        } else {
            success = this.recoverTheLastLogIndexFile(lastIndexFile);
        }
        if (!success) {
            logger.error("recover log index file failed, clear all logs in disk, {}", (Object)lastIndexFile.getAbsoluteFile());
            this.forceDeleteAllLogFiles();
            this.clearFirstLogIndex();
            return;
        }
        File lastDataFile = this.logDataFileList.get(this.logDataFileList.size() - 1);
        endIndex = Long.parseLong(lastDataFile.getName().split("-")[1]);
        if (endIndex != Long.MAX_VALUE) {
            logger.info("last log data file={} no need to recover", (Object)lastDataFile.getAbsoluteFile());
            return;
        }
        success = this.recoverTheLastLogDataFile(this.logDataFileList.get(this.logDataFileList.size() - 1));
        if (!success) {
            logger.error("recover log data file failed, clear all logs in disk,{}", (Object)lastDataFile.getAbsoluteFile());
            this.forceDeleteAllLogFiles();
            this.clearFirstLogIndex();
        }
    }

    private boolean recoverTheLastLogDataFile(File file) {
        String[] splits = file.getName().split("-");
        long startIndex = Long.parseLong(splits[0]);
        Pair<File, Pair<Long, Long>> fileStartAndEndIndex = this.getLogIndexFile(startIndex);
        if ((Long)((Pair)fileStartAndEndIndex.right).left == startIndex) {
            long endIndex = (Long)((Pair)fileStartAndEndIndex.right).right;
            String newDataFileName = file.getName().replaceAll(String.valueOf(Long.MAX_VALUE), String.valueOf(endIndex));
            File newLogDataFile = SystemFileFactory.INSTANCE.getFile(file.getParent() + File.separator + newDataFileName);
            if (!file.renameTo(newLogDataFile)) {
                logger.error("rename log data file={} failed when recover", (Object)file.getAbsoluteFile());
            }
            this.logDataFileList.remove(this.logDataFileList.size() - 1);
            this.logDataFileList.add(newLogDataFile);
            return true;
        }
        return false;
    }

    private boolean recoverTheLastLogIndexFile(File file) {
        File newLogIndexFile;
        logger.debug("start to recover the last log index file={}", (Object)file.getAbsoluteFile());
        String[] splits = file.getName().split("-");
        long startIndex = Long.parseLong(splits[0]);
        int longLength = 8;
        byte[] bytes = new byte[longLength];
        int totalCount = 0;
        long offset = 0L;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.firstLogIndex = startIndex;
            while (bufferedInputStream.read(bytes) != -1) {
                offset = BytesUtils.bytesToLong((byte[])bytes);
                this.logIndexOffsetList.add(offset);
                ++totalCount;
            }
        }
        catch (IOException e) {
            logger.error("recover log index file failed,", (Throwable)e);
        }
        long endIndex = startIndex + (long)totalCount - 1L;
        logger.debug("recover log index file={}, startIndex={}, endIndex={}", new Object[]{file.getAbsoluteFile(), startIndex, endIndex});
        if (endIndex < this.meta.getCommitLogIndex()) {
            logger.error("due to the last abnormal exit, part of the raft logs are lost. The commit index saved by the meta shall prevail, and all logs will be deletedmeta commitLogIndex={}, endIndex={}", (Object)this.meta.getCommitLogIndex(), (Object)endIndex);
            return false;
        }
        if (endIndex >= startIndex) {
            String newIndexFileName = file.getName().replaceAll(String.valueOf(Long.MAX_VALUE), String.valueOf(endIndex));
            newLogIndexFile = SystemFileFactory.INSTANCE.getFile(file.getParent() + File.separator + newIndexFileName);
            if (!file.renameTo(newLogIndexFile)) {
                logger.error("rename log index file={} failed when recover", (Object)file.getAbsoluteFile());
            }
        } else {
            logger.error("recover log index file failed,{}", (Object)file.getAbsoluteFile());
            return false;
        }
        this.logIndexFileList.set(this.logIndexFileList.size() - 1, newLogIndexFile);
        return true;
    }

    private void clearFirstLogIndex() {
        this.firstLogIndex = this.meta.getCommitLogIndex() + 1L;
        this.logIndexOffsetList.clear();
    }

    private void recoverMetaFile() {
        File tempMetaFile;
        this.metaFile = SystemFileFactory.INSTANCE.getFile(this.logDir + LOG_META);
        if (!this.metaFile.getParentFile().exists()) {
            this.metaFile.getParentFile().mkdirs();
        }
        if ((tempMetaFile = SystemFileFactory.INSTANCE.getFile(this.logDir + LOG_META_TMP)).exists()) {
            this.recoverMetaFileFromTemp(tempMetaFile);
        } else if (!this.metaFile.exists()) {
            this.createNewMetaFile();
        }
    }

    private void recoverMetaFileFromTemp(File tempMetaFile) {
        if (tempMetaFile.length() == 0L) {
            try {
                Files.delete(tempMetaFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete file {}", (Object)tempMetaFile);
            }
        } else {
            try {
                Files.deleteIfExists(this.metaFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete file {}", (Object)this.metaFile);
            }
            if (!tempMetaFile.renameTo(this.metaFile)) {
                logger.warn("Failed to rename log meta file");
            }
        }
    }

    private void createNewMetaFile() {
        try {
            if (!this.metaFile.createNewFile()) {
                logger.warn("Cannot create log meta file");
            }
        }
        catch (IOException e) {
            logger.error("Cannot create new log meta file ", (Throwable)e);
        }
    }

    private void checkStream() throws FileNotFoundException {
        if (this.currentLogDataOutputStream == null) {
            this.currentLogDataOutputStream = new FileOutputStream(this.getCurrentLogDataFile(), true);
            logger.info("{}: Opened a new log data file: {}", (Object)this, (Object)this.getCurrentLogDataFile());
        }
        if (this.currentLogIndexOutputStream == null) {
            this.currentLogIndexOutputStream = new FileOutputStream(this.getCurrentLogIndexFile(), true);
            logger.info("{}: Opened a new index data file: {}", (Object)this, (Object)this.getCurrentLogIndexFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewLogFile(String dirName, long startLogIndex) throws IOException {
        this.lock.lock();
        try {
            long nextVersion = this.versionController.nextVersion();
            long endLogIndex = Long.MAX_VALUE;
            String fileNamePrefix = dirName + File.separator + startLogIndex + "-" + endLogIndex + "-" + nextVersion + "-";
            File logDataFile = SystemFileFactory.INSTANCE.getFile(fileNamePrefix + LOG_DATA_FILE_SUFFIX);
            File logIndexFile = SystemFileFactory.INSTANCE.getFile(fileNamePrefix + LOG_INDEX_FILE_SUFFIX);
            if (!logDataFile.createNewFile()) {
                logger.warn("Cannot create new log data file {}", (Object)logDataFile);
            }
            if (!logIndexFile.createNewFile()) {
                logger.warn("Cannot create new log index file {}", (Object)logDataFile);
            }
            this.logDataFileList.add(logDataFile);
            this.logIndexFileList.add(logIndexFile);
        }
        finally {
            this.lock.unlock();
        }
    }

    private File getCurrentLogDataFile() {
        return this.logDataFileList.get(this.logDataFileList.size() - 1);
    }

    private File getCurrentLogIndexFile() {
        return this.logIndexFileList.get(this.logIndexFileList.size() - 1);
    }

    private void recoverMeta() {
        if (this.meta != null) {
            return;
        }
        if (this.metaFile.exists() && this.metaFile.length() > 0L) {
            if (logger.isInfoEnabled()) {
                SimpleDateFormat format = new SimpleDateFormat();
                logger.info("MetaFile {} exists, last modified: {}", (Object)this.metaFile.getPath(), (Object)format.format(new Date(this.metaFile.lastModified())));
            }
            try (FileInputStream fileInputStream = new FileInputStream(this.metaFile);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                this.minAvailableVersion = ReadWriteIOUtils.readLong((InputStream)bufferedInputStream);
                this.maxAvailableVersion = ReadWriteIOUtils.readLong((InputStream)bufferedInputStream);
                this.meta = LogManagerMeta.deserialize(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)bufferedInputStream)));
                this.state = HardState.deserialize(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)bufferedInputStream)));
            }
            catch (IOException e) {
                logger.error("Cannot recover log meta: ", (Throwable)e);
                this.meta = new LogManagerMeta();
                this.state = new HardState();
            }
        } else {
            this.meta = new LogManagerMeta();
            this.state = new HardState();
        }
        logger.info("Recovered log meta: {}, availableVersion: [{},{}], state: {}", new Object[]{this.meta, this.minAvailableVersion, this.maxAvailableVersion, this.state});
    }

    private void serializeMeta(LogManagerMeta meta) {
        File tempMetaFile = SystemFileFactory.INSTANCE.getFile(this.logDir + LOG_META_TMP);
        tempMetaFile.getParentFile().mkdirs();
        logger.trace("Serializing log meta into {}", (Object)tempMetaFile.getPath());
        try (FileOutputStream tempMetaFileOutputStream = new FileOutputStream(tempMetaFile);){
            ReadWriteIOUtils.write((long)this.minAvailableVersion, (OutputStream)tempMetaFileOutputStream);
            ReadWriteIOUtils.write((long)this.maxAvailableVersion, (OutputStream)tempMetaFileOutputStream);
            ReadWriteIOUtils.write((ByteBuffer)meta.serialize(), (OutputStream)tempMetaFileOutputStream);
            ReadWriteIOUtils.write((ByteBuffer)this.state.serialize(), (OutputStream)tempMetaFileOutputStream);
        }
        catch (IOException e) {
            logger.error("Error in serializing log meta: ", (Throwable)e);
        }
        try {
            Files.deleteIfExists(this.metaFile.toPath());
        }
        catch (IOException e) {
            logger.warn("Cannot delete old log meta file {}", (Object)this.metaFile, (Object)e);
        }
        if (!tempMetaFile.renameTo(this.metaFile)) {
            logger.warn("Cannot rename new log meta file {}", (Object)tempMetaFile);
        }
        this.meta = meta;
        logger.trace("Serialized log meta into {}", (Object)tempMetaFile.getPath());
    }

    @Override
    public void close() {
        logger.info("{} is closing", (Object)this);
        this.lock.lock();
        this.forceFlushLogBuffer();
        try {
            this.closeCurrentFile(this.meta.getCommitLogIndex());
            if (this.persistLogDeleteExecutorService != null) {
                this.persistLogDeleteExecutorService.shutdownNow();
                this.persistLogDeleteLogFuture.cancel(true);
                this.persistLogDeleteExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
                this.persistLogDeleteExecutorService = null;
            }
        }
        catch (IOException e) {
            logger.error("Error in log serialization: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Close persist log delete thread interrupted");
        }
        finally {
            logger.info("{} is closed", (Object)this);
            this.isClosed = true;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllLogs(long commitIndex) {
        this.lock.lock();
        try {
            this.forceFlushLogBuffer();
            this.closeCurrentFile(this.meta.getCommitLogIndex());
            this.forceDeleteAllLogFiles();
            this.deleteMetaFile();
            this.logDataFileList.clear();
            this.logIndexFileList.clear();
            this.firstLogIndex = !this.logIndexOffsetList.isEmpty() ? Math.max(commitIndex + 1L, this.firstLogIndex + (long)this.logIndexOffsetList.size()) : commitIndex + 1L;
            this.logIndexOffsetList.clear();
            this.recoverMetaFile();
            this.meta = new LogManagerMeta();
            this.createNewLogFile(this.logDir, this.firstLogIndex);
            logger.info("{}, clean all logs success, the new firstLogIndex={}", (Object)this, (Object)this.firstLogIndex);
        }
        catch (IOException e) {
            logger.error("clear all logs failed,", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void deleteMetaFile() {
        this.lock.lock();
        try {
            File tmpMetaFile = SystemFileFactory.INSTANCE.getFile(this.logDir + LOG_META_TMP);
            Files.deleteIfExists(tmpMetaFile.toPath());
            File localMetaFile = SystemFileFactory.INSTANCE.getFile(this.logDir + LOG_META);
            Files.deleteIfExists(localMetaFile.toPath());
        }
        catch (IOException e) {
            logger.error("{}: delete meta log files failed", (Object)this, (Object)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private long getFileVersion(File file) {
        return Long.parseLong(file.getName().split("-")[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDeletePersistRaftLog() {
        this.lock.lock();
        try {
            if (this.logIndexOffsetList.size() > this.maxRaftLogIndexSizeInMemory) {
                int compactIndex = this.logIndexOffsetList.size() - this.maxRaftLogIndexSizeInMemory;
                this.logIndexOffsetList.subList(0, compactIndex).clear();
                this.firstLogIndex += (long)compactIndex;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.lock.lock();
        try {
            while (this.logDataFileList.size() > this.maxNumberOfPersistRaftLogFiles) {
                this.deleteTheFirstLogDataAndIndexFile();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.lock.lock();
        try {
            while (this.logDataFileList.size() > 1) {
                File firstFile = this.logDataFileList.get(0);
                String[] splits = firstFile.getName().split("-");
                if (this.meta.getCommitLogIndex() - Long.parseLong(splits[1]) <= (long)this.maxPersistRaftLogNumberOnDisk) {
                    return;
                }
                this.deleteTheFirstLogDataAndIndexFile();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void forceDeleteAllLogDataFiles() {
        FileFilter logFilter = pathname -> {
            String s = pathname.getName();
            return s.endsWith(LOG_DATA_FILE_SUFFIX);
        };
        List<File> logFiles = Arrays.asList(this.metaFile.getParentFile().listFiles(logFilter));
        logger.info("get log data files {} when forcing delete all logs", logFiles);
        for (File logFile : logFiles) {
            try {
                FileUtils.forceDelete((File)logFile);
            }
            catch (IOException e) {
                logger.error("forcing delete log data file={} failed", (Object)logFile.getAbsoluteFile(), (Object)e);
            }
        }
        this.logDataFileList.clear();
    }

    private void forceDeleteAllLogIndexFiles() {
        FileFilter logIndexFilter = pathname -> {
            String s = pathname.getName();
            return s.endsWith(LOG_INDEX_FILE_SUFFIX);
        };
        List<File> logIndexFiles = Arrays.asList(this.metaFile.getParentFile().listFiles(logIndexFilter));
        logger.info("get log index files {} when forcing delete all logs", logIndexFiles);
        for (File logFile : logIndexFiles) {
            try {
                FileUtils.forceDelete((File)logFile);
            }
            catch (IOException e) {
                logger.error("forcing delete log index file={} failed", (Object)logFile.getAbsoluteFile(), (Object)e);
            }
        }
        this.logIndexFileList.clear();
    }

    private void forceDeleteAllLogFiles() {
        while (!this.logDataFileList.isEmpty()) {
            boolean success = this.deleteTheFirstLogDataAndIndexFile();
            if (success) continue;
            this.forceDeleteAllLogDataFiles();
            this.forceDeleteAllLogIndexFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteTheFirstLogDataAndIndexFile() {
        if (this.logDataFileList.isEmpty()) {
            return true;
        }
        File logDataFile = null;
        File logIndexFile = null;
        this.lock.lock();
        try {
            logDataFile = this.logDataFileList.get(0);
            logIndexFile = this.logIndexFileList.get(0);
            if (logDataFile == null || logIndexFile == null) {
                logger.error("the log data or index file is null, some error occurred");
                boolean bl = false;
                return bl;
            }
            Files.delete(logDataFile.toPath());
            Files.delete(logIndexFile.toPath());
            this.logDataFileList.remove(0);
            this.logIndexFileList.remove(0);
            logger.debug("delete date file={}, index file={}", (Object)logDataFile.getAbsoluteFile(), (Object)logIndexFile.getAbsoluteFile());
        }
        catch (IOException e) {
            logger.error("delete file failed, data file={}, index file={}", (Object)logDataFile.getAbsoluteFile(), (Object)logIndexFile.getAbsoluteFile());
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private int comparePersistLogFileName(File file1, File file2) {
        long startLogIndex2;
        long startLogIndex1;
        int res;
        String[] items1 = file1.getName().split("-");
        String[] items2 = file2.getName().split("-");
        if (items1.length != 4 || items2.length != 4) {
            logger.error("file1={}, file2={} name should be in the following format: startLogIndex-endLogIndex-version-data", (Object)file1.getAbsoluteFile(), (Object)file2.getAbsoluteFile());
        }
        if ((res = Long.compare(startLogIndex1 = Long.parseLong(items1[0]), startLogIndex2 = Long.parseLong(items2[0]))) == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Log> getLogs(long startIndex, long endIndex) {
        if (startIndex > endIndex) {
            logger.error("startIndex={} should be less than or equal to endIndex={}", (Object)startIndex, (Object)endIndex);
            return Collections.emptyList();
        }
        if (startIndex < 0L || endIndex < 0L) {
            logger.error("startIndex={} and endIndex={} should be larger than zero", (Object)startIndex, (Object)endIndex);
            return Collections.emptyList();
        }
        long newEndIndex = endIndex;
        if (endIndex - startIndex > (long)MAX_NUMBER_OF_LOGS_PER_FETCH_ON_DISK) {
            newEndIndex = startIndex + (long)MAX_NUMBER_OF_LOGS_PER_FETCH_ON_DISK;
        }
        logger.debug("intend to get logs between[{}, {}], actually get logs between[{},{}]", new Object[]{startIndex, endIndex, startIndex, newEndIndex});
        this.lock.lock();
        try {
            List<Pair<File, Pair<Long, Long>>> logDataFileAndOffsetList = this.getLogDataFileAndOffset(startIndex, newEndIndex);
            if (logDataFileAndOffsetList.isEmpty()) {
                List<Log> list = Collections.emptyList();
                return list;
            }
            ArrayList<Log> result = new ArrayList<Log>();
            for (Pair<File, Pair<Long, Long>> pair : logDataFileAndOffsetList) {
                result.addAll(this.getLogsFromOneLogDataFile((File)pair.left, (Pair<Long, Long>)((Pair)pair.right)));
            }
            ArrayList<Log> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public long getOffsetAccordingToLogIndex(long logIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Pair<File, Pair<Long, Long>>> getLogDataFileAndOffset(long startIndex, long endIndex) {
        long endOffset;
        long startIndexInOneFile = startIndex;
        long endIndexInOneFile = 0L;
        ArrayList<Pair<File, Pair<Long, Long>>> fileNameWithStartAndEndOffset = new ArrayList<Pair<File, Pair<Long, Long>>>();
        long startOffset = this.getOffsetAccordingToLogIndex(startIndexInOneFile);
        if (startOffset == -1L) {
            return Collections.emptyList();
        }
        Pair<File, Pair<Long, Long>> logDataFileWithStartAndEndLogIndex = this.getLogDataFile(startIndexInOneFile);
        if (logDataFileWithStartAndEndLogIndex == null) {
            return Collections.emptyList();
        }
        endIndexInOneFile = (Long)((Pair)logDataFileWithStartAndEndLogIndex.right).right;
        while (endIndex > endIndexInOneFile) {
            endOffset = this.getOffsetAccordingToLogIndex(endIndexInOneFile);
            fileNameWithStartAndEndOffset.add(new Pair(logDataFileWithStartAndEndLogIndex.left, (Object)new Pair((Object)startOffset, (Object)endOffset)));
            logger.debug("get log data offset=[{},{}] according to log index=[{},{}], file={}", new Object[]{startOffset, endOffset, startIndexInOneFile, endIndexInOneFile, logDataFileWithStartAndEndLogIndex.left});
            startIndexInOneFile = endIndexInOneFile + 1L;
            startOffset = this.getOffsetAccordingToLogIndex(startIndexInOneFile);
            if (startOffset == -1L) {
                return Collections.emptyList();
            }
            logDataFileWithStartAndEndLogIndex = this.getLogDataFile(startIndexInOneFile);
            if (logDataFileWithStartAndEndLogIndex == null) {
                return Collections.emptyList();
            }
            endIndexInOneFile = (Long)((Pair)logDataFileWithStartAndEndLogIndex.right).right;
        }
        endOffset = this.getOffsetAccordingToLogIndex(endIndex);
        fileNameWithStartAndEndOffset.add(new Pair(logDataFileWithStartAndEndLogIndex.left, (Object)new Pair((Object)startOffset, (Object)endOffset)));
        logger.debug("get log data offset=[{},{}] according to log index=[{},{}], file={}", new Object[]{startOffset, endOffset, startIndexInOneFile, endIndex, logDataFileWithStartAndEndLogIndex.left});
        return fileNameWithStartAndEndOffset;
    }

    public Pair<File, Pair<Long, Long>> getLogIndexFile(long startIndex) {
        for (File file : this.logIndexFileList) {
            String[] splits = file.getName().split("-");
            if (splits.length != 4) {
                logger.error("file={} name should be in the following format: startLogIndex-endLogIndex-version-idx", (Object)file.getAbsoluteFile());
            }
            if (Long.parseLong(splits[0]) > startIndex || startIndex > Long.parseLong(splits[1])) continue;
            return new Pair((Object)file, (Object)new Pair((Object)Long.parseLong(splits[0]), (Object)Long.parseLong(splits[1])));
        }
        logger.debug("can not found the log index file for startIndex={}", (Object)startIndex);
        return null;
    }

    public Pair<File, Pair<Long, Long>> getLogDataFile(long startIndex) {
        for (File file : this.logDataFileList) {
            String[] splits = file.getName().split("-");
            if (splits.length != 4) {
                logger.error("file={} name should be in the following format: startLogIndex-endLogIndex-version-data", (Object)file.getAbsoluteFile());
            }
            if (Long.parseLong(splits[0]) > startIndex || startIndex > Long.parseLong(splits[1])) continue;
            return new Pair((Object)file, (Object)new Pair((Object)Long.parseLong(splits[0]), (Object)Long.parseLong(splits[1])));
        }
        logger.debug("can not found the log data file for startIndex={}", (Object)startIndex);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Log> getLogsFromOneLogDataFile(File file, Pair<Long, Long> startAndEndOffset) {
        ArrayList<Log> result = new ArrayList<Log>();
        if (file.getName().equals(this.getCurrentLogDataFile().getName())) {
            this.forceFlushLogBufferWithoutCloseFile();
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            long bytesSkip = bufferedInputStream.skip((Long)startAndEndOffset.left);
            if (bytesSkip != (Long)startAndEndOffset.left) {
                logger.error("read file={} failed when skip {} bytes, actual skip bytes={}", new Object[]{file.getAbsoluteFile(), startAndEndOffset.left, bytesSkip});
                ArrayList<Log> arrayList = result;
                return arrayList;
            }
            logger.debug("start to read file={} and skip {} bytes, startOffset={}, endOffset={}, fileLength={}", new Object[]{file.getAbsoluteFile(), bytesSkip, startAndEndOffset.left, startAndEndOffset.right, file.length()});
            long currentReadOffset = bytesSkip;
            while (currentReadOffset <= (Long)startAndEndOffset.right) {
                logger.debug("read file={}, currentReadOffset={}, end offset={}", new Object[]{file.getAbsoluteFile(), currentReadOffset, startAndEndOffset.right});
                int logSize = ReadWriteIOUtils.readInt((InputStream)bufferedInputStream);
                Log log = null;
                log = this.parser.parse(ByteBuffer.wrap(ReadWriteIOUtils.readBytes((InputStream)bufferedInputStream, (int)logSize)));
                result.add(log);
                currentReadOffset = currentReadOffset + 4L + (long)logSize;
            }
            return result;
        }
        catch (UnknownLogTypeException e) {
            logger.error("Unknown log detected ", (Throwable)e);
            return result;
        }
        catch (IOException e) {
            logger.error("Cannot read log from file={} ", (Object)file.getAbsoluteFile(), (Object)e);
        }
        return result;
    }

    public void setLogDataBuffer(ByteBuffer logDataBuffer) {
        this.logDataBuffer = logDataBuffer;
    }

    public void setMaxRaftLogPersistDataSizePerFile(int maxRaftLogPersistDataSizePerFile) {
        this.maxRaftLogPersistDataSizePerFile = maxRaftLogPersistDataSizePerFile;
    }

    public void setMaxNumberOfPersistRaftLogFiles(int maxNumberOfPersistRaftLogFiles) {
        this.maxNumberOfPersistRaftLogFiles = maxNumberOfPersistRaftLogFiles;
    }

    public List<File> getLogDataFileList() {
        return this.logDataFileList;
    }

    public List<File> getLogIndexFileList() {
        return this.logIndexFileList;
    }
}

