/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementInsideTemplateException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.metadata.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.StorageGroupCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MNodeLevelCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementGroupByLevelCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.StorageGroupCounter;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTree
implements Serializable {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final long serialVersionUID = -4200394435237291964L;
    private static final Logger logger = LoggerFactory.getLogger(MTree.class);
    private IMNode root;
    private String mtreeSnapshotPath;
    private String mtreeSnapshotTmpPath;

    public MTree() {
        this.root = new InternalMNode(null, "root");
    }

    private MTree(InternalMNode root) {
        this.root = root;
    }

    public void init() throws IOException {
        this.mtreeSnapshotPath = IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mtree-1.snapshot.bin";
        this.mtreeSnapshotTmpPath = IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "mtree-1.snapshot.bin.tmp";
        File tmpFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath);
        if (tmpFile.exists()) {
            logger.warn("Creating MTree snapshot not successful before crashing...");
            Files.delete(tmpFile.toPath());
        }
        File mtreeSnapshot = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotPath);
        long time = System.currentTimeMillis();
        if (mtreeSnapshot.exists()) {
            this.root = MTree.deserializeFrom((File)mtreeSnapshot).root;
            logger.debug("spend {} ms to deserialize mtree from snapshot", (Object)(System.currentTimeMillis() - time));
        }
    }

    public void clear() {
        this.root = new InternalMNode(null, "root");
    }

    public void createSnapshot() throws IOException {
        long time = System.currentTimeMillis();
        logger.info("Start creating MTree snapshot to {}", (Object)this.mtreeSnapshotPath);
        try {
            this.serializeTo(this.mtreeSnapshotTmpPath);
            File tmpFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath);
            File snapshotFile = SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotPath);
            if (snapshotFile.exists()) {
                Files.delete(snapshotFile.toPath());
            }
            if (tmpFile.renameTo(snapshotFile)) {
                logger.info("Finish creating MTree snapshot to {}, spend {} ms.", (Object)this.mtreeSnapshotPath, (Object)(System.currentTimeMillis() - time));
            }
        }
        catch (IOException e) {
            logger.warn("Failed to create MTree snapshot to {}", (Object)this.mtreeSnapshotPath, (Object)e);
            if (SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath).exists()) {
                try {
                    Files.delete(SystemFileFactory.INSTANCE.getFile(this.mtreeSnapshotTmpPath).toPath());
                }
                catch (IOException e1) {
                    logger.warn("delete file {} failed: {}", (Object)this.mtreeSnapshotTmpPath, (Object)e1.getMessage());
                }
            }
            throw e;
        }
    }

    private static String jsonToString(JsonObject jsonObject) {
        return GSON.toJson((JsonElement)jsonObject);
    }

    public void serializeTo(String snapshotPath) throws IOException {
        try (MLogWriter mLogWriter = new MLogWriter(snapshotPath);){
            this.root.serializeTo(mLogWriter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MTree deserializeFrom(File mtreeSnapshot) {
        try (MLogReader mLogReader = new MLogReader(mtreeSnapshot);){
            MTree mTree = new MTree(MTree.deserializeFromReader(mLogReader));
            return mTree;
        }
        catch (IOException e) {
            logger.warn("Failed to deserialize from {}. Use a new MTree.", (Object)mtreeSnapshot.getPath());
            return new MTree();
        }
    }

    private static InternalMNode deserializeFromReader(MLogReader mLogReader) {
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        IMNode node = null;
        while (mLogReader.hasNext()) {
            PhysicalPlan plan = null;
            try {
                plan = mLogReader.next();
                if (plan == null) continue;
                int childrenSize = 0;
                if (plan instanceof StorageGroupMNodePlan) {
                    node = StorageGroupMNode.deserializeFrom((StorageGroupMNodePlan)plan);
                    childrenSize = ((StorageGroupMNodePlan)plan).getChildSize();
                } else if (plan instanceof MeasurementMNodePlan) {
                    node = MeasurementMNode.deserializeFrom((MeasurementMNodePlan)plan);
                    childrenSize = ((MeasurementMNodePlan)plan).getChildSize();
                } else if (plan instanceof MNodePlan) {
                    node = InternalMNode.deserializeFrom((MNodePlan)plan);
                    childrenSize = ((MNodePlan)plan).getChildSize();
                }
                if (childrenSize != 0) {
                    ConcurrentHashMap<String, IMNode> childrenMap = new ConcurrentHashMap<String, IMNode>();
                    for (int i = 0; i < childrenSize; ++i) {
                        IMNode child = (IMNode)nodeStack.removeFirst();
                        childrenMap.put(child.getName(), child);
                        if (child.isMeasurement()) {
                            String alias;
                            if (!node.isEntity()) {
                                node = MNodeUtils.setToEntity(node);
                            }
                            if ((alias = child.getAsMeasurementMNode().getAlias()) != null) {
                                node.getAsEntityMNode().addAlias(alias, child.getAsMeasurementMNode());
                            }
                        }
                        child.setParent(node);
                    }
                    node.setChildren(childrenMap);
                }
                nodeStack.push(node);
            }
            catch (Exception e) {
                logger.error("Can not operate cmd {} for err:", plan == null ? "" : plan.getOperatorType(), (Object)e);
            }
        }
        if (!"root".equals(node.getName())) {
            logger.error("Snapshot file corrupted!");
        }
        return (InternalMNode)node;
    }

    public String toString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(this.root.getName(), (JsonElement)this.mNodeToJSON(this.root, null));
        return MTree.jsonToString(jsonObject);
    }

    private JsonObject mNodeToJSON(IMNode node, String storageGroupName) {
        JsonObject jsonObject = new JsonObject();
        if (node.getChildren().size() > 0) {
            if (node.isStorageGroup()) {
                storageGroupName = node.getFullPath();
            }
            for (IMNode child : node.getChildren().values()) {
                jsonObject.add(child.getName(), (JsonElement)this.mNodeToJSON(child, storageGroupName));
            }
        } else if (node.isMeasurement()) {
            IMeasurementMNode leafMNode = node.getAsMeasurementMNode();
            jsonObject.add("DataType", GSON.toJsonTree((Object)leafMNode.getSchema().getType()));
            jsonObject.add("Encoding", GSON.toJsonTree((Object)leafMNode.getSchema().getEncodingType()));
            jsonObject.add("Compressor", GSON.toJsonTree((Object)leafMNode.getSchema().getCompressor()));
            if (leafMNode.getSchema().getProps() != null) {
                jsonObject.addProperty("args", leafMNode.getSchema().getProps().toString());
            }
            jsonObject.addProperty("StorageGroup", storageGroupName);
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        Pair<IMNode, Template> pair = this.checkAndAutoCreateInternalPath(devicePath);
        IMNode cur = (IMNode)pair.left;
        Template upperTemplate = (Template)pair.right;
        MTree mTree = this;
        synchronized (mTree) {
            pair = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), cur, upperTemplate);
            cur = (IMNode)pair.left;
            upperTemplate = (Template)pair.right;
            MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
            String leafName = path.getMeasurement();
            if (cur.hasChild(leafName)) {
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (alias != null && cur.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            if (upperTemplate != null && (upperTemplate.getDirectNode(leafName) != null || upperTemplate.getDirectNode(alias) != null)) {
                throw new TemplateImcompatibeException(path.getFullPath(), upperTemplate.getName());
            }
            if (cur.isEntity() && cur.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("Timeseries under this entity is aligned, please use createAlignedTimeseries or change entity.", cur.getFullPath());
            }
            IEntityMNode entityMNode = MNodeUtils.setToEntity(cur);
            IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
            entityMNode.addChild(leafName, measurementMNode);
            if (alias != null) {
                entityMNode.addAlias(alias, measurementMNode);
            }
            return measurementMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        Pair<IMNode, Template> pair = this.checkAndAutoCreateInternalPath(devicePath);
        IMNode cur = (IMNode)pair.left;
        Template upperTemplate = (Template)pair.right;
        MTree mTree = this;
        synchronized (mTree) {
            pair = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), cur, upperTemplate);
            cur = (IMNode)pair.left;
            upperTemplate = (Template)pair.right;
            for (String measurement : measurements) {
                if (!cur.hasChild(measurement)) continue;
                throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurement);
            }
            if (upperTemplate != null) {
                for (String measurement : measurements) {
                    if (upperTemplate.getDirectNode(measurement) == null) continue;
                    throw new TemplateImcompatibeException(devicePath.concatNode(measurement).getFullPath(), upperTemplate.getName());
                }
            }
            if (cur.isEntity() && !cur.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("Timeseries under this entity is not aligned, please use createTimeseries or change entity.", devicePath.getFullPath());
            }
            IEntityMNode entityMNode = MNodeUtils.setToEntity(cur);
            entityMNode.setAligned(true);
            for (int i = 0; i < measurements.size(); ++i) {
                IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), null);
                entityMNode.addChild(measurements.get(i), measurementMNode);
            }
        }
    }

    private Pair<IMNode, Template> checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        if (nodeNames.length < 2 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(devicePath.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(devicePath);
        IMNode cur = this.root;
        boolean hasSetStorageGroup = false;
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = 1; i < nodeNames.length - 1; ++i) {
            String childName = nodeNames[i];
            if (!cur.hasChild(childName)) {
                if (!hasSetStorageGroup) {
                    throw new StorageGroupNotSetException("Storage group should be created first");
                }
                if (upperTemplate != null && upperTemplate.getDirectNode(childName) != null) {
                    throw new PathAlreadyExistException(cur.getPartialPath().concatNode(childName).getFullPath() + " ( which is incompatible with template )");
                }
                cur.addChild(childName, new InternalMNode(cur, childName));
            }
            if ((cur = cur.getChild(childName)).isMeasurement()) {
                throw new PathAlreadyExistException(cur.getFullPath());
            }
            if (cur.isStorageGroup()) {
                hasSetStorageGroup = true;
            }
            if (cur.getSchemaTemplate() == null) continue;
            upperTemplate = cur.getSchemaTemplate();
        }
        return new Pair((Object)cur, (Object)upperTemplate);
    }

    private Pair<IMNode, Template> checkAndAutoCreateDeviceNode(String deviceName, IMNode deviceParent, Template upperTemplate) throws PathAlreadyExistException, TemplateImcompatibeException {
        IMNode device;
        if (!deviceParent.hasChild(deviceName)) {
            if (upperTemplate != null && upperTemplate.getDirectNode(deviceName) != null) {
                throw new TemplateImcompatibeException(deviceParent.getPartialPath().concatNode(deviceName).getFullPath(), upperTemplate.getName(), deviceName);
            }
            deviceParent.addChild(deviceName, new InternalMNode(deviceParent, deviceName));
        }
        if ((device = deviceParent.getChild(deviceName)).isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        if (device.getSchemaTemplate() != null) {
            upperTemplate = device.getSchemaTemplate();
        }
        return new Pair((Object)device, (Object)upperTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<PartialPath, IMeasurementMNode> deleteTimeseriesAndReturnEmptyStorageGroup(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !"root".equals(nodes[0])) {
            throw new IllegalPathException(path.getFullPath());
        }
        if (this.isPathExistsWithinTemplate(path)) {
            throw new MeasurementInsideTemplateException(path.getFullPath());
        }
        IMeasurementMNode deletedNode = this.getMeasurementMNode(path);
        IEntityMNode parent = deletedNode.getParent();
        parent.deleteChild(path.getMeasurement());
        if (deletedNode.getAlias() != null) {
            parent.deleteAliasChild(deletedNode.getAlias());
        }
        IMNode curNode = parent;
        if (!parent.isUseTemplate()) {
            boolean hasMeasurement = false;
            for (IMNode child : parent.getChildren().values()) {
                if (!child.isMeasurement()) continue;
                hasMeasurement = true;
                break;
            }
            if (!hasMeasurement) {
                MTree mTree = this;
                synchronized (mTree) {
                    curNode = MNodeUtils.setToInternal(parent);
                }
            }
        }
        while (curNode.isEmptyInternal()) {
            if (curNode.isStorageGroup()) {
                return new Pair((Object)curNode.getPartialPath(), (Object)deletedNode);
            }
            curNode.getParent().deleteChild(curNode.getName());
            curNode = curNode.getParent();
        }
        return new Pair(null, (Object)deletedNode);
    }

    public IMNode getDeviceNodeWithAutoCreating(PartialPath deviceId, int sgLevel) throws MetadataException {
        String[] nodeNames = deviceId.getNodes();
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(deviceId.getFullPath());
        }
        IMNode cur = this.root;
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                if (cur.isUseTemplate() && upperTemplate.getDirectNode(nodeNames[i]) != null) {
                    throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
                }
                if (i == sgLevel) {
                    cur.addChild(nodeNames[i], new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL()));
                } else {
                    cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
                }
            }
            upperTemplate = (cur = cur.getChild(nodeNames[i])).getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntityMNode setToEntity(IMNode node) {
        MTree mTree = this;
        synchronized (mTree) {
            return MNodeUtils.setToEntity(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        MetaFormatUtils.checkStorageGroup(path.getFullPath());
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        Template upperTemplate = cur.getSchemaTemplate();
        for (i = 1; i < nodeNames.length - 1; ++i) {
            IMNode temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                if (cur.isUseTemplate() && upperTemplate.hasSchema(nodeNames[i])) {
                    throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
                }
                cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            } else if (temp.isStorageGroup()) {
                throw new StorageGroupAlreadySetException(temp.getFullPath());
            }
            cur = cur.getChild(nodeNames[i]);
            upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        MTree mTree = this;
        synchronized (mTree) {
            if (cur.hasChild(nodeNames[i])) {
                if (cur.getChild(nodeNames[i]).isStorageGroup()) {
                    throw new StorageGroupAlreadySetException(path.getFullPath());
                }
                throw new StorageGroupAlreadySetException(path.getFullPath(), true);
            }
            if (cur.isUseTemplate() && upperTemplate.hasSchema(nodeNames[i])) {
                throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
            }
            StorageGroupMNode storageGroupMNode = new StorageGroupMNode(cur, nodeNames[i], IoTDBDescriptor.getInstance().getConfig().getDefaultTTL());
            cur.addChild(nodeNames[i], storageGroupMNode);
        }
    }

    public List<IMeasurementMNode> deleteStorageGroup(PartialPath path) throws MetadataException {
        IMNode cur = this.getNodeByPath(path);
        if (!cur.isStorageGroup()) {
            throw new StorageGroupNotSetException(path.getFullPath());
        }
        cur.getParent().deleteChild(cur.getName());
        LinkedList<IMeasurementMNode> leafMNodes = new LinkedList<IMeasurementMNode>();
        LinkedList<IMNode> queue = new LinkedList<IMNode>();
        queue.add(cur);
        while (!queue.isEmpty()) {
            IMNode node = (IMNode)queue.poll();
            for (IMNode child : node.getChildren().values()) {
                if (child.isMeasurement()) {
                    leafMNodes.add(child.getAsMeasurementMNode());
                    continue;
                }
                queue.add(child);
            }
        }
        cur = cur.getParent();
        while (!"root".equals(cur.getName()) && cur.getChildren().size() == 0) {
            cur.getParent().deleteChild(cur.getName());
            cur = cur.getParent();
        }
        return leafMNodes;
    }

    public boolean isPathExist(PartialPath path) {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                if (!cur.isUseTemplate() || upperTemplate.getDirectNode(nodeNames[i]) == null) {
                    return false;
                }
                cur = upperTemplate.getDirectNode(nodeNames[i]);
            } else {
                cur = cur.getChild(nodeNames[i]);
            }
            if (cur.isMeasurement()) {
                return i == nodeNames.length - 1;
            }
            upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        return true;
    }

    public boolean isStorageGroup(PartialPath path) {
        int i;
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 1 || !nodeNames[0].equals("root")) {
            return false;
        }
        IMNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            if ((cur = cur.getChild(nodeNames[i])) != null && !cur.isStorageGroup()) continue;
            return false;
        }
        return (cur = cur.getChild(nodeNames[i])) != null && cur.isStorageGroup();
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        String[] nodes = path.getNodes();
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                return false;
            }
            if (!cur.isStorageGroup()) continue;
            return true;
        }
        return false;
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        String[] nodes = path.getNodes();
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                throw new StorageGroupNotSetException(path.getFullPath());
            }
            if (!cur.isStorageGroup()) continue;
            return cur.getPartialPath();
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.collectStorageGroups(pathPattern, false, true);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.collectStorageGroups(pathPattern, isPrefixMatch, false);
    }

    private List<PartialPath> collectStorageGroups(PartialPath pathPattern, boolean isPrefixMatch, boolean collectInternal) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        StorageGroupCollector<List<PartialPath>> collector = new StorageGroupCollector<List<PartialPath>>(this.root, pathPattern){

            @Override
            protected void collectStorageGroup(IStorageGroupMNode node) {
                result.add(node.getPartialPath());
            }
        };
        collector.setCollectInternal(collectInternal);
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IMNode current = (IMNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    public Map<String, List<PartialPath>> groupPathByStorageGroup(final PartialPath path) throws MetadataException {
        final HashMap<String, List<PartialPath>> result = new HashMap<String, List<PartialPath>>();
        StorageGroupCollector<Map<String, String>> collector = new StorageGroupCollector<Map<String, String>>(this.root, path){

            @Override
            protected void collectStorageGroup(IStorageGroupMNode node) {
                PartialPath sgPath = node.getPartialPath();
                result.put(sgPath.getFullPath(), path.alterPrefixPath(sgPath));
            }
        };
        collector.setCollectInternal(true);
        collector.traverse();
        return result;
    }

    public Set<PartialPath> getDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        final TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        EntityCollector<Set<PartialPath>> collector = new EntityCollector<Set<PartialPath>>(this.root, pathPattern){

            @Override
            protected void collectEntity(IEntityMNode node) throws MetadataException {
                result.add(this.getCurrentPartialPath(node));
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    public List<ShowDevicesResult> getDevices(final ShowDevicesPlan plan) throws MetadataException {
        final ArrayList<ShowDevicesResult> res = new ArrayList<ShowDevicesResult>();
        EntityCollector<List<ShowDevicesResult>> collector = new EntityCollector<List<ShowDevicesResult>>(this.root, plan.getPath(), plan.getLimit(), plan.getOffset()){

            @Override
            protected void collectEntity(IEntityMNode node) throws MetadataException {
                PartialPath device = this.getCurrentPartialPath(node);
                if (plan.hasSgCol()) {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned(), MTree.this.getBelongedStorageGroup(device).getFullPath()));
                } else {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned()));
                }
            }
        };
        collector.setPrefixMatch(plan.isPrefixMatch());
        collector.traverse();
        return res;
    }

    public Set<PartialPath> getDevicesByTimeseries(PartialPath timeseries) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        MeasurementCollector<Set<PartialPath>> collector = new MeasurementCollector<Set<PartialPath>>(this.root, timeseries){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                result.add(this.getCurrentPartialPath(node).getDevicePath());
            }
        };
        collector.traverse();
        return result;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch).left;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) throws MetadataException {
        final LinkedList result = new LinkedList();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>(this.root, pathPattern, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                result.add(path);
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        offset = collector.getCurOffset() + 1;
        return new Pair(result, (Object)offset);
    }

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset) throws MetadataException {
        return this.getMeasurementPathsWithAlias(pathPattern, limit, offset, false);
    }

    public List<Pair<PartialPath, String[]>> getAllMeasurementSchemaByHeatOrder(ShowTimeSeriesPlan plan, QueryContext queryContext) throws MetadataException {
        List<Pair<PartialPath, String[]>> allMatchedNodes = this.collectMeasurementSchema(plan.getPath(), 0, 0, queryContext, true, plan.isPrefixMatch());
        Stream<Pair> sortedStream = allMatchedNodes.stream().sorted(Comparator.comparingLong(p -> Long.parseLong(((String[])p.right)[6])).reversed().thenComparing(p -> (PartialPath)p.left));
        if (plan.getLimit() == 0) {
            return sortedStream.collect(Collectors.toList());
        }
        return sortedStream.skip(plan.getOffset()).limit(plan.getLimit()).collect(Collectors.toList());
    }

    public List<Pair<PartialPath, String[]>> getAllMeasurementSchema(ShowTimeSeriesPlan plan) throws MetadataException {
        return this.collectMeasurementSchema(plan.getPath(), plan.getLimit(), plan.getOffset(), null, false, plan.isPrefixMatch());
    }

    private List<Pair<PartialPath, String[]>> collectMeasurementSchema(PartialPath pathPattern, int limit, int offset, final QueryContext queryContext, final boolean needLast, boolean isPrefixMatch) throws MetadataException {
        final LinkedList<Pair<PartialPath, String[]>> result = new LinkedList<Pair<PartialPath, String[]>>();
        MeasurementCollector<List<Pair<PartialPath, String[]>>> collector = new MeasurementCollector<List<Pair<PartialPath, String[]>>>(this.root, pathPattern, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                IMeasurementSchema measurementSchema = node.getSchema();
                String[] tsRow = new String[]{node.getAlias(), this.getStorageGroupNodeInTraversePath().getFullPath(), measurementSchema.getType().toString(), measurementSchema.getEncodingType().toString(), measurementSchema.getCompressor().toString(), String.valueOf(node.getOffset()), needLast ? String.valueOf(LastCacheManager.getLastTimeStamp(node, queryContext)) : null};
                Pair temp = new Pair((Object)this.getCurrentPartialPath(node), (Object)tsRow);
                result.add(temp);
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    private PartialPath getBelongedStorageGroupPath(IMeasurementMNode node) throws StorageGroupNotSetException {
        IMNode temp;
        if (node == null) {
            return null;
        }
        for (temp = node; temp != null && !temp.isStorageGroup(); temp = temp.getParent()) {
        }
        if (temp == null) {
            throw new StorageGroupNotSetException(node.getFullPath());
        }
        return temp.getPartialPath();
    }

    public Map<PartialPath, IMeasurementSchema> getAllMeasurementSchemaByPrefix(PartialPath prefixPath) throws MetadataException {
        final HashMap<PartialPath, IMeasurementSchema> result = new HashMap<PartialPath, IMeasurementSchema>();
        MeasurementCollector<List<IMeasurementSchema>> collector = new MeasurementCollector<List<IMeasurementSchema>>(this.root, prefixPath){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                result.put(this.getCurrentPartialPath(node), node.getSchema());
            }
        };
        collector.setPrefixMatch(true);
        collector.traverse();
        return result;
    }

    public void collectMeasurementSchema(PartialPath prefixPath, final List<IMeasurementSchema> measurementSchemas) throws MetadataException {
        MeasurementCollector<List<IMeasurementSchema>> collector = new MeasurementCollector<List<IMeasurementSchema>>(this.root, prefixPath){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                measurementSchemas.add(node.getSchema());
            }
        };
        collector.setPrefixMatch(true);
        collector.traverse();
    }

    public void collectTimeseriesSchema(PartialPath prefixPath, final Collection<TimeseriesSchema> timeseriesSchemas) throws MetadataException {
        MeasurementCollector<List<IMeasurementSchema>> collector = new MeasurementCollector<List<IMeasurementSchema>>(this.root, prefixPath){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                IMeasurementSchema nodeSchema = node.getSchema();
                timeseriesSchemas.add(new TimeseriesSchema(this.getCurrentPartialPath(node).getFullPath(), nodeSchema.getType(), nodeSchema.getEncodingType(), nodeSchema.getCompressor()));
            }
        };
        collector.setPrefixMatch(true);
        collector.traverse();
    }

    public Set<String> getChildNodePathInNextLevel(PartialPath pathPattern, int limit, int offset) throws MetadataException {
        try {
            MNodeCollector<Set<String>> collector = new MNodeCollector<Set<String>>(this.root, pathPattern.concatNode("*")){

                @Override
                protected void transferToResult(IMNode node) {
                    try {
                        ((Set)this.resultSet).add(this.getCurrentPartialPath(node).getFullPath());
                    }
                    catch (IllegalPathException e) {
                        logger.error(e.getMessage());
                    }
                }
            };
            collector.setResultSet(new TreeSet());
            collector.setLimit(limit);
            collector.setOffset(offset);
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern, int limit, int offset) throws MetadataException {
        try {
            MNodeCollector<Set<String>> collector = new MNodeCollector<Set<String>>(this.root, pathPattern.concatNode("*")){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(node.getName());
                }
            };
            collector.setResultSet(new TreeSet());
            collector.setLimit(limit);
            collector.setOffset(offset);
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, MManager.StorageGroupFilter filter) throws MetadataException {
        MNodeCollector<Set<PartialPath>> collector = new MNodeCollector<Set<PartialPath>>(this.root, pathPattern){

            @Override
            protected void transferToResult(IMNode node) {
                try {
                    ((Set)this.resultSet).add(this.getCurrentPartialPath(node));
                }
                catch (MetadataException e) {
                    logger.error(e.getMessage());
                }
            }
        };
        collector.setResultSet(new TreeSet());
        collector.setTargetLevel(nodeLevel);
        collector.setStorageGroupFilter(filter);
        collector.traverse();
        return new ArrayList<PartialPath>((Collection)collector.getResult());
    }

    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch, boolean traverseTemplate) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.root, pathPattern);
        counter.setShouldTraverseTemplate(traverseTemplate);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public int getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false, true);
    }

    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        EntityCounter counter = new EntityCounter(this.root, pathPattern);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public int getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        StorageGroupCounter counter = new StorageGroupCounter(this.root, pathPattern);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public int getStorageGroupNum(PartialPath pathPattern) throws MetadataException {
        return this.getStorageGroupNum(pathPattern, false);
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MNodeLevelCounter counter = new MNodeLevelCounter(this.root, pathPattern, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level) throws MetadataException {
        return this.getNodesCountInGivenLevel(pathPattern, level, false);
    }

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MeasurementGroupByLevelCounter counter = new MeasurementGroupByLevelCounter(this.root, pathPattern, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getResult();
    }

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level) throws MetadataException {
        return this.getMeasurementCountGroupByLevel(pathPattern, level, false);
    }

    public IMNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = 1; i < nodes.length; ++i) {
            IMNode next;
            if (cur.isMeasurement()) {
                if (i == nodes.length - 1) {
                    return cur;
                }
                throw new PathNotExistException(path.getFullPath(), true);
            }
            if (cur.getSchemaTemplate() != null) {
                upperTemplate = cur.getSchemaTemplate();
            }
            if ((next = cur.getChild(nodes[i])) == null) {
                if (upperTemplate == null || !cur.isUseTemplate() || upperTemplate.getDirectNode(nodes[i]) == null) {
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                next = upperTemplate.getDirectNode(nodes[i]);
                if (next.isMeasurement()) {
                    next = MeasurementMNode.getMeasurementMNode(cur.getAsEntityMNode(), next.getName(), next.getAsMeasurementMNode().getSchema(), null);
                }
            }
            cur = next;
        }
        return cur;
    }

    public IMNode getNodeByPathWithStorageGroupCheck(PartialPath path) throws MetadataException {
        boolean storageGroupChecked = false;
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        Template upperTemplate = null;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur.getSchemaTemplate() != null) {
                upperTemplate = cur.getSchemaTemplate();
            }
            if (cur.getChild(nodes[i]) != null) {
                cur = cur.getChild(nodes[i]);
            } else {
                if (!storageGroupChecked) {
                    throw new StorageGroupNotSetException(path.getFullPath());
                }
                if (upperTemplate == null || !cur.isUseTemplate() || upperTemplate.getDirectNode(nodes[i]) == null) {
                    throw new PathNotExistException(path.getFullPath());
                }
                cur = upperTemplate.getDirectNode(nodes[i]);
            }
            if (!cur.isStorageGroup()) continue;
            storageGroupChecked = true;
        }
        if (!storageGroupChecked) {
            throw new StorageGroupNotSetException(path.getFullPath());
        }
        return cur;
    }

    public IStorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isStorageGroup()) {
            return node.getAsStorageGroupMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 1);
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length && (cur = cur.getChild(nodes[i])) != null; ++i) {
            if (!cur.isStorageGroup()) continue;
            return cur.getAsStorageGroupMNode();
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        ArrayList<IStorageGroupMNode> ret = new ArrayList<IStorageGroupMNode>();
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IMNode current = (IMNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                ret.add(current.getAsStorageGroupMNode());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return ret;
    }

    public IMeasurementMNode getMeasurementMNode(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    public void checkTemplateOnPath(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return;
        }
        if (cur.getSchemaTemplate() != null) {
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (cur.isMeasurement()) {
                return;
            }
            if (!cur.hasChild(nodeNames[i])) {
                return;
            }
            if ((cur = cur.getChild(nodeNames[i])).getSchemaTemplate() == null) continue;
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        this.checkTemplateOnSubtree(cur);
    }

    public IMNode checkTemplateAlignmentWithMountedNode(IMNode mountedNode, Template template) throws MetadataException {
        boolean hasDirectMeasurement = false;
        for (IMNode child : template.getDirectNodes()) {
            if (!child.isMeasurement()) continue;
            hasDirectMeasurement = true;
        }
        if (hasDirectMeasurement) {
            if (!mountedNode.isEntity()) {
                return this.setToEntity(mountedNode);
            }
            for (IMNode child : mountedNode.getChildren().values()) {
                if (!child.isMeasurement()) continue;
                if (template.isDirectAligned() != mountedNode.getAsEntityMNode().isAligned()) {
                    throw new MetadataException("Template and mounted node has different alignment: " + template.getName() + mountedNode.getFullPath());
                }
                return mountedNode;
            }
            mountedNode.getAsEntityMNode().setAligned(template.isDirectAligned());
        }
        return mountedNode;
    }

    private void checkTemplateOnSubtree(IMNode node) throws MetadataException {
        if (node.isMeasurement()) {
            return;
        }
        for (IMNode child : node.getChildren().values()) {
            if (child.isMeasurement()) continue;
            if (child.getSchemaTemplate() != null) {
                throw new MetadataException("Template already exists on " + child.getFullPath());
            }
            this.checkTemplateOnSubtree(child);
        }
    }

    public void checkTemplateInUseOnLowerNode(IMNode node) throws TemplateIsInUseException {
        if (node.isMeasurement()) {
            return;
        }
        for (IMNode child : node.getChildren().values()) {
            if (child.isMeasurement()) continue;
            if (child.isUseTemplate()) {
                throw new TemplateIsInUseException(child.getFullPath());
            }
            this.checkTemplateInUseOnLowerNode(child);
        }
    }

    public boolean isTemplateAppendable(Template tarTemplate, List<String> appendMeasurements) throws MetadataException {
        List<String> setPaths = this.getPathsSetOnTemplate(tarTemplate);
        if (setPaths.size() == 0) {
            return true;
        }
        ArrayDeque<IMNode> setNodes = new ArrayDeque<IMNode>();
        for (String string : setPaths) {
            setNodes.add(this.getNodeByPath(new PartialPath(string)));
        }
        HashSet<String> overlapSet = new HashSet<String>();
        for (String path : appendMeasurements) {
            overlapSet.add(MetaUtils.splitPathToDetachedPath(path)[0]);
        }
        while (setNodes.size() != 0) {
            IMNode iMNode = (IMNode)setNodes.pop();
            if (iMNode.getChildren().size() == 0) continue;
            for (IMNode child : iMNode.getChildren().values()) {
                if (overlapSet.contains(child.getName())) {
                    return false;
                }
                if (child.isMeasurement()) continue;
                setNodes.push(child);
            }
        }
        return true;
    }

    public boolean isPathExistsWithinTemplate(PartialPath path) {
        if (path.getNodes().length < 2) {
            return false;
        }
        String[] pathNodes = path.getNodes();
        IMNode cur = this.root;
        Template upperTemplate = cur.getUpperTemplate();
        for (int i = 1; i < pathNodes.length; ++i) {
            if (cur.hasChild(pathNodes[i])) {
                if ((cur = cur.getChild(pathNodes[i])).isMeasurement()) {
                    return false;
                }
            } else {
                if (upperTemplate != null) {
                    String suffixPath = new PartialPath(Arrays.copyOfRange(pathNodes, i, pathNodes.length)).toString();
                    return upperTemplate.hasSchema(suffixPath);
                }
                return false;
            }
            upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        return false;
    }

    public int getMountedNodeIndexOnMeasurementPath(PartialPath measurementPath) throws MetadataException {
        String[] fullPathNodes = measurementPath.getNodes();
        IMNode cur = this.root;
        Template upperTemplate = cur.getSchemaTemplate();
        if (!cur.getName().equals(fullPathNodes[0])) {
            throw new IllegalPathException(measurementPath.toString());
        }
        for (int index = 1; index < fullPathNodes.length; ++index) {
            Template template = upperTemplate = cur.getSchemaTemplate() != null ? cur.getSchemaTemplate() : upperTemplate;
            if (!cur.hasChild(fullPathNodes[index])) {
                if (upperTemplate != null) {
                    String suffixPath = new PartialPath(Arrays.copyOfRange(fullPathNodes, index, fullPathNodes.length)).toString();
                    if (upperTemplate.hasSchema(suffixPath)) {
                        return index - 1;
                    }
                    if (upperTemplate.getDirectNode(fullPathNodes[index]) == null) continue;
                    throw new TemplateImcompatibeException(measurementPath.getFullPath(), upperTemplate.getName(), fullPathNodes[index]);
                }
                return fullPathNodes.length - 1;
            }
            cur = cur.getChild(fullPathNodes[index]);
        }
        return fullPathNodes.length - 1;
    }

    public List<String> getPathsSetOnTemplate(Template template) throws MetadataException {
        final String templateName = template == null ? "*" : template.getName();
        Set<PartialPath> initPath = template == null ? Collections.singleton(new PartialPath("root")) : template.getRelatedStorageGroup();
        final ArrayList<String> resSet = new ArrayList<String>();
        for (PartialPath sgPath : initPath) {
            CollectorTraverser<Set<String>> setTemplatePaths = new CollectorTraverser<Set<String>>(this.root, sgPath){

                @Override
                protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                    return false;
                }

                @Override
                protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                    if (node.isMeasurement() || !node.getPartialPath().equals(this.getCurrentPartialPath(node))) {
                        return true;
                    }
                    if (node.getSchemaTemplate() != null) {
                        if (templateName.equals("*") || templateName.equals(node.getUpperTemplate().getName())) {
                            resSet.add(node.getFullPath());
                        }
                        return true;
                    }
                    return false;
                }
            };
            setTemplatePaths.setPrefixMatch(true);
            setTemplatePaths.traverse();
        }
        return resSet;
    }

    public List<PartialPath> getPathsUsingTemplateUnderPrefix(Template template, PartialPath prefix, boolean prefixMode) throws MetadataException {
        boolean containWildcard = prefix != null && (Arrays.asList(prefix.getNodes()).contains("*") || Arrays.asList(prefix.getNodes()).contains("**"));
        final String templateName = template == null ? "*" : template.getName();
        Set<PartialPath> initPath = template == null ? Collections.singleton(new PartialPath("root")) : template.getRelatedStorageGroup();
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        if (prefix != null) {
            Set<PartialPath> set = initPath = initPath.stream().anyMatch(p -> p.matchPrefixPath(prefix) || prefix.matchPrefixPath((PartialPath)p)) ? Collections.singleton(prefix) : null;
        }
        if (initPath == null || initPath.size() == 0) {
            return Collections.emptyList();
        }
        for (PartialPath sgPath : initPath) {
            CollectorTraverser<Set<String>> usingTemplatePaths = new CollectorTraverser<Set<String>>(this.root, sgPath){

                @Override
                protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                    return false;
                }

                @Override
                protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                    if (!node.getPartialPath().equals(this.getCurrentPartialPath(node))) {
                        return true;
                    }
                    if (node.getUpperTemplate() != null) {
                        if (!templateName.equals("*") && !templateName.equals(node.getUpperTemplate().getName())) {
                            return true;
                        }
                        if (node.isUseTemplate()) {
                            result.add(node.getPartialPath());
                        }
                    }
                    return false;
                }
            };
            usingTemplatePaths.setPrefixMatch(!containWildcard && prefixMode);
            usingTemplatePaths.traverse();
        }
        return result;
    }

    public String getTemplateOnPath(PartialPath path) throws IllegalPathException {
        String[] pathNodes = path.getNodes();
        if (!pathNodes[0].equals("root")) {
            throw new IllegalPathException(path.toString());
        }
        IMNode cur = this.root;
        if (cur.getSchemaTemplate() != null) {
            return cur.getSchemaTemplate().getName();
        }
        for (int i = 1; i < pathNodes.length; ++i) {
            if (cur.isMeasurement() || !cur.hasChild(pathNodes[i])) {
                return null;
            }
            if ((cur = cur.getChild(pathNodes[i])).getSchemaTemplate() == null) continue;
            return cur.getSchemaTemplate().getName();
        }
        return null;
    }

    public static JsonObject combineMetadataInStrings(String[] metadataStrs) {
        JsonObject[] jsonObjects = new JsonObject[metadataStrs.length];
        for (int i = 0; i < jsonObjects.length; ++i) {
            jsonObjects[i] = (JsonObject)GSON.fromJson(metadataStrs[i], JsonObject.class);
        }
        JsonObject root = jsonObjects[0];
        for (int i = 1; i < jsonObjects.length; ++i) {
            root = MTree.combineJsonObjects(root, jsonObjects[i]);
        }
        return root;
    }

    private static JsonObject combineJsonObjects(JsonObject a, JsonObject b) {
        JsonObject res = new JsonObject();
        HashSet retainSet = new HashSet(a.keySet());
        retainSet.retainAll(b.keySet());
        HashSet aCha = new HashSet(a.keySet());
        HashSet bCha = new HashSet(b.keySet());
        aCha.removeAll(retainSet);
        bCha.removeAll(retainSet);
        for (String key : aCha) {
            res.add(key, a.get(key));
        }
        for (String key : bCha) {
            res.add(key, b.get(key));
        }
        for (String key : retainSet) {
            JsonElement v1 = a.get(key);
            JsonElement v2 = b.get(key);
            if (v1 instanceof JsonObject && v2 instanceof JsonObject) {
                res.add(key, (JsonElement)MTree.combineJsonObjects((JsonObject)v1, (JsonObject)v2));
                continue;
            }
            res.add(v1.getAsString(), v2);
        }
        return res;
    }

    public void processMNodeDuringTraversal(PartialPath pathPattern, final BiConsumer<IMNode, Long> consumer) throws MetadataException {
        Traverser traverser = new Traverser(this.root, pathPattern){
            private long dataTTL;
            {
                super(startNode, path);
                this.dataTTL = -1L;
            }

            @Override
            protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                return this.processMNode(node);
            }

            @Override
            protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                return this.processMNode(node);
            }

            private boolean processMNode(IMNode node) {
                if (node.isStorageGroup()) {
                    this.dataTTL = node.getAsStorageGroupMNode().getDataTTL();
                }
                consumer.accept(node, this.dataTTL);
                return node.isMeasurement();
            }
        };
        traverser.traverse();
    }
}

