/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.SystemStatus;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.cross.CrossCompactionStrategy;
import org.apache.iotdb.db.engine.compaction.inner.InnerCompactionStrategy;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.service.thrift.impl.InfluxDBServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.TSServiceImpl;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    static final String CONFIG_NAME = "iotdb-engine.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private static final String STORAGE_GROUP_MATCHER = "([a-zA-Z0-9_.\\-\\u2E80-\\u9FFF]+)";
    public static final Pattern STORAGE_GROUP_PATTERN = Pattern.compile("([a-zA-Z0-9_.\\-\\u2E80-\\u9FFF]+)");
    private static final String NODE_NAME_MATCHER = "([^\n\t]+)";
    private static final String PARTIAL_NODE_MATCHER = "[.]([^\n\t]+)";
    private static final String NODE_MATCHER = "([.])?([^\n\t]+)([.]([^\n\t]+))*";
    public static final Pattern NODE_PATTERN = Pattern.compile("([.])?([^\n\t]+)([.]([^\n\t]+))*");
    private boolean enableMQTTService = false;
    private String mqttHost = "0.0.0.0";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int rpcPort = 6667;
    private int influxDBRpcPort = 8086;
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForWrite = Runtime.getRuntime().maxMemory() * 4L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private long allocateMemoryForSchema = Runtime.getRuntime().maxMemory() * 1L / 10L;
    private long allocateMemoryForReadWithoutCache = this.allocateMemoryForRead * 300L / 1001L;
    private volatile int maxQueryDeduplicatedPathNum = 1000;
    private double bufferedArraysMemoryProportion = 0.6;
    private double timeIndexMemoryProportion = 0.2;
    private double flushProportion = 0.4;
    private double rejectProportion = 0.8;
    private long storageGroupSizeReportThreshold = 0x1000000L;
    private int checkPeriodWhenInsertBlocked = 50;
    private int maxWaitingTimeWhenInsertBlockedInMs = 10000;
    private boolean enableWal = true;
    private boolean allowReadOnlyWhenErrorsOccur = true;
    private volatile SystemStatus status = SystemStatus.NORMAL;
    private boolean enableDiscardOutOfOrderData = false;
    private int flushWalThreshold = 10000;
    private String timestampPrecision = "ms";
    private long forceWalPeriodInMs = 100L;
    private int walBufferSize = 0x1000000;
    private int maxWalBytebufferNumForEachPartition = 6;
    private long walPoolTrimIntervalInMS = 10000L;
    private long registerBufferSleepIntervalInMs = 200L;
    private long registerBufferRejectThresholdInMs = 10000L;
    private int estimatedSeriesSize = 300;
    private int mlogBufferSize = 0x100000;
    private long syncMlogPeriodInMs = 100L;
    private int tlogBufferSize = 0x100000;
    private static final String DEFAULT_BASE_DIR = "data";
    private String systemDir = "data" + File.separator + "system";
    private String schemaDir = "data" + File.separator + "system" + File.separator + "schema";
    private String syncDir = "data" + File.separator + "system" + File.separator + "sync";
    private String tracingDir = "data" + File.separator + "tracing";
    private String queryDir = "data" + File.separator + "query";
    private String extDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String triggerDir = "ext" + File.separator + "trigger";
    private String[] dataDirs = new String[]{"data" + File.separator + "data"};
    private String multiDirStrategyClassName = null;
    private String walDir = "data" + File.separator + "wal";
    private int maxMemtableNumber = 0;
    private int batchSize = 100000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private int concurrentQueryThread = 16;
    private int concurrentSubRawQueryThread = 8;
    private int rawQueryBlockingQueueCapacity = 5;
    private int concurrentWindowEvaluationThread = Runtime.getRuntime().availableProcessors();
    private int maxPendingWindowEvaluationTasks = 64;
    private boolean enableMemControl = true;
    private boolean enableIndex = false;
    private int concurrentIndexBuildThread = Runtime.getRuntime().availableProcessors();
    private long indexBufferSize = 0x8000000L;
    private int defaultIndexWindowRange = 10;
    private String indexRootFolder = "data" + File.separator + "index";
    private long unSeqTsFileSize = 0L;
    private long seqTsFileSize = 0L;
    private long memtableSizeThreshold = 0x40000000L;
    private boolean enableTimedFlushSeqMemtable = false;
    private long seqMemtableFlushInterval = 3600000L;
    private long seqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedFlushUnseqMemtable = true;
    private long unseqMemtableFlushInterval = 3600000L;
    private long unseqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedCloseTsFile = true;
    private long closeTsFileIntervalAfterFlushing = 3600000L;
    private long closeTsFileCheckInterval = 600000L;
    private int avgSeriesPointNumberThreshold = 10000;
    private boolean enableSeqSpaceCompaction = true;
    private boolean enableUnseqSpaceCompaction = true;
    private boolean enableCrossSpaceCompaction = true;
    private InnerCompactionStrategy innerCompactionStrategy = InnerCompactionStrategy.SIZE_TIERED_COMPACTION;
    private CrossCompactionStrategy crossCompactionStrategy = CrossCompactionStrategy.REWRITE_COMPACTION;
    private CompactionPriority compactionPriority = CompactionPriority.BALANCE;
    private long targetCompactionFileSize = 0x40000000L;
    private long targetChunkSize = 0x100000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 1024L;
    private long chunkPointNumLowerBoundInCompaction = 100L;
    private long compactionAcquireWriteLockTimeout = 60000L;
    private int maxInnerCompactionCandidateFileNum = 30;
    private int maxCrossCompactionCandidateFileNum = 1000;
    private long compactionScheduleIntervalInMs = 60000L;
    private long compactionSubmissionIntervalInMs = 60000L;
    private int subCompactionTaskNum = 4;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForBloomFilterCache = this.allocateMemoryForRead / 1001L;
    private long allocateMemoryForTimeSeriesMetaDataCache = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForChunkCache = this.allocateMemoryForRead * 100L / 1001L;
    private boolean lastCacheEnable = true;
    private boolean enableStatMonitor = false;
    private boolean enableMonitorSeriesWrite = false;
    private int mManagerCacheSize = 300000;
    private int mRemoteSchemaCacheSize = 100000;
    private boolean enableExternalSort = true;
    private int externalSortThreshold = 1000;
    private boolean isSyncEnable = false;
    private int syncServerPort = 5555;
    private String languageVersion = "EN";
    private String ipWhiteList = "0.0.0.0/0";
    private long cacheFileReaderClearPeriod = 100000L;
    private int queryTimeoutThreshold = 60000;
    private int sessionTimeoutThreshold = 0;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private String influxdbImplClassName = InfluxDBServiceImpl.class.getName();
    private boolean chunkBufferPoolEnable = false;
    private boolean enableWatermark = false;
    private String watermarkSecretKey = "IoTDB*2019@Beijing";
    private String watermarkBitString = "100101110100";
    private String watermarkMethod = "GroupBasedLSBMethod(embed_row_cycle=2,embed_lsb_num=5)";
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.FLOAT;
    private TSDataType longStringInferType = TSDataType.DOUBLE;
    private TSDataType floatingStringInferType = TSDataType.FLOAT;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private long crossCompactionMemoryBudget = (long)((double)Runtime.getRuntime().maxMemory() * 0.1);
    private int upgradeThreadNum = 1;
    private int settleThreadNum = 1;
    private long crossCompactionFileSelectionTimeBudget = 30000L;
    private long mergeIntervalSec = 0L;
    private int compactionWriteThroughputMbPerSec = 16;
    private int concurrentCompactionThread = 10;
    private int continuousQueryThreadNum = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int maxPendingContinuousQueryTasks = 64;
    private long continuousQueryMinimumEveryInterval = 1000L;
    private int cqlogBufferSize = 0x100000;
    private int selectIntoInsertTabletPlanRowLimit = 10000;
    private int insertMultiTabletEnableMultithreadingColumnThreshold = 10;
    private FSType systemFileStorageFs = FSType.LOCAL;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "your principal";
    private int concurrentWritingTimePartition = 1;
    private int defaultFillInterval = -1;
    private long defaultTTL = Long.MAX_VALUE;
    private int primitiveArraySize = 32;
    private boolean enablePartition = false;
    private boolean enableMTreeSnapshot = false;
    private int mtreeSnapshotInterval = 100000;
    private int mtreeSnapshotThresholdTime = 3600;
    private long partitionInterval = 604800L;
    private TimeIndexLevel timeIndexLevel = TimeIndexLevel.DEVICE_TIME_INDEX;
    private int thriftServerAwaitTimeForStopService = 60;
    private int queryCacheSizeInMetric = 50;
    private int tagAttributeTotalSize = 700;
    private int tagAttributeFlushInterval = 1000;
    private boolean enablePartialInsert = true;
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer";
    private int udfInitialByteArrayLengthForMemoryControl = 48;
    private float udfMemoryBudgetInMB = (float)Math.min(30.0, 0.2 * (double)this.allocateMemoryForRead);
    private float udfReaderMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfTransformerMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfCollectorMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float groupByFillCacheSizeInMB = 1.0f;
    private long startUpNanosecond = System.nanoTime();
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int frequencyIntervalInMinute = 1;
    private long slowQueryThreshold = 5000L;
    private boolean enableRpcService = true;
    private boolean enableInfluxDBRpcService = false;
    private int ioTaskQueueSizeForFlushing = 10;
    private int virtualStorageGroupNum = 1;
    private long recoveryLogIntervalInMs = 5000L;
    private String adminName = "root";
    private String adminPassword = "root";
    private String deviceIDTransformationMethod = "Plain";
    private boolean enableIDTable = false;
    private boolean enableIDTableLogFile = false;
    private String encryptDecryptProvider = "org.apache.iotdb.db.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private boolean enableOperationSync = false;
    private String secondaryAddress = "127.0.0.1";
    private int secondaryPort = 6668;
    private String secondaryUser = "root";
    private String secondaryPassword = "root";
    private int OperationSyncSessionConcurrencySize = 8;
    private String operationSyncLogDir = "data" + File.separator + "operationsync";
    private int operationSyncLogValidity = 30;
    private int operationSyncLogNum = Short.MAX_VALUE;
    private long operationSyncMaxLogSize = 0x1900000000L;
    private int operationSyncProducerCacheSize = 1024;
    private int operationSyncConsumerConcurrencySize = 4;
    private int schemaQueryFetchSize = 10000000;

    public float getUdfMemoryBudgetInMB() {
        return this.udfMemoryBudgetInMB;
    }

    public void setUdfMemoryBudgetInMB(float udfMemoryBudgetInMB) {
        this.udfMemoryBudgetInMB = udfMemoryBudgetInMB;
    }

    public float getGroupByFillCacheSizeInMB() {
        return this.groupByFillCacheSizeInMB;
    }

    public void setGroupByFillCacheSizeInMB(float groupByFillCacheSizeInMB) {
        this.groupByFillCacheSizeInMB = groupByFillCacheSizeInMB;
    }

    public float getUdfReaderMemoryBudgetInMB() {
        return this.udfReaderMemoryBudgetInMB;
    }

    public void setUdfReaderMemoryBudgetInMB(float udfReaderMemoryBudgetInMB) {
        this.udfReaderMemoryBudgetInMB = udfReaderMemoryBudgetInMB;
    }

    public float getUdfTransformerMemoryBudgetInMB() {
        return this.udfTransformerMemoryBudgetInMB;
    }

    public void setUdfTransformerMemoryBudgetInMB(float udfTransformerMemoryBudgetInMB) {
        this.udfTransformerMemoryBudgetInMB = udfTransformerMemoryBudgetInMB;
    }

    public float getUdfCollectorMemoryBudgetInMB() {
        return this.udfCollectorMemoryBudgetInMB;
    }

    public void setUdfCollectorMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.udfCollectorMemoryBudgetInMB = udfCollectorMemoryBudgetInMB;
    }

    public int getUdfInitialByteArrayLengthForMemoryControl() {
        return this.udfInitialByteArrayLengthForMemoryControl;
    }

    public void setUdfInitialByteArrayLengthForMemoryControl(int udfInitialByteArrayLengthForMemoryControl) {
        this.udfInitialByteArrayLengthForMemoryControl = udfInitialByteArrayLengthForMemoryControl;
    }

    public int getConcurrentWritingTimePartition() {
        return this.concurrentWritingTimePartition;
    }

    public void setConcurrentWritingTimePartition(int concurrentWritingTimePartition) {
        this.concurrentWritingTimePartition = concurrentWritingTimePartition;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public boolean isEnablePartition() {
        return this.enablePartition;
    }

    public void setEnablePartition(boolean enablePartition) {
        this.enablePartition = enablePartition;
    }

    public boolean isEnableMTreeSnapshot() {
        return this.enableMTreeSnapshot;
    }

    public void setEnableMTreeSnapshot(boolean enableMTreeSnapshot) {
        this.enableMTreeSnapshot = enableMTreeSnapshot;
    }

    public int getMtreeSnapshotInterval() {
        return this.mtreeSnapshotInterval;
    }

    public void setMtreeSnapshotInterval(int mtreeSnapshotInterval) {
        this.mtreeSnapshotInterval = mtreeSnapshotInterval;
    }

    public int getMtreeSnapshotThresholdTime() {
        return this.mtreeSnapshotThresholdTime;
    }

    public void setMtreeSnapshotThresholdTime(int mtreeSnapshotThresholdTime) {
        this.mtreeSnapshotThresholdTime = mtreeSnapshotThresholdTime;
    }

    public long getPartitionInterval() {
        return this.partitionInterval;
    }

    public void setPartitionInterval(long partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public TimeIndexLevel getTimeIndexLevel() {
        return this.timeIndexLevel;
    }

    public void setTimeIndexLevel(String timeIndexLevel) {
        this.timeIndexLevel = TimeIndexLevel.valueOf(timeIndexLevel);
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.schemaDir = this.addHomeDir(this.schemaDir);
        this.syncDir = this.addHomeDir(this.syncDir);
        this.tracingDir = this.addHomeDir(this.tracingDir);
        this.walDir = this.addHomeDir(this.walDir);
        this.indexRootFolder = this.addHomeDir(this.indexRootFolder);
        this.extDir = this.addHomeDir(this.extDir);
        this.udfDir = this.addHomeDir(this.udfDir);
        this.triggerDir = this.addHomeDir(this.triggerDir);
        this.operationSyncLogDir = this.addHomeDir(this.operationSyncLogDir);
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            this.queryDir = hdfsDir + File.separatorChar + this.queryDir;
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = hdfsDir + File.separatorChar + this.dataDirs[i];
            }
        } else {
            this.queryDir = this.addHomeDir(this.queryDir);
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = this.addHomeDir(this.dataDirs[i]);
            }
        }
    }

    void reloadDataDirs(String[] dataDirs) throws LoadConfigurationException {
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = hdfsDir + File.separatorChar + dataDirs[i];
            }
        } else {
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = this.addHomeDir(dataDirs[i]);
            }
        }
        this.dataDirs = dataDirs;
        DirectoryManager.getInstance().updateFileFolders();
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("IOTDB_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    private void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getInfluxDBRpcPort() {
        return this.influxDBRpcPort;
    }

    public void setInfluxDBRpcPort(int influxDBRpcPort) {
        this.influxDBRpcPort = influxDBRpcPort;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: " + timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public boolean isEnableWal() {
        return this.enableWal;
    }

    public void setEnableWal(boolean enableWal) {
        this.enableWal = enableWal;
    }

    public boolean isEnableDiscardOutOfOrderData() {
        return this.enableDiscardOutOfOrderData;
    }

    public void setEnableDiscardOutOfOrderData(boolean enableDiscardOutOfOrderData) {
        this.enableDiscardOutOfOrderData = enableDiscardOutOfOrderData;
    }

    public int getFlushWalThreshold() {
        return this.flushWalThreshold;
    }

    public void setFlushWalThreshold(int flushWalThreshold) {
        this.flushWalThreshold = flushWalThreshold;
    }

    public long getForceWalPeriodInMs() {
        return this.forceWalPeriodInMs;
    }

    public void setForceWalPeriodInMs(long forceWalPeriodInMs) {
        this.forceWalPeriodInMs = forceWalPeriodInMs;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String getTracingDir() {
        return this.tracingDir;
    }

    void setTracingDir(String tracingDir) {
        this.tracingDir = tracingDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getWalDir() {
        return this.walDir;
    }

    void setWalDir(String walDir) {
        this.walDir = walDir;
    }

    public String getExtDir() {
        return this.extDir;
    }

    public void setExtDir(String extDir) {
        this.extDir = extDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
    }

    public String getTriggerDir() {
        return this.triggerDir;
    }

    public void setTriggerDir(String triggerDir) {
        this.triggerDir = triggerDir;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    public int getConcurrentQueryThread() {
        return this.concurrentQueryThread;
    }

    public void setConcurrentQueryThread(int concurrentQueryThread) {
        this.concurrentQueryThread = concurrentQueryThread;
    }

    public int getConcurrentSubRawQueryThread() {
        return this.concurrentSubRawQueryThread;
    }

    void setConcurrentSubRawQueryThread(int concurrentSubRawQueryThread) {
        this.concurrentSubRawQueryThread = concurrentSubRawQueryThread;
    }

    public int getRawQueryBlockingQueueCapacity() {
        return this.rawQueryBlockingQueueCapacity;
    }

    public void setRawQueryBlockingQueueCapacity(int rawQueryBlockingQueueCapacity) {
        this.rawQueryBlockingQueueCapacity = rawQueryBlockingQueueCapacity;
    }

    public int getConcurrentWindowEvaluationThread() {
        return this.concurrentWindowEvaluationThread;
    }

    public void setConcurrentWindowEvaluationThread(int concurrentWindowEvaluationThread) {
        this.concurrentWindowEvaluationThread = concurrentWindowEvaluationThread;
    }

    public int getMaxPendingWindowEvaluationTasks() {
        return this.maxPendingWindowEvaluationTasks;
    }

    public void setMaxPendingWindowEvaluationTasks(int maxPendingWindowEvaluationTasks) {
        this.maxPendingWindowEvaluationTasks = maxPendingWindowEvaluationTasks;
    }

    public long getSeqTsFileSize() {
        return this.seqTsFileSize;
    }

    public void setSeqTsFileSize(long seqTsFileSize) {
        this.seqTsFileSize = seqTsFileSize;
    }

    public long getUnSeqTsFileSize() {
        return this.unSeqTsFileSize;
    }

    public void setUnSeqTsFileSize(long unSeqTsFileSize) {
        this.unSeqTsFileSize = unSeqTsFileSize;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getmManagerCacheSize() {
        return this.mManagerCacheSize;
    }

    void setmManagerCacheSize(int mManagerCacheSize) {
        this.mManagerCacheSize = mManagerCacheSize;
    }

    public int getmRemoteSchemaCacheSize() {
        return this.mRemoteSchemaCacheSize;
    }

    public void setmRemoteSchemaCacheSize(int mRemoteSchemaCacheSize) {
        this.mRemoteSchemaCacheSize = mRemoteSchemaCacheSize;
    }

    public boolean isSyncEnable() {
        return this.isSyncEnable;
    }

    public void setSyncEnable(boolean syncEnable) {
        this.isSyncEnable = syncEnable;
    }

    public int getSyncServerPort() {
        return this.syncServerPort;
    }

    void setSyncServerPort(int syncServerPort) {
        this.syncServerPort = syncServerPort;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getIoTDBVersion() {
        return IoTDBConstant.VERSION;
    }

    public String getIoTDBMajorVersion() {
        return IoTDBConstant.MAJOR_VERSION;
    }

    public String getIoTDBMajorVersion(String version) {
        return "UNKNOWN".equals(version) ? "UNKNOWN" : version.split("\\.")[0] + "." + version.split("\\.")[1];
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public int getQueryTimeoutThreshold() {
        return this.queryTimeoutThreshold;
    }

    public void setQueryTimeoutThreshold(int queryTimeoutThreshold) {
        this.queryTimeoutThreshold = queryTimeoutThreshold;
    }

    public int getSessionTimeoutThreshold() {
        return this.sessionTimeoutThreshold;
    }

    public void setSessionTimeoutThreshold(int sessionTimeoutThreshold) {
        this.sessionTimeoutThreshold = sessionTimeoutThreshold;
    }

    boolean isAllowReadOnlyWhenErrorsOccur() {
        return this.allowReadOnlyWhenErrorsOccur;
    }

    void setAllowReadOnlyWhenErrorsOccur(boolean allowReadOnlyWhenErrorsOccur) {
        this.allowReadOnlyWhenErrorsOccur = allowReadOnlyWhenErrorsOccur;
    }

    public boolean isReadOnly() {
        return this.status == SystemStatus.READ_ONLY || this.status == SystemStatus.ERROR && this.allowReadOnlyWhenErrorsOccur;
    }

    public SystemStatus getSystemStatus() {
        return this.status;
    }

    public void setSystemStatus(SystemStatus newStatus) {
        if (newStatus == SystemStatus.READ_ONLY) {
            logger.error("Change system mode to read-only! Only query statements are permitted!", (Throwable)new RuntimeException("System mode is set to READ_ONLY"));
        } else if (newStatus == SystemStatus.ERROR) {
            if (this.allowReadOnlyWhenErrorsOccur) {
                logger.error("Unrecoverable error occurs! Make system read-only when allow_read_only_when_errors_occur is true.", (Throwable)new RuntimeException("System mode is set to READ_ONLY"));
                newStatus = SystemStatus.READ_ONLY;
            } else {
                logger.error("Unrecoverable error occurs! Shutdown system directly when allow_read_only_when_errors_occur is false.", (Throwable)new RuntimeException("System mode is set to ERROR"));
                System.exit(-1);
            }
        } else {
            logger.warn("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        }
        this.status = newStatus;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public String getInfluxDBImplClassName() {
        return this.influxdbImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public int getMaxWalBytebufferNumForEachPartition() {
        return this.maxWalBytebufferNumForEachPartition;
    }

    public void setMaxWalBytebufferNumForEachPartition(int maxWalBytebufferNumForEachPartition) {
        this.maxWalBytebufferNumForEachPartition = maxWalBytebufferNumForEachPartition;
    }

    public long getWalPoolTrimIntervalInMS() {
        return this.walPoolTrimIntervalInMS;
    }

    public void setWalPoolTrimIntervalInMS(long walPoolTrimIntervalInMS) {
        this.walPoolTrimIntervalInMS = walPoolTrimIntervalInMS;
    }

    public long getRegisterBufferSleepIntervalInMs() {
        return this.registerBufferSleepIntervalInMs;
    }

    public void setRegisterBufferSleepIntervalInMs(long registerBufferSleepIntervalInMs) {
        this.registerBufferSleepIntervalInMs = registerBufferSleepIntervalInMs;
    }

    public long getRegisterBufferRejectThresholdInMs() {
        return this.registerBufferRejectThresholdInMs;
    }

    public void setRegisterBufferRejectThresholdInMs(long registerBufferRejectThresholdInMs) {
        this.registerBufferRejectThresholdInMs = registerBufferRejectThresholdInMs;
    }

    public int getEstimatedSeriesSize() {
        return this.estimatedSeriesSize;
    }

    public void setEstimatedSeriesSize(int estimatedSeriesSize) {
        this.estimatedSeriesSize = estimatedSeriesSize;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getCrossCompactionMemoryBudget() {
        return this.crossCompactionMemoryBudget;
    }

    public void setCrossCompactionMemoryBudget(long crossCompactionMemoryBudget) {
        this.crossCompactionMemoryBudget = crossCompactionMemoryBudget;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public double getBufferedArraysMemoryProportion() {
        return this.bufferedArraysMemoryProportion;
    }

    public void setBufferedArraysMemoryProportion(double bufferedArraysMemoryProportion) {
        this.bufferedArraysMemoryProportion = bufferedArraysMemoryProportion;
    }

    public double getTimeIndexMemoryProportion() {
        return this.timeIndexMemoryProportion;
    }

    public void setTimeIndexMemoryProportion(double timeIndexMemoryProportion) {
        this.timeIndexMemoryProportion = timeIndexMemoryProportion;
    }

    public double getFlushProportion() {
        return this.flushProportion;
    }

    public void setFlushProportion(double flushProportion) {
        this.flushProportion = flushProportion;
    }

    public double getRejectProportion() {
        return this.rejectProportion;
    }

    public void setRejectProportion(double rejectProportion) {
        this.rejectProportion = rejectProportion;
    }

    public long getStorageGroupSizeReportThreshold() {
        return this.storageGroupSizeReportThreshold;
    }

    public void setStorageGroupSizeReportThreshold(long storageGroupSizeReportThreshold) {
        this.storageGroupSizeReportThreshold = storageGroupSizeReportThreshold;
    }

    public long getAllocateMemoryForWrite() {
        return this.allocateMemoryForWrite;
    }

    public void setAllocateMemoryForWrite(long allocateMemoryForWrite) {
        this.allocateMemoryForWrite = allocateMemoryForWrite;
    }

    public long getAllocateMemoryForSchema() {
        return this.allocateMemoryForSchema;
    }

    void setAllocateMemoryForSchema(long allocateMemoryForSchema) {
        this.allocateMemoryForSchema = allocateMemoryForSchema;
    }

    public long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public long getAllocateMemoryForReadWithoutCache() {
        return this.allocateMemoryForReadWithoutCache;
    }

    public void setAllocateMemoryForReadWithoutCache(long allocateMemoryForReadWithoutCache) {
        this.allocateMemoryForReadWithoutCache = allocateMemoryForReadWithoutCache;
    }

    public boolean isEnableExternalSort() {
        return this.enableExternalSort;
    }

    void setEnableExternalSort(boolean enableExternalSort) {
        this.enableExternalSort = enableExternalSort;
    }

    public int getExternalSortThreshold() {
        return this.externalSortThreshold;
    }

    void setExternalSortThreshold(int externalSortThreshold) {
        this.externalSortThreshold = externalSortThreshold;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public int getConcurrentCompactionThread() {
        return this.concurrentCompactionThread;
    }

    public void setConcurrentCompactionThread(int concurrentCompactionThread) {
        this.concurrentCompactionThread = concurrentCompactionThread;
    }

    public int getContinuousQueryThreadNum() {
        return this.continuousQueryThreadNum;
    }

    public void setContinuousQueryThreadNum(int continuousQueryThreadNum) {
        this.continuousQueryThreadNum = continuousQueryThreadNum;
    }

    public int getMaxPendingContinuousQueryTasks() {
        return this.maxPendingContinuousQueryTasks;
    }

    public void setMaxPendingContinuousQueryTasks(int maxPendingContinuousQueryTasks) {
        this.maxPendingContinuousQueryTasks = maxPendingContinuousQueryTasks;
    }

    public long getContinuousQueryMinimumEveryInterval() {
        return this.continuousQueryMinimumEveryInterval;
    }

    public void setContinuousQueryMinimumEveryInterval(long minimumEveryInterval) {
        this.continuousQueryMinimumEveryInterval = minimumEveryInterval;
    }

    public int getCqlogBufferSize() {
        return this.cqlogBufferSize;
    }

    public void setCqlogBufferSize(int cqlogBufferSize) {
        this.cqlogBufferSize = cqlogBufferSize;
    }

    public void setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.selectIntoInsertTabletPlanRowLimit = selectIntoInsertTabletPlanRowLimit;
    }

    public int getSelectIntoInsertTabletPlanRowLimit() {
        return this.selectIntoInsertTabletPlanRowLimit;
    }

    public int getInsertMultiTabletEnableMultithreadingColumnThreshold() {
        return this.insertMultiTabletEnableMultithreadingColumnThreshold;
    }

    public void setInsertMultiTabletEnableMultithreadingColumnThreshold(int insertMultiTabletEnableMultithreadingColumnThreshold) {
        this.insertMultiTabletEnableMultithreadingColumnThreshold = insertMultiTabletEnableMultithreadingColumnThreshold;
    }

    public int getCompactionWriteThroughputMbPerSec() {
        return this.compactionWriteThroughputMbPerSec;
    }

    public void setCompactionWriteThroughputMbPerSec(int compactionWriteThroughputMbPerSec) {
        this.compactionWriteThroughputMbPerSec = compactionWriteThroughputMbPerSec;
    }

    public boolean isEnableMemControl() {
        return this.enableMemControl;
    }

    public void setEnableMemControl(boolean enableMemControl) {
        this.enableMemControl = enableMemControl;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public boolean isEnableTimedFlushSeqMemtable() {
        return this.enableTimedFlushSeqMemtable;
    }

    public void setEnableTimedFlushSeqMemtable(boolean enableTimedFlushSeqMemtable) {
        this.enableTimedFlushSeqMemtable = enableTimedFlushSeqMemtable;
    }

    public long getSeqMemtableFlushInterval() {
        return this.seqMemtableFlushInterval;
    }

    public void setSeqMemtableFlushInterval(long seqMemtableFlushInterval) {
        this.seqMemtableFlushInterval = seqMemtableFlushInterval;
    }

    public long getSeqMemtableFlushCheckInterval() {
        return this.seqMemtableFlushCheckInterval;
    }

    public void setSeqMemtableFlushCheckInterval(long seqMemtableFlushCheckInterval) {
        this.seqMemtableFlushCheckInterval = seqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedFlushUnseqMemtable() {
        return this.enableTimedFlushUnseqMemtable;
    }

    public void setEnableTimedFlushUnseqMemtable(boolean enableTimedFlushUnseqMemtable) {
        this.enableTimedFlushUnseqMemtable = enableTimedFlushUnseqMemtable;
    }

    public long getUnseqMemtableFlushInterval() {
        return this.unseqMemtableFlushInterval;
    }

    public void setUnseqMemtableFlushInterval(long unseqMemtableFlushInterval) {
        this.unseqMemtableFlushInterval = unseqMemtableFlushInterval;
    }

    public long getUnseqMemtableFlushCheckInterval() {
        return this.unseqMemtableFlushCheckInterval;
    }

    public void setUnseqMemtableFlushCheckInterval(long unseqMemtableFlushCheckInterval) {
        this.unseqMemtableFlushCheckInterval = unseqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedCloseTsFile() {
        return this.enableTimedCloseTsFile;
    }

    public void setEnableTimedCloseTsFile(boolean enableTimedCloseTsFile) {
        this.enableTimedCloseTsFile = enableTimedCloseTsFile;
    }

    public long getCloseTsFileIntervalAfterFlushing() {
        return this.closeTsFileIntervalAfterFlushing;
    }

    public void setCloseTsFileIntervalAfterFlushing(long closeTsFileIntervalAfterFlushing) {
        this.closeTsFileIntervalAfterFlushing = closeTsFileIntervalAfterFlushing;
    }

    public long getCloseTsFileCheckInterval() {
        return this.closeTsFileCheckInterval;
    }

    public void setCloseTsFileCheckInterval(long closeTsFileCheckInterval) {
        this.closeTsFileCheckInterval = closeTsFileCheckInterval;
    }

    public int getAvgSeriesPointNumberThreshold() {
        return this.avgSeriesPointNumberThreshold;
    }

    public void setAvgSeriesPointNumberThreshold(int avgSeriesPointNumberThreshold) {
        this.avgSeriesPointNumberThreshold = avgSeriesPointNumberThreshold;
    }

    public long getCrossCompactionFileSelectionTimeBudget() {
        return this.crossCompactionFileSelectionTimeBudget;
    }

    void setCrossCompactionFileSelectionTimeBudget(long crossCompactionFileSelectionTimeBudget) {
        this.crossCompactionFileSelectionTimeBudget = crossCompactionFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForBloomFilterCache() {
        return this.allocateMemoryForBloomFilterCache;
    }

    public void setAllocateMemoryForBloomFilterCache(long allocateMemoryForBloomFilterCache) {
        this.allocateMemoryForBloomFilterCache = allocateMemoryForBloomFilterCache;
    }

    public long getAllocateMemoryForTimeSeriesMetaDataCache() {
        return this.allocateMemoryForTimeSeriesMetaDataCache;
    }

    public void setAllocateMemoryForTimeSeriesMetaDataCache(long allocateMemoryForTimeSeriesMetaDataCache) {
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForTimeSeriesMetaDataCache;
    }

    public long getAllocateMemoryForChunkCache() {
        return this.allocateMemoryForChunkCache;
    }

    public void setAllocateMemoryForChunkCache(long allocateMemoryForChunkCache) {
        this.allocateMemoryForChunkCache = allocateMemoryForChunkCache;
    }

    public boolean isLastCacheEnabled() {
        return this.lastCacheEnable;
    }

    public void setEnableLastCache(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public boolean isEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public String getWatermarkSecretKey() {
        return this.watermarkSecretKey;
    }

    public void setWatermarkSecretKey(String watermarkSecretKey) {
        this.watermarkSecretKey = watermarkSecretKey;
    }

    public String getWatermarkBitString() {
        return this.watermarkBitString;
    }

    public void setWatermarkBitString(String watermarkBitString) {
        this.watermarkBitString = watermarkBitString;
    }

    String getWatermarkMethod() {
        return this.watermarkMethod;
    }

    public void setWatermarkMethod(String watermarkMethod) {
        this.watermarkMethod = watermarkMethod;
    }

    public String getWatermarkMethodName() {
        return this.watermarkMethod.split("\\(")[0];
    }

    public int getWatermarkParamMarkRate() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_row_cycle", "5"));
    }

    public int getWatermarkParamMaxRightBit() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_lsb_num", "5"));
    }

    private String getWatermarkParamValue(String key, String defaultValue) {
        String res = this.getWatermarkParamValue(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    private String getWatermarkParamValue(String key) {
        String pattern = key + "=(\\w*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.watermarkMethod);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public void setLongStringInferType(TSDataType longStringInferType) {
        this.longStringInferType = longStringInferType;
    }

    public TSDataType getLongStringInferType() {
        return this.longStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            throw new IllegalArgumentException("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is " + nanStringInferType);
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(String systemFileStorageFs) {
        this.systemFileStorageFs = FSType.valueOf((String)systemFileStorageFs);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadNum() {
        return this.upgradeThreadNum;
    }

    public int getSettleThreadNum() {
        return this.settleThreadNum;
    }

    void setUpgradeThreadNum(int upgradeThreadNum) {
        this.upgradeThreadNum = upgradeThreadNum;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getTagAttributeFlushInterval() {
        return this.tagAttributeFlushInterval;
    }

    public void setTagAttributeFlushInterval(int tagAttributeFlushInterval) {
        this.tagAttributeFlushInterval = tagAttributeFlushInterval;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        RpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        RpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
    }

    public int getMaxQueryDeduplicatedPathNum() {
        return this.maxQueryDeduplicatedPathNum;
    }

    public void setMaxQueryDeduplicatedPathNum(int maxQueryDeduplicatedPathNum) {
        this.maxQueryDeduplicatedPathNum = maxQueryDeduplicatedPathNum;
    }

    public int getCheckPeriodWhenInsertBlocked() {
        return this.checkPeriodWhenInsertBlocked;
    }

    public void setCheckPeriodWhenInsertBlocked(int checkPeriodWhenInsertBlocked) {
        this.checkPeriodWhenInsertBlocked = checkPeriodWhenInsertBlocked;
    }

    public int getMaxWaitingTimeWhenInsertBlocked() {
        return this.maxWaitingTimeWhenInsertBlockedInMs;
    }

    public void setMaxWaitingTimeWhenInsertBlocked(int maxWaitingTimeWhenInsertBlocked) {
        this.maxWaitingTimeWhenInsertBlockedInMs = maxWaitingTimeWhenInsertBlocked;
    }

    public int getFrequencyIntervalInMinute() {
        return this.frequencyIntervalInMinute;
    }

    public void setFrequencyIntervalInMinute(int frequencyIntervalInMinute) {
        this.frequencyIntervalInMinute = frequencyIntervalInMinute;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public void setSlowQueryThreshold(long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public void setEnableIndex(boolean enableIndex) {
        this.enableIndex = enableIndex;
    }

    void setConcurrentIndexBuildThread(int concurrentIndexBuildThread) {
        this.concurrentIndexBuildThread = concurrentIndexBuildThread;
    }

    public int getConcurrentIndexBuildThread() {
        return this.concurrentIndexBuildThread;
    }

    public long getIndexBufferSize() {
        return this.indexBufferSize;
    }

    public void setIndexBufferSize(long indexBufferSize) {
        this.indexBufferSize = indexBufferSize;
    }

    public String getIndexRootFolder() {
        return this.indexRootFolder;
    }

    public void setIndexRootFolder(String indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
    }

    public int getDefaultIndexWindowRange() {
        return this.defaultIndexWindowRange;
    }

    public void setDefaultIndexWindowRange(int defaultIndexWindowRange) {
        this.defaultIndexWindowRange = defaultIndexWindowRange;
    }

    public int getVirtualStorageGroupNum() {
        return this.virtualStorageGroupNum;
    }

    public void setVirtualStorageGroupNum(int virtualStorageGroupNum) {
        this.virtualStorageGroupNum = virtualStorageGroupNum;
    }

    public long getRecoveryLogIntervalInMs() {
        return this.recoveryLogIntervalInMs;
    }

    public void setRecoveryLogIntervalInMs(long recoveryLogIntervalInMs) {
        this.recoveryLogIntervalInMs = recoveryLogIntervalInMs;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
        RpcTransportFactory.setUseSnappy((boolean)this.rpcAdvancedCompressionEnable);
    }

    public int getMlogBufferSize() {
        return this.mlogBufferSize;
    }

    public void setMlogBufferSize(int mlogBufferSize) {
        this.mlogBufferSize = mlogBufferSize;
    }

    public long getSyncMlogPeriodInMs() {
        return this.syncMlogPeriodInMs;
    }

    public void setSyncMlogPeriodInMs(long syncMlogPeriodInMs) {
        this.syncMlogPeriodInMs = syncMlogPeriodInMs;
    }

    public int getTlogBufferSize() {
        return this.tlogBufferSize;
    }

    public void setTlogBufferSize(int tlogBufferSize) {
        this.tlogBufferSize = tlogBufferSize;
    }

    public boolean isEnableRpcService() {
        return this.enableRpcService;
    }

    public void setEnableRpcService(boolean enableRpcService) {
        this.enableRpcService = enableRpcService;
    }

    public boolean isEnableInfluxDBRpcService() {
        return this.enableInfluxDBRpcService;
    }

    public void setEnableInfluxDBRpcService(boolean enableInfluxDBRpcService) {
        this.enableInfluxDBRpcService = enableInfluxDBRpcService;
    }

    public int getIoTaskQueueSizeForFlushing() {
        return this.ioTaskQueueSizeForFlushing;
    }

    public void setIoTaskQueueSizeForFlushing(int ioTaskQueueSizeForFlushing) {
        this.ioTaskQueueSizeForFlushing = ioTaskQueueSizeForFlushing;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public boolean isEnableSeqSpaceCompaction() {
        return this.enableSeqSpaceCompaction;
    }

    public void setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.enableSeqSpaceCompaction = enableSeqSpaceCompaction;
    }

    public boolean isEnableUnseqSpaceCompaction() {
        return this.enableUnseqSpaceCompaction;
    }

    public void setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.enableUnseqSpaceCompaction = enableUnseqSpaceCompaction;
    }

    public boolean isEnableCrossSpaceCompaction() {
        return this.enableCrossSpaceCompaction;
    }

    public void setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.enableCrossSpaceCompaction = enableCrossSpaceCompaction;
    }

    public InnerCompactionStrategy getInnerCompactionStrategy() {
        return this.innerCompactionStrategy;
    }

    public void setInnerCompactionStrategy(InnerCompactionStrategy innerCompactionStrategy) {
        this.innerCompactionStrategy = innerCompactionStrategy;
    }

    public CrossCompactionStrategy getCrossCompactionStrategy() {
        return this.crossCompactionStrategy;
    }

    public void setCrossCompactionStrategy(CrossCompactionStrategy crossCompactionStrategy) {
        this.crossCompactionStrategy = crossCompactionStrategy;
    }

    public CompactionPriority getCompactionPriority() {
        return this.compactionPriority;
    }

    public void setCompactionPriority(CompactionPriority compactionPriority) {
        this.compactionPriority = compactionPriority;
    }

    public long getTargetCompactionFileSize() {
        return this.targetCompactionFileSize;
    }

    public void setTargetCompactionFileSize(long targetCompactionFileSize) {
        this.targetCompactionFileSize = targetCompactionFileSize;
    }

    public long getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(long targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    public long getChunkSizeLowerBoundInCompaction() {
        return this.chunkSizeLowerBoundInCompaction;
    }

    public void setChunkSizeLowerBoundInCompaction(long chunkSizeLowerBoundInCompaction) {
        this.chunkSizeLowerBoundInCompaction = chunkSizeLowerBoundInCompaction;
    }

    public long getTargetChunkPointNum() {
        return this.targetChunkPointNum;
    }

    public void setTargetChunkPointNum(long targetChunkPointNum) {
        this.targetChunkPointNum = targetChunkPointNum;
    }

    public long getChunkPointNumLowerBoundInCompaction() {
        return this.chunkPointNumLowerBoundInCompaction;
    }

    public void setChunkPointNumLowerBoundInCompaction(long chunkPointNumLowerBoundInCompaction) {
        this.chunkPointNumLowerBoundInCompaction = chunkPointNumLowerBoundInCompaction;
    }

    public long getCompactionAcquireWriteLockTimeout() {
        return this.compactionAcquireWriteLockTimeout;
    }

    public void setCompactionAcquireWriteLockTimeout(long compactionAcquireWriteLockTimeout) {
        this.compactionAcquireWriteLockTimeout = compactionAcquireWriteLockTimeout;
    }

    public long getCompactionScheduleIntervalInMs() {
        return this.compactionScheduleIntervalInMs;
    }

    public void setCompactionScheduleIntervalInMs(long compactionScheduleIntervalInMs) {
        this.compactionScheduleIntervalInMs = compactionScheduleIntervalInMs;
    }

    public int getMaxInnerCompactionCandidateFileNum() {
        return this.maxInnerCompactionCandidateFileNum;
    }

    public void setMaxInnerCompactionCandidateFileNum(int maxInnerCompactionCandidateFileNum) {
        this.maxInnerCompactionCandidateFileNum = maxInnerCompactionCandidateFileNum;
    }

    public int getMaxCrossCompactionCandidateFileNum() {
        return this.maxCrossCompactionCandidateFileNum;
    }

    public void setMaxCrossCompactionCandidateFileNum(int maxCrossCompactionCandidateFileNum) {
        this.maxCrossCompactionCandidateFileNum = maxCrossCompactionCandidateFileNum;
    }

    public long getCompactionSubmissionIntervalInMs() {
        return this.compactionSubmissionIntervalInMs;
    }

    public void setCompactionSubmissionIntervalInMs(long interval) {
        this.compactionSubmissionIntervalInMs = interval;
    }

    public int getSubCompactionTaskNum() {
        return this.subCompactionTaskNum;
    }

    public void setSubCompactionTaskNum(int subCompactionTaskNum) {
        this.subCompactionTaskNum = subCompactionTaskNum;
    }

    public String getDeviceIDTransformationMethod() {
        return this.deviceIDTransformationMethod;
    }

    public void setDeviceIDTransformationMethod(String deviceIDTransformationMethod) {
        this.deviceIDTransformationMethod = deviceIDTransformationMethod;
    }

    public boolean isEnableIDTable() {
        return this.enableIDTable;
    }

    public void setEnableIDTable(boolean enableIDTable) {
        this.enableIDTable = enableIDTable;
    }

    public boolean isEnableIDTableLogFile() {
        return this.enableIDTableLogFile;
    }

    public void setEnableIDTableLogFile(boolean enableIDTableLogFile) {
        this.enableIDTableLogFile = enableIDTableLogFile;
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public boolean isEnableOperationSync() {
        return this.enableOperationSync;
    }

    public void setEnableOperationSync(boolean enableOperationSync) {
        this.enableOperationSync = enableOperationSync;
    }

    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public void setSecondaryAddress(String secondaryAddress) {
        this.secondaryAddress = secondaryAddress;
    }

    public int getSecondaryPort() {
        return this.secondaryPort;
    }

    public void setSecondaryPort(int secondaryPort) {
        this.secondaryPort = secondaryPort;
    }

    public String getSecondaryUser() {
        return this.secondaryUser;
    }

    public void setSecondaryUser(String secondaryUser) {
        this.secondaryUser = secondaryUser;
    }

    public String getSecondaryPassword() {
        return this.secondaryPassword;
    }

    public void setSecondaryPassword(String secondaryPassword) {
        this.secondaryPassword = secondaryPassword;
    }

    public int getOperationSyncSessionConcurrencySize() {
        return this.OperationSyncSessionConcurrencySize;
    }

    public void setOperationSyncSessionConcurrencySize(int operationSyncSessionConcurrencySize) {
        this.OperationSyncSessionConcurrencySize = operationSyncSessionConcurrencySize;
    }

    public String getOperationSyncLogDir() {
        return this.operationSyncLogDir;
    }

    public void setOperationSyncLogDir(String operationSyncLogDir) {
        this.operationSyncLogDir = operationSyncLogDir;
    }

    public int getOperationSyncLogValidity() {
        return this.operationSyncLogValidity;
    }

    public void setOperationSyncLogValidity(int operationSyncLogValidity) {
        this.operationSyncLogValidity = operationSyncLogValidity;
    }

    public int getOperationSyncLogNum() {
        return this.operationSyncLogNum;
    }

    public void setOperationSyncLogNum(int operationSyncLogNum) {
        this.operationSyncLogNum = operationSyncLogNum;
    }

    public long getOperationSyncMaxLogSize() {
        return this.operationSyncMaxLogSize;
    }

    public void setOperationSyncMaxLogSize(long operationSyncMaxLogSize) {
        this.operationSyncMaxLogSize = operationSyncMaxLogSize;
    }

    public int getOperationSyncProducerCacheSize() {
        return this.operationSyncProducerCacheSize;
    }

    public void setOperationSyncProducerCacheSize(int operationSyncProducerCacheSize) {
        this.operationSyncProducerCacheSize = operationSyncProducerCacheSize;
    }

    public int getOperationSyncConsumerConcurrencySize() {
        return this.operationSyncConsumerConcurrencySize;
    }

    public void setOperationSyncConsumerConcurrencySize(int operationSyncConsumerConcurrencySize) {
        this.operationSyncConsumerConcurrencySize = operationSyncConsumerConcurrencySize;
    }

    public int getSchemaQueryFetchSize() {
        return this.schemaQueryFetchSize;
    }

    public void setSchemaQueryFetchSize(int schemaQueryFetchSize) {
        this.schemaQueryFetchSize = schemaQueryFetchSize;
    }
}

