/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class AlignedTVList
extends TVList {
    private List<TSDataType> dataTypes;
    private List<List<Object>> values;
    private List<int[]> indices;
    private List<List<BitMap>> bitMaps;
    private int[][] sortedIndices;
    private int pivotIndex;

    AlignedTVList(List<TSDataType> types) {
        this.indices = new ArrayList<int[]>(types.size());
        this.dataTypes = types;
        this.values = new ArrayList<List<Object>>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            this.values.add(new ArrayList());
        }
    }

    public static AlignedTVList newAlignedList(List<TSDataType> datatypes) {
        return new AlignedTVList(datatypes);
    }

    @Override
    public void putAlignedValue(long timestamp, Object[] value, int[] columnIndexArray) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.minTime = Math.min(this.minTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        block8: for (int i = 0; i < this.values.size(); ++i) {
            Object columnValue = columnIndexArray[i] < 0 ? null : value[columnIndexArray[i]];
            List<Object> columnValues = this.values.get(i);
            if (columnValue == null) {
                this.markNullValue(i, arrayIndex, elementIndex);
            }
            switch (this.dataTypes.get(i)) {
                case TEXT: {
                    ((Binary[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Binary)columnValue : Binary.EMPTY_VALUE;
                    continue block8;
                }
                case FLOAT: {
                    ((float[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? ((Float)columnValue).floatValue() : Float.MIN_VALUE;
                    continue block8;
                }
                case INT32: {
                    ((int[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Integer)columnValue : Integer.MIN_VALUE;
                    continue block8;
                }
                case INT64: {
                    ((long[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Long)columnValue : Long.MIN_VALUE;
                    continue block8;
                }
                case DOUBLE: {
                    ((double[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null ? (Double)columnValue : Double.MIN_VALUE;
                    continue block8;
                }
                case BOOLEAN: {
                    ((boolean[])columnValues.get((int)arrayIndex))[elementIndex] = columnValue != null && (Boolean)columnValue != false;
                    continue block8;
                }
            }
        }
        this.indices.get((int)arrayIndex)[elementIndex] = this.rowCount++;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public Object getAlignedValue(int index) {
        return this.getAlignedValueForQuery(index, null, null);
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        throw new UnsupportedOperationException("DataType not consistent");
    }

    private Object getAlignedValueForQuery(int index, Integer floatPrecision, List<TSEncoding> encodingList) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        int valueIndex = this.indices.get(arrayIndex)[elementIndex];
        return this.getAlignedValueByValueIndex(valueIndex, null, floatPrecision, encodingList);
    }

    public TsPrimitiveType getAlignedValue(List<Integer> timeDuplicatedIndexList, Integer floatPrecision, List<TSEncoding> encodingList) {
        int[] validIndexesForTimeDuplicatedRows = new int[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            validIndexesForTimeDuplicatedRows[i] = this.getValidRowIndexForTimeDuplicatedRows(timeDuplicatedIndexList, i);
        }
        return this.getAlignedValueByValueIndex(timeDuplicatedIndexList.get(timeDuplicatedIndexList.size() - 1), validIndexesForTimeDuplicatedRows, floatPrecision, encodingList);
    }

    private TsPrimitiveType getAlignedValueByValueIndex(int valueIndex, int[] validIndexesForTimeDuplicatedRows, Integer floatPrecision, List<TSEncoding> encodingList) {
        if (valueIndex >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(valueIndex);
        }
        TsPrimitiveType[] vector = new TsPrimitiveType[this.values.size()];
        block8: for (int columnIndex = 0; columnIndex < this.values.size(); ++columnIndex) {
            List<Object> columnValues = this.values.get(columnIndex);
            int validValueIndex = validIndexesForTimeDuplicatedRows != null ? validIndexesForTimeDuplicatedRows[columnIndex] : valueIndex;
            int arrayIndex = validValueIndex / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIndex = validValueIndex % PrimitiveArrayManager.ARRAY_SIZE;
            if (columnValues == null || this.isValueMarked(validValueIndex, columnIndex)) continue;
            switch (this.dataTypes.get(columnIndex)) {
                case TEXT: {
                    Binary valueT = ((Binary[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)valueT);
                    continue block8;
                }
                case FLOAT: {
                    float valueF = ((float[])columnValues.get(arrayIndex))[elementIndex];
                    if (!(floatPrecision == null || encodingList == null || Float.isNaN(valueF) || encodingList.get(columnIndex) != TSEncoding.RLE && encodingList.get(columnIndex) != TSEncoding.TS_2DIFF)) {
                        valueF = MathUtils.roundWithGivenPrecision(valueF, (int)floatPrecision);
                    }
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(valueF));
                    continue block8;
                }
                case INT32: {
                    int valueI = ((int[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)valueI);
                    continue block8;
                }
                case INT64: {
                    long valueL = ((long[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)valueL);
                    continue block8;
                }
                case DOUBLE: {
                    double valueD = ((double[])columnValues.get(arrayIndex))[elementIndex];
                    if (!(floatPrecision == null || encodingList == null || Double.isNaN(valueD) || encodingList.get(columnIndex) != TSEncoding.RLE && encodingList.get(columnIndex) != TSEncoding.TS_2DIFF)) {
                        valueD = MathUtils.roundWithGivenPrecision(valueD, (int)floatPrecision);
                    }
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)valueD);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean valueB = ((boolean[])columnValues.get(arrayIndex))[elementIndex];
                    vector[columnIndex] = TsPrimitiveType.getByType((TSDataType)TSDataType.BOOLEAN, (Object)valueB);
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("DataType not consistent");
                }
            }
        }
        return TsPrimitiveType.getByType((TSDataType)TSDataType.VECTOR, (Object)vector);
    }

    @Override
    public TVList getTvListByColumnIndex(List<Integer> columnIndex) {
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        ArrayList<List<BitMap>> bitMaps = null;
        for (int i = 0; i < columnIndex.size(); ++i) {
            if (columnIndex.get(i) == -1) {
                types.add(null);
                values.add(null);
                continue;
            }
            types.add(this.dataTypes.get(columnIndex.get(i)));
            values.add(this.values.get(columnIndex.get(i)));
            if (this.bitMaps == null || this.bitMaps.get(columnIndex.get(i)) == null) continue;
            if (bitMaps == null) {
                bitMaps = new ArrayList<List<BitMap>>(columnIndex.size());
                for (int j = 0; j < columnIndex.size(); ++j) {
                    bitMaps.add(null);
                }
            }
            bitMaps.set(i, this.bitMaps.get(columnIndex.get(i)));
        }
        AlignedTVList alignedTvList = new AlignedTVList(types);
        alignedTvList.timestamps = this.timestamps;
        alignedTvList.indices = this.indices;
        alignedTvList.values = values;
        alignedTvList.bitMaps = bitMaps;
        alignedTvList.rowCount = this.rowCount;
        return alignedTvList;
    }

    public void extendColumn(TSDataType dataType) {
        if (this.bitMaps == null) {
            this.bitMaps = new ArrayList<List<BitMap>>(this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                this.bitMaps.add(null);
            }
        }
        ArrayList<Object> columnValue = new ArrayList<Object>();
        ArrayList<BitMap> columnBitMaps = new ArrayList<BitMap>();
        for (int i = 0; i < this.timestamps.size(); ++i) {
            switch (dataType) {
                case TEXT: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.TEXT));
                    break;
                }
                case FLOAT: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.FLOAT));
                    break;
                }
                case INT32: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.INT32));
                    break;
                }
                case INT64: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.INT64));
                    break;
                }
                case DOUBLE: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.DOUBLE));
                    break;
                }
                case BOOLEAN: {
                    columnValue.add(this.getPrimitiveArraysByType(TSDataType.BOOLEAN));
                    break;
                }
            }
            BitMap bitMap = new BitMap(PrimitiveArrayManager.ARRAY_SIZE);
            if (i == this.timestamps.size() - 1 && this.rowCount % PrimitiveArrayManager.ARRAY_SIZE != 0) {
                for (int j = 0; j < this.rowCount % PrimitiveArrayManager.ARRAY_SIZE; ++j) {
                    bitMap.mark(j);
                }
            } else {
                bitMap.markAll();
            }
            columnBitMaps.add(bitMap);
        }
        this.bitMaps.add(columnBitMaps);
        this.values.add(columnValue);
        this.dataTypes.add(dataType);
    }

    public int getIntByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((int[])columnValues.get(arrayIndex))[elementIndex];
    }

    public long getLongByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((long[])columnValues.get(arrayIndex))[elementIndex];
    }

    public float getFloatByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((float[])columnValues.get(arrayIndex))[elementIndex];
    }

    public double getDoubleByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((double[])columnValues.get(arrayIndex))[elementIndex];
    }

    public Binary getBinaryByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((Binary[])columnValues.get(arrayIndex))[elementIndex];
    }

    public boolean getBooleanByValueIndex(int rowIndex, int columnIndex) {
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<Object> columnValues = this.values.get(columnIndex);
        return ((boolean[])columnValues.get(arrayIndex))[elementIndex];
    }

    public boolean isValueMarked(int rowIndex, int columnIndex) {
        if (rowIndex >= this.rowCount) {
            return false;
        }
        if (this.bitMaps == null || this.bitMaps.get(columnIndex) == null || this.bitMaps.get(columnIndex).get(rowIndex / PrimitiveArrayManager.ARRAY_SIZE) == null) {
            return false;
        }
        int arrayIndex = rowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = rowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        List<BitMap> columnBitMaps = this.bitMaps.get(columnIndex);
        return columnBitMaps.get(arrayIndex).isMarked(elementIndex);
    }

    public List<List<Object>> getValues() {
        return this.values;
    }

    public List<TSDataType> getTsDataTypes() {
        return this.dataTypes;
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        int deletedNumber = 0;
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            deletedNumber += ((Integer)this.delete((long)lowerBound, (long)upperBound, (int)i).left).intValue();
        }
        return deletedNumber;
    }

    public Pair<Integer, Boolean> delete(long lowerBound, long upperBound, int columnIndex) {
        int deletedNumber = 0;
        boolean deleteColumn = true;
        for (int i = 0; i < this.rowCount; ++i) {
            long time = this.getTime(i);
            if (time >= lowerBound && time <= upperBound) {
                int originRowIndex = this.getValueIndex(i);
                int arrayIndex = originRowIndex / PrimitiveArrayManager.ARRAY_SIZE;
                int elementIndex = originRowIndex % PrimitiveArrayManager.ARRAY_SIZE;
                this.markNullValue(columnIndex, arrayIndex, elementIndex);
                ++deletedNumber;
                continue;
            }
            deleteColumn = false;
        }
        return new Pair((Object)deletedNumber, (Object)deleteColumn);
    }

    public void deleteColumn(int columnIndex) {
        this.dataTypes.remove(columnIndex);
        for (Object array : this.values.get(columnIndex)) {
            PrimitiveArrayManager.release(array);
        }
        this.values.remove(columnIndex);
        this.bitMaps.remove(columnIndex);
    }

    private void set(int index, long timestamp, int value) {
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.indices.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public AlignedTVList clone() {
        AlignedTVList cloneList = new AlignedTVList(this.dataTypes);
        this.cloneAs(cloneList);
        for (int[] indicesArray : this.indices) {
            cloneList.indices.add(this.cloneIndex(indicesArray));
        }
        for (int i = 0; i < this.values.size(); ++i) {
            List<Object> columnValues = this.values.get(i);
            for (Object valueArray : columnValues) {
                cloneList.values.get(i).add(this.cloneValue(this.dataTypes.get(i), valueArray));
            }
            if (this.bitMaps == null || this.bitMaps.get(i) == null) continue;
            List<BitMap> columnBitMaps = this.bitMaps.get(i);
            if (cloneList.bitMaps == null) {
                cloneList.bitMaps = new ArrayList<List<BitMap>>(this.dataTypes.size());
                for (int j = 0; j < this.dataTypes.size(); ++j) {
                    cloneList.bitMaps.add(null);
                }
            }
            if (cloneList.bitMaps.get(i) != null) continue;
            ArrayList<BitMap> cloneColumnBitMaps = new ArrayList<BitMap>();
            for (BitMap bitMap : columnBitMaps) {
                cloneColumnBitMaps.add(bitMap == null ? null : bitMap.clone());
            }
            cloneList.bitMaps.set(i, cloneColumnBitMaps);
        }
        return cloneList;
    }

    private int[] cloneIndex(int[] array) {
        int[] cloneArray = new int[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    private Object cloneValue(TSDataType type, Object value) {
        switch (type) {
            case TEXT: {
                Binary[] valueT = (Binary[])value;
                Binary[] cloneT = new Binary[valueT.length];
                System.arraycopy(valueT, 0, cloneT, 0, valueT.length);
                return cloneT;
            }
            case FLOAT: {
                float[] valueF = (float[])value;
                float[] cloneF = new float[valueF.length];
                System.arraycopy(valueF, 0, cloneF, 0, valueF.length);
                return cloneF;
            }
            case INT32: {
                int[] valueI = (int[])value;
                int[] cloneI = new int[valueI.length];
                System.arraycopy(valueI, 0, cloneI, 0, valueI.length);
                return cloneI;
            }
            case INT64: {
                long[] valueL = (long[])value;
                long[] cloneL = new long[valueL.length];
                System.arraycopy(valueL, 0, cloneL, 0, valueL.length);
                return cloneL;
            }
            case DOUBLE: {
                double[] valueD = (double[])value;
                double[] cloneD = new double[valueD.length];
                System.arraycopy(valueD, 0, cloneD, 0, valueD.length);
                return cloneD;
            }
            case BOOLEAN: {
                boolean[] valueB = (boolean[])value;
                boolean[] cloneB = new boolean[valueB.length];
                System.arraycopy(valueB, 0, cloneB, 0, valueB.length);
                return cloneB;
            }
        }
        return null;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.rowCount);
        }
        if (this.sortedIndices == null || this.sortedIndices.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedIndices = (int[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT32, this.rowCount);
        }
        this.sort(0, this.rowCount);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.indices != null) {
            for (int[] dataArray : this.indices) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.indices.clear();
        }
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            List<BitMap> columnBitMaps;
            List<Object> columnValues = this.values.get(i);
            if (columnValues != null) {
                for (Object dataArray : columnValues) {
                    PrimitiveArrayManager.release(dataArray);
                }
                columnValues.clear();
            }
            if (this.bitMaps == null || (columnBitMaps = this.bitMaps.get(i)) == null) continue;
            columnBitMaps.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedIndices != null) {
            this.sortedIndices = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedIndices[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        int srcV = this.getValueIndex(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedIndices[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getValueIndex(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            int loV = this.getValueIndex(lo);
            long hiT = this.getTime(hi);
            int hiV = this.getValueIndex(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.indices.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            this.values.get(i).add(this.getPrimitiveArraysByType(this.dataTypes.get(i)));
            if (this.bitMaps == null || this.bitMaps.get(i) == null) continue;
            this.bitMaps.get(i).add(null);
        }
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotIndex = this.getValueIndex(pos);
    }

    @Override
    public int getValueIndex(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.indices.get(arrayIndex)[elementIndex];
    }

    public int getValidRowIndexForTimeDuplicatedRows(List<Integer> timeDuplicatedOriginRowIndexList, int columnIndex) {
        int validRowIndex = timeDuplicatedOriginRowIndexList.get(0);
        for (int originRowIndex : timeDuplicatedOriginRowIndexList) {
            if (this.isValueMarked(originRowIndex, columnIndex)) continue;
            validRowIndex = originRowIndex;
        }
        return validRowIndex;
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotIndex);
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), (TsPrimitiveType)this.getAlignedValueForQuery(index, null, null));
    }

    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, List<TSEncoding> encodingList) {
        return new TimeValuePair(time, (TsPrimitiveType)this.getAlignedValueForQuery(index, floatPrecision, encodingList));
    }

    public TimeValuePair getTimeValuePairForTimeDuplicatedRows(List<Integer> indexList, long time, Integer floatPrecision, List<TSEncoding> encodingList) {
        return new TimeValuePair(time, this.getAlignedValue(indexList, floatPrecision, encodingList));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.indices.remove(this.indices.size() - 1));
        for (List<Object> valueList : this.values) {
            PrimitiveArrayManager.release(valueList.remove(valueList.size() - 1));
        }
    }

    @Override
    public void putAlignedValues(long[] time, Object[] value, BitMap[] bitMaps, int[] columnIndexArray, int start, int end) {
        int internalRemaining;
        this.checkExpansion();
        this.updateMinTimeAndSorted(time, start, end);
        for (int idx = start; idx < end; idx += internalRemaining) {
            int j;
            int i;
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                this.arrayCopy(value, idx, arrayIdx, elementIdx, inputRemaining, columnIndexArray);
                for (i = 0; i < inputRemaining; ++i) {
                    this.indices.get((int)arrayIdx)[elementIdx + i] = this.rowCount;
                    for (j = 0; j < this.values.size(); ++j) {
                        if (columnIndexArray[j] >= 0 && (bitMaps == null || bitMaps[columnIndexArray[j]] == null || !bitMaps[columnIndexArray[j]].isMarked(idx + i))) continue;
                        this.markNullValue(j, arrayIdx, elementIdx + i);
                    }
                    ++this.rowCount;
                }
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            this.arrayCopy(value, idx, arrayIdx, elementIdx, internalRemaining, columnIndexArray);
            for (i = 0; i < internalRemaining; ++i) {
                this.indices.get((int)arrayIdx)[elementIdx + i] = this.rowCount;
                for (j = 0; j < this.values.size(); ++j) {
                    if (columnIndexArray[j] >= 0 && (bitMaps == null || bitMaps[columnIndexArray[j]] == null || !bitMaps[columnIndexArray[j]].isMarked(idx + i))) continue;
                    this.markNullValue(j, arrayIdx, elementIdx + i);
                }
                ++this.rowCount;
            }
            this.checkExpansion();
        }
    }

    private void arrayCopy(Object[] value, int idx, int arrayIndex, int elementIndex, int remaining, int[] columnIndexArray) {
        block8: for (int i = 0; i < this.values.size(); ++i) {
            if (columnIndexArray[i] < 0) continue;
            List<Object> columnValues = this.values.get(i);
            switch (this.dataTypes.get(i)) {
                case TEXT: {
                    Binary[] arrayT = (Binary[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayT, elementIndex, remaining);
                    continue block8;
                }
                case FLOAT: {
                    float[] arrayF = (float[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayF, elementIndex, remaining);
                    continue block8;
                }
                case INT32: {
                    int[] arrayI = (int[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayI, elementIndex, remaining);
                    continue block8;
                }
                case INT64: {
                    long[] arrayL = (long[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayL, elementIndex, remaining);
                    continue block8;
                }
                case DOUBLE: {
                    double[] arrayD = (double[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayD, elementIndex, remaining);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean[] arrayB = (boolean[])columnValues.get(arrayIndex);
                    System.arraycopy(value[columnIndexArray[i]], idx, arrayB, elementIndex, remaining);
                    continue block8;
                }
            }
        }
    }

    private void markNullValue(int columnIndex, int arrayIndex, int elementIndex) {
        if (this.bitMaps == null) {
            this.bitMaps = new ArrayList<List<BitMap>>(this.dataTypes.size());
            for (int i = 0; i < this.dataTypes.size(); ++i) {
                this.bitMaps.add(null);
            }
        }
        if (this.bitMaps.get(columnIndex) == null) {
            ArrayList<BitMap> columnBitMaps = new ArrayList<BitMap>();
            for (int i = 0; i < this.values.get(columnIndex).size(); ++i) {
                columnBitMaps.add(new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
            }
            this.bitMaps.set(columnIndex, columnBitMaps);
        }
        if (this.bitMaps.get(columnIndex).get(arrayIndex) == null) {
            this.bitMaps.get(columnIndex).set(arrayIndex, new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
        }
        this.bitMaps.get(columnIndex).get(arrayIndex).mark(elementIndex);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.VECTOR;
    }

    public static long alignedTvListArrayMemCost(TSDataType[] types) {
        long size = 0L;
        for (TSDataType type : types) {
            if (type == null) continue;
            size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        }
        if (size == 0L) {
            return size;
        }
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 4L;
        size += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * (2 + types.length));
        return size += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF * (2 + types.length));
    }

    @Override
    public void clear() {
        this.rowCount = 0;
        this.sorted = true;
        this.minTime = Long.MAX_VALUE;
        this.clearTime();
        this.clearSortedTime();
        this.clearValue();
        this.clearSortedValue();
    }

    @Override
    public IPointReader getIterator() {
        return new AlignedIte();
    }

    @Override
    public IPointReader getIterator(int floatPrecision, TSEncoding encoding, int size, List<TimeRange> deletionList) {
        throw new UnsupportedOperationException("DataType not consistent");
    }

    public IPointReader getAlignedIterator(int floatPrecision, List<TSEncoding> encodingList, int size, List<List<TimeRange>> deletionList) {
        return new AlignedIte(floatPrecision, encodingList, size, deletionList);
    }

    private class AlignedIte
    extends TVList.Ite {
        private List<TSEncoding> encodingList;
        private int[] deleteCursors;
        private List<List<TimeRange>> deletionList;

        public AlignedIte() {
            super(AlignedTVList.this);
        }

        public AlignedIte(int floatPrecision, List<TSEncoding> encodingList, int size, List<List<TimeRange>> deletionList) {
            super(AlignedTVList.this, floatPrecision, null, size, null);
            this.encodingList = encodingList;
            this.deletionList = deletionList;
            if (deletionList != null) {
                this.deleteCursors = new int[deletionList.size()];
            }
        }

        @Override
        public boolean hasNextTimeValuePair() {
            if (this.hasCachedPair) {
                return true;
            }
            ArrayList<Integer> timeDuplicatedAlignedRowIndexList = null;
            while (this.cur < this.iteSize) {
                TimeValuePair tvPair;
                long time = AlignedTVList.this.getTime(this.cur);
                if (this.cur + 1 < AlignedTVList.this.rowCount() && time == AlignedTVList.this.getTime(this.cur + 1)) {
                    if (timeDuplicatedAlignedRowIndexList == null) {
                        timeDuplicatedAlignedRowIndexList = new ArrayList<Integer>();
                        timeDuplicatedAlignedRowIndexList.add(AlignedTVList.this.getValueIndex(this.cur));
                    }
                    timeDuplicatedAlignedRowIndexList.add(AlignedTVList.this.getValueIndex(this.cur + 1));
                    ++this.cur;
                    continue;
                }
                if (timeDuplicatedAlignedRowIndexList != null) {
                    tvPair = AlignedTVList.this.getTimeValuePairForTimeDuplicatedRows(timeDuplicatedAlignedRowIndexList, time, this.floatPrecision, this.encodingList);
                    timeDuplicatedAlignedRowIndexList = null;
                } else {
                    tvPair = AlignedTVList.this.getTimeValuePair(this.cur, time, this.floatPrecision, this.encodingList);
                }
                ++this.cur;
                if (this.deletePointsInDeletionList(time, tvPair) || tvPair.getValue() == null) continue;
                this.cachedTimeValuePair = tvPair;
                this.hasCachedPair = true;
                return true;
            }
            return false;
        }

        private boolean deletePointsInDeletionList(long timestamp, TimeValuePair tvPair) {
            if (this.deletionList == null) {
                return false;
            }
            boolean deletedAll = true;
            block0: for (int i = 0; i < this.deleteCursors.length; ++i) {
                while (this.deletionList.get(i) != null && this.deleteCursors[i] < this.deletionList.get(i).size()) {
                    if (this.deletionList.get(i).get(this.deleteCursors[i]).contains(timestamp)) {
                        tvPair.getValue().getVector()[i] = null;
                        continue block0;
                    }
                    if (this.deletionList.get(i).get(this.deleteCursors[i]).getMax() < timestamp) {
                        int n = i;
                        this.deleteCursors[n] = this.deleteCursors[n] + 1;
                        continue;
                    }
                    deletedAll = false;
                    continue block0;
                }
            }
            return deletedAll;
        }
    }
}

