/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.concurrent.threadpool.WrappedScheduledExecutorService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionMetricsManager;
import org.apache.iotdb.db.engine.compaction.CompactionTaskComparator;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final CompactionTaskManager INSTANCE = new CompactionTaskManager();
    private WrappedScheduledExecutorService taskExecutionPool;
    private ScheduledExecutorService subCompactionTaskExecutionPool;
    public static volatile AtomicInteger currentTaskNum = new AtomicInteger(0);
    private FixedPriorityBlockingQueue<AbstractCompactionTask> candidateCompactionTaskQueue = new FixedPriorityBlockingQueue<AbstractCompactionTask>(1024, new CompactionTaskComparator());
    private Map<String, Set<Future<CompactionTaskSummary>>> storageGroupTasks = new ConcurrentHashMap<String, Set<Future<CompactionTaskSummary>>>();
    private List<AbstractCompactionTask> runningCompactionTaskList = new ArrayList<AbstractCompactionTask>();
    private ScheduledExecutorService compactionTaskSubmissionThreadPool;
    private final long TASK_SUBMIT_INTERVAL = IoTDBDescriptor.getInstance().getConfig().getCompactionSubmissionIntervalInMs();
    private final RateLimiter mergeWriteRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static CompactionTaskManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void start() {
        if (this.taskExecutionPool == null && IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0 && (this.config.isEnableSeqSpaceCompaction() || this.config.isEnableCrossSpaceCompaction() || this.config.isEnableUnseqSpaceCompaction())) {
            this.taskExecutionPool = (WrappedScheduledExecutorService)IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), ThreadName.COMPACTION_SERVICE.getName());
            this.subCompactionTaskExecutionPool = IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() * IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum(), ThreadName.COMPACTION_SUB_SERVICE.getName());
            currentTaskNum = new AtomicInteger(0);
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool(1, ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.regsitPollLastHook(x -> CompactionMetricsManager.recordTaskInfo(x, CompactionTaskStatus.POLL_FROM_QUEUE, this.candidateCompactionTaskQueue.size()));
            this.compactionTaskSubmissionThreadPool.scheduleWithFixedDelay(this::submitTaskFromTaskQueue, this.TASK_SUBMIT_INTERVAL, this.TASK_SUBMIT_INTERVAL, TimeUnit.MILLISECONDS);
        }
        logger.info("Compaction task manager started.");
    }

    @Override
    public void stop() {
        if (this.taskExecutionPool != null) {
            this.taskExecutionPool.shutdownNow();
            this.compactionTaskSubmissionThreadPool.shutdownNow();
            logger.info("Waiting for task taskExecutionPool to shut down");
            this.waitTermination();
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
        }
    }

    @Override
    public void waitAndStop(long milliseconds) {
        if (this.taskExecutionPool != null) {
            this.awaitTermination(this.taskExecutionPool, milliseconds);
            this.awaitTermination(this.compactionTaskSubmissionThreadPool, milliseconds);
            logger.info("Waiting for task taskExecutionPool to shut down in {} ms", (Object)milliseconds);
            this.waitTermination();
            this.storageGroupTasks.clear();
        }
    }

    public void waitAllCompactionFinish() {
        long sleepingStartTime = 0L;
        long MAX_WAITING_TIME = 120000L;
        if (this.taskExecutionPool != null) {
            while (this.taskExecutionPool.getActiveCount() > 0 || this.taskExecutionPool.getQueue().size() > 0) {
                try {
                    Thread.sleep(200L);
                    if ((sleepingStartTime += 200L) % 10000L == 0L) {
                        logger.warn("Has waiting {} seconds for all compaction task finish", (Object)(sleepingStartTime / 1000L));
                    }
                    if (sleepingStartTime < MAX_WAITING_TIME) continue;
                    return;
                }
                catch (InterruptedException e) {
                    logger.error("thread interrupted while waiting for compaction to end", (Throwable)e);
                    return;
                }
            }
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
            logger.info("All compaction task finish");
        }
    }

    private void waitTermination() {
        long startTime = System.currentTimeMillis();
        while (!this.taskExecutionPool.isTerminated()) {
            int timeMillis = 0;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("CompactionMergeTaskPoolManager {} shutdown", (Object)ThreadName.COMPACTION_SERVICE.getName(), (Object)e);
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.info("CompactionManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        this.taskExecutionPool = null;
        this.storageGroupTasks.clear();
        logger.info("CompactionManager stopped");
    }

    private void awaitTermination(ExecutorService service, long milliseconds) {
        try {
            service.shutdown();
            service.awaitTermination(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("CompactionThreadPool can not be closed in {} ms", (Object)milliseconds);
            Thread.currentThread().interrupt();
        }
        service.shutdownNow();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.COMPACTION_SERVICE;
    }

    public synchronized boolean addTaskToWaitingQueue(AbstractCompactionTask compactionTask) throws InterruptedException {
        if (!this.candidateCompactionTaskQueue.contains(compactionTask) && !this.runningCompactionTaskList.contains(compactionTask)) {
            compactionTask.setSourceFilesToCompactionCandidate();
            this.candidateCompactionTaskQueue.put(compactionTask);
            CompactionMetricsManager.recordTaskInfo(compactionTask, CompactionTaskStatus.ADD_TO_QUEUE, this.candidateCompactionTaskQueue.size());
            return true;
        }
        return false;
    }

    public synchronized void submitTaskFromTaskQueue() {
        try {
            while (currentTaskNum.get() < IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() && !this.candidateCompactionTaskQueue.isEmpty()) {
                AbstractCompactionTask task = this.candidateCompactionTaskQueue.take();
                CompactionMetricsManager.recordTaskInfo(task, CompactionTaskStatus.POLL_FROM_QUEUE, this.candidateCompactionTaskQueue.size());
                if (task == null || !task.checkValidAndSetMerging()) continue;
                this.submitTask(task);
                this.runningCompactionTaskList.add(task);
                CompactionMetricsManager.recordTaskInfo(task, CompactionTaskStatus.READY_TO_EXECUTE, this.runningCompactionTaskList.size());
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception occurs while submitting compaction task", (Throwable)e);
        }
    }

    public RateLimiter getMergeWriteRateLimiter() {
        this.setWriteMergeRate(IoTDBDescriptor.getInstance().getConfig().getCompactionWriteThroughputMbPerSec());
        return this.mergeWriteRateLimiter;
    }

    private void setWriteMergeRate(double throughoutMbPerSec) {
        double throughout = throughoutMbPerSec * 1024.0 * 1024.0;
        if (throughout == 0.0) {
            throughout = Double.MAX_VALUE;
        }
        if (this.mergeWriteRateLimiter.getRate() != throughout) {
            this.mergeWriteRateLimiter.setRate(throughout);
        }
    }

    public static void mergeRateLimiterAcquire(RateLimiter limiter, long bytesLength) {
        while (bytesLength >= Integer.MAX_VALUE) {
            limiter.acquire(Integer.MAX_VALUE);
            bytesLength -= Integer.MAX_VALUE;
        }
        if (bytesLength > 0L) {
            limiter.acquire((int)bytesLength);
        }
    }

    public synchronized void removeRunningTaskFromList(AbstractCompactionTask task) {
        this.runningCompactionTaskList.remove(task);
        CompactionMetricsManager.recordTaskInfo(task, CompactionTaskStatus.FINISHED, this.runningCompactionTaskList.size());
    }

    public synchronized Future<CompactionTaskSummary> submitTask(Callable<CompactionTaskSummary> compactionMergeTask) throws RejectedExecutionException {
        if (this.taskExecutionPool != null && !this.taskExecutionPool.isShutdown()) {
            Future<CompactionTaskSummary> future = this.taskExecutionPool.submit(compactionMergeTask);
            return future;
        }
        logger.warn("A CompactionTask failed to be submitted to CompactionTaskManager because {}", (Object)(this.taskExecutionPool == null ? "taskExecutionPool is null" : "taskExecutionPool is terminated"));
        return null;
    }

    public synchronized Future<Void> submitSubTask(Callable<Void> subCompactionTask) {
        if (this.subCompactionTaskExecutionPool != null && !this.subCompactionTaskExecutionPool.isShutdown()) {
            return this.subCompactionTaskExecutionPool.submit(subCompactionTask);
        }
        return null;
    }

    public void abortCompaction(String fullStorageGroupName) {
        Set subTasks = this.storageGroupTasks.getOrDefault(fullStorageGroupName, Collections.emptySet());
        this.candidateCompactionTaskQueue.clear();
        Iterator subIterator = subTasks.iterator();
        while (subIterator.hasNext()) {
            Future next = (Future)subIterator.next();
            if (!next.isDone() && !next.isCancelled()) {
                next.cancel(true);
            }
            subIterator.remove();
        }
    }

    public int getExecutingTaskCount() {
        return this.taskExecutionPool.getActiveCount() + this.taskExecutionPool.getQueue().size();
    }

    public int getTotalTaskCount() {
        return this.getExecutingTaskCount() + this.candidateCompactionTaskQueue.size();
    }

    public synchronized List<AbstractCompactionTask> getRunningCompactionTaskList() {
        return new ArrayList<AbstractCompactionTask>(this.runningCompactionTaskList);
    }

    public long getFinishTaskNum() {
        return this.taskExecutionPool.getCompletedTaskCount();
    }

    public void restart() throws InterruptedException {
        if (IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0) {
            if (this.taskExecutionPool != null) {
                this.taskExecutionPool.shutdownNow();
                this.taskExecutionPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            this.taskExecutionPool = (WrappedScheduledExecutorService)IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), ThreadName.COMPACTION_SERVICE.getName());
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool(1, ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.clear();
        }
        currentTaskNum = new AtomicInteger(0);
        logger.info("Compaction task manager started.");
    }

    public void clearCandidateQueue() {
        this.candidateCompactionTaskQueue.clear();
    }
}

