/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricManager;
import org.apache.iotdb.metrics.dropwizard.reporter.DropwizardMetricsExporter;
import org.apache.iotdb.metrics.dropwizard.reporter.PrometheusTextWriter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class DropwizardPrometheusReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardPrometheusReporter.class);
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private MetricManager dropwizardMetricManager = null;
    private DisposableServer httpServer = null;

    public boolean start() {
        if (this.httpServer != null) {
            LOGGER.warn("Dropwizard Prometheus Reporter already start!");
            return false;
        }
        this.httpServer = ((HttpServer)HttpServer.create().idleTimeout(Duration.ofMillis(30000L)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000)).port(Integer.parseInt(metricConfig.getPrometheusExporterPort())).route(routes -> routes.get("/metrics", (request, response) -> response.sendString((Publisher)Mono.just((Object)this.scrape())))).bindNow();
        LOGGER.info("http server for metrics started, listen on {}", (Object)metricConfig.getPrometheusExporterPort());
        return true;
    }

    private String scrape() {
        MetricRegistry metricRegistry = ((DropwizardMetricManager)this.dropwizardMetricManager).getMetricRegistry();
        StringWriter writer = new StringWriter();
        PrometheusTextWriter prometheusTextWriter = new PrometheusTextWriter(writer);
        DropwizardMetricsExporter dropwizardMetricsExporter = new DropwizardMetricsExporter(metricRegistry, prometheusTextWriter);
        String result = "";
        try {
            dropwizardMetricsExporter.scrape();
            result = ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public boolean stop() {
        if (this.httpServer != null) {
            try {
                this.httpServer.disposeNow();
                this.httpServer = null;
            }
            catch (Exception e) {
                LOGGER.error("failed to stop server", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.PROMETHEUS;
    }

    public void setMetricManager(MetricManager metricManager) {
        this.dropwizardMetricManager = metricManager;
    }
}

