/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.PredefinedMetric;

public class FileMetrics
implements IMetricSet {
    public void bindTo(MetricManager metricManager) {
        String walDir = DirectoryManager.getInstance().getWALFolder();
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)walDir, org.apache.iotdb.db.utils.FileUtils::getDirSize, new String[]{Tag.NAME.toString(), "wal"});
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)walDir, value -> {
            File walFolder = new File((String)value);
            if (walFolder.exists() && walFolder.isDirectory()) {
                return FileUtils.listFiles((File)new File((String)value), null, (boolean)true).size();
            }
            return 0L;
        }, new String[]{Tag.NAME.toString(), "wal"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    public PredefinedMetric getType() {
        return PredefinedMetric.FILE;
    }
}

