/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanSerializer {
    private static final Logger logger = LoggerFactory.getLogger(PlanSerializer.class);
    private static final int DEFAULT_BAOS_SIZE = CommonUtils.getCpuCores() * 4;
    private BlockingDeque<ByteArrayOutputStream> baosBlockingDeque = new LinkedBlockingDeque<ByteArrayOutputStream>();
    private static final PlanSerializer instance = new PlanSerializer();

    private PlanSerializer() {
        for (int i = 0; i < DEFAULT_BAOS_SIZE; ++i) {
            this.baosBlockingDeque.push(new ByteArrayOutputStream(4096));
        }
    }

    public static PlanSerializer getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     */
    public byte[] serialize(PhysicalPlan plan) throws IOException {
        ByteArrayOutputStream poll;
        try {
            poll = this.baosBlockingDeque.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("take byte array output stream interrupted", e);
        }
        poll.reset();
        try {
            try (DataOutputStream dataOutputStream = new DataOutputStream(poll);){
                plan.serialize(dataOutputStream);
                byte[] byArray = poll.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                this.baosBlockingDeque.put(poll);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Putting byte array output stream back interrupted");
            }
        }
    }
}

