/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class TsFileAlignedSeriesReaderIterator {
    private TsFileSequenceReader reader;
    private List<AlignedChunkMetadata> alignedChunkMetadataList;
    private List<IMeasurementSchema> schemaList;
    private int curIdx = -1;

    public TsFileAlignedSeriesReaderIterator(TsFileSequenceReader reader, List<AlignedChunkMetadata> alignedChunkMetadataList, List<IMeasurementSchema> schemaList) {
        this.reader = reader;
        this.alignedChunkMetadataList = alignedChunkMetadataList;
        this.schemaList = schemaList;
    }

    public boolean hasNext() {
        return this.curIdx < this.alignedChunkMetadataList.size() - 1;
    }

    public AlignedChunkReader nextReader() throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = this.alignedChunkMetadataList.get(++this.curIdx);
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List<IChunkMetadata> valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        int schemaIdx = 0;
        Chunk timeChunk = this.reader.readMemChunk((ChunkMetadata)timeChunkMetadata);
        Chunk[] valueChunks = new Chunk[this.schemaList.size()];
        for (IChunkMetadata valueChunkMetadata : valueChunkMetadataList) {
            if (valueChunkMetadata == null) continue;
            while (!valueChunkMetadata.getMeasurementUid().equals(this.schemaList.get(schemaIdx).getMeasurementId())) {
                ++schemaIdx;
            }
            valueChunks[schemaIdx++] = this.reader.readMemChunk((ChunkMetadata)valueChunkMetadata);
        }
        AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, Arrays.asList(valueChunks), null);
        return chunkReader;
    }
}

