/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;

public class PreviousFill
extends IFill {
    private PartialPath seriesPath;
    private QueryContext context;
    private Set<String> allSensors;
    private Filter timeFilter;
    private boolean untilLast;

    public PreviousFill(TSDataType dataType, long queryTime, long beforeRange) {
        this(dataType, queryTime, beforeRange, false, false);
    }

    public PreviousFill(long beforeRange) {
        this(beforeRange, false);
    }

    public PreviousFill(String beforeStr) {
        this(beforeStr, false);
    }

    public PreviousFill(long beforeRange, boolean untilLast) {
        this.beforeRange = beforeRange;
        this.untilLast = untilLast;
    }

    public PreviousFill(String beforeStr, boolean untilLast) {
        this.beforeRange = DatetimeUtils.convertDurationStrToLong(beforeStr);
        this.untilLast = untilLast;
        if (beforeStr.toLowerCase().contains("mo")) {
            this.isBeforeByMonth = true;
        }
    }

    public PreviousFill(TSDataType dataType, long queryStartTime, long beforeRange, boolean untilLast, boolean isBeforeByMonth) {
        super(dataType, queryStartTime);
        this.beforeRange = beforeRange;
        this.untilLast = untilLast;
        this.isBeforeByMonth = isBeforeByMonth;
    }

    @Override
    public IFill copy() {
        return new PreviousFill(this.dataType, this.queryStartTime, this.beforeRange, this.untilLast, this.isBeforeByMonth);
    }

    @Override
    void constructFilter() {
        TimeFilter.TimeGtEq lowerBound = this.beforeRange == -1L ? TimeFilter.gtEq((long)Long.MIN_VALUE) : TimeFilter.gtEq((long)(this.queryStartTime - this.beforeRange));
        this.timeFilter = FilterFactory.and((Filter)lowerBound, (Filter)TimeFilter.ltEq((long)this.queryStartTime));
    }

    @Override
    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> sensors, QueryContext context) throws QueryProcessException, StorageEngineException {
        this.seriesPath = path;
        this.dataType = dataType;
        this.context = context;
        this.queryStartTime = queryTime;
        this.allSensors = sensors;
        this.constructFilter();
    }

    @Override
    public TimeValuePair getFillResult() throws IOException, QueryProcessException, StorageEngineException {
        QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(this.seriesPath, this.context, this.timeFilter, false);
        this.timeFilter = dataSource.updateFilterUsingTTL(this.timeFilter);
        LastPointReader lastReader = new LastPointReader(this.seriesPath, this.dataType, this.allSensors, this.context, dataSource, this.queryStartTime, this.timeFilter);
        return lastReader.readLastPoint();
    }

    public boolean isUntilLast() {
        return this.untilLast;
    }

    public void setUntilLast(boolean untilLast) {
        this.untilLast = untilLast;
    }
}

