/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogTxtWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogTxtWriter.class);
    private static final String STRING_TYPE = "%s,%s,%s" + System.lineSeparator();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final File logFile;
    private FileOutputStream fileOutputStream;
    private FileChannel channel;
    private final AtomicInteger lineNumber;

    public MLogTxtWriter(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber = new AtomicInteger(0);
    }

    public MLogTxtWriter(String logFileName) throws FileNotFoundException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFileName);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber = new AtomicInteger(0);
    }

    @Override
    public void close() throws IOException {
        this.fileOutputStream.close();
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%s,%s,%s,%s,%s", "0", plan.getPath().getFullPath(), plan.getDataType().serialize(), plan.getEncoding().serialize(), plan.getCompressor().serialize()));
        buf.append(",");
        if (plan.getProps() != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : plan.getProps().entrySet()) {
                if (first) {
                    buf.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    first = false;
                    continue;
                }
                buf.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        buf.append(",");
        if (plan.getAlias() != null) {
            buf.append(plan.getAlias());
        }
        buf.append(",");
        if (offset >= 0L) {
            buf.append(offset);
        }
        buf.append(LINE_SEPARATOR);
        this.channel.write(ByteBuffer.wrap(buf.toString().getBytes()));
        this.lineNumber.incrementAndGet();
    }

    public void createAlignedTimeseries(CreateAlignedTimeSeriesPlan plan) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%s,%s,%s,%s,%s,%s", "0", plan.getPrefixPath().getFullPath(), plan.getMeasurements(), plan.getDataTypes().stream().map(TSDataType::serialize), plan.getEncodings().stream().map(TSEncoding::serialize), plan.getCompressors().stream().map(CompressionType::serialize)));
        buf.append(",[");
        if (plan.getAliasList() != null) {
            List<String> aliasList = plan.getAliasList();
            for (int i = 0; i < aliasList.size(); ++i) {
                buf.append(aliasList.get(i));
                if (i == aliasList.size() - 1) continue;
                buf.append(",");
            }
        }
        buf.append("]");
        buf.append(LINE_SEPARATOR);
        this.channel.write(ByteBuffer.wrap(buf.toString().getBytes()));
        this.lineNumber.incrementAndGet();
    }

    public void deleteTimeseries(String path) throws IOException {
        String outputStr = "1," + path + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
    }

    public void createContinuousQuery(CreateContinuousQueryPlan plan) throws IOException {
        String buf = String.format("%s,%s,%s,%s", "14", plan.getContinuousQueryName(), plan.getQuerySql(), plan.getTargetPath().getFullPath()) + LINE_SEPARATOR;
        this.channel.write(ByteBuffer.wrap(buf.getBytes()));
        this.lineNumber.incrementAndGet();
    }

    public void dropContinuousQuery(DropContinuousQueryPlan plan) throws IOException {
        String buf = String.format("%s,%s", "15", plan.getContinuousQueryName()) + LINE_SEPARATOR;
        this.channel.write(ByteBuffer.wrap(buf.getBytes()));
        this.lineNumber.incrementAndGet();
    }

    public void setStorageGroup(String storageGroup) throws IOException {
        String outputStr = "2," + storageGroup + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void deleteStorageGroup(String storageGroup) throws IOException {
        String outputStr = "11," + storageGroup + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void setTTL(String storageGroup, long ttl) throws IOException {
        String outputStr = String.format(STRING_TYPE, "10", storageGroup, ttl);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void changeOffset(String path, long offset) throws IOException {
        String outputStr = String.format(STRING_TYPE, "12", path, offset);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void changeAlias(String path, String alias) throws IOException {
        String outputStr = String.format(STRING_TYPE, "13", path, alias);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public static void upgradeMLog(String schemaDir, String logFileName) throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        File tmpLogFile = SystemFileFactory.INSTANCE.getFile(logFile.getAbsolutePath() + ".tmp");
        if (!logFile.exists() && !tmpLogFile.exists()) {
            return;
        }
        if (!logFile.exists() && tmpLogFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(tmpLogFile, logFile);
            return;
        }
        if (tmpLogFile.exists()) {
            try {
                Files.delete(Paths.get(tmpLogFile.toURI()));
            }
            catch (IOException e) {
                throw new IOException("Deleting " + tmpLogFile + "failed with exception " + e.getMessage());
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(tmpLogFile, true));){
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(line);
                if (line.startsWith("0")) {
                    buf.append(",,,");
                }
                writer.write(buf.toString());
                writer.newLine();
                writer.flush();
            }
        }
    }

    public void clear() throws IOException {
        this.channel.force(true);
        this.channel.close();
        this.fileOutputStream.close();
        Files.delete(this.logFile.toPath());
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber.set(0);
    }

    public void serializeMNode(MNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(1));
        s.append(",").append(plan.getName()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void serializeMeasurementMNode(MeasurementMNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(2));
        s.append(",").append(plan.getName()).append(",");
        if (plan.getAlias() != null) {
            s.append(plan.getAlias());
        }
        IMeasurementSchema schema = plan.getSchema();
        s.append(",").append(schema.getType().ordinal()).append(",");
        s.append(schema.getEncodingType().ordinal()).append(",");
        s.append(schema.getCompressor().ordinal()).append(",");
        if (schema.getProps() != null) {
            for (Map.Entry entry : schema.getProps().entrySet()) {
                s.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
            }
        }
        s.append(",").append(plan.getOffset()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void serializeStorageGroupMNode(StorageGroupMNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(1));
        s.append(",").append(plan.getName()).append(",");
        s.append(plan.getDataTTL()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void setTemplate(SetTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf("6"));
        buf.append(",");
        buf.append(plan.getTemplateName());
        buf.append(",");
        buf.append(plan.getPrefixPath());
        buf.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void unsetTemplate(UnsetTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf("69"));
        buf.append(",");
        buf.append(plan.getTemplateName());
        buf.append(",");
        buf.append(plan.getPrefixPath());
        buf.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void dropTemplate(DropTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf("59"));
        buf.append(",");
        buf.append(plan.getName());
        buf.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void setUsingTemplate(ActivateTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf("61"));
        buf.append(",");
        buf.append(plan.getPrefixPath());
        buf.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("5");
        buf.append(",");
        buf.append(plan.getName());
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            for (int j = 0; j < plan.getMeasurements().get(i).size(); ++j) {
                String measurement;
                boolean isAligned = false;
                if (plan.getMeasurements().get(i).size() == 1) {
                    measurement = plan.getMeasurements().get(i).get(0);
                } else {
                    isAligned = true;
                    measurement = plan.getMeasurements().get(i).get(j);
                }
                buf.append(String.format(",%s,%s,%s,%s,%s", measurement, isAligned ? 1 : 0, plan.getDataTypes().get(i).get(j).serialize(), plan.getEncodings().get(i).get(j).serialize(), plan.getCompressors().get(i).get(j).serialize()));
            }
        }
        buf.append(LINE_SEPARATOR);
        this.lineNumber.incrementAndGet();
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
    }

    public void appendTemplate(AppendTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("51");
        buf.append(plan.getName());
        buf.append(plan.isAligned());
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            buf.append(String.format(",%s,%s,%s,%s", plan.getMeasurements().get(i), plan.getDataTypes().get(i).serialize(), plan.getEncodings().get(i).serialize(), plan.getCompressors().get(i).serialize()));
        }
        buf.append(LINE_SEPARATOR);
        this.lineNumber.incrementAndGet();
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
    }

    public void pruneTemplate(PruneTemplatePlan plan) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("52");
        buf.append(plan.getName());
        for (int i = 0; i < plan.getPrunedMeasurements().size(); ++i) {
            buf.append(plan.getPrunedMeasurements().get(i));
        }
        buf.append(LINE_SEPARATOR);
        this.lineNumber.incrementAndGet();
        ByteBuffer buff = ByteBuffer.wrap(buf.toString().getBytes());
        this.channel.write(buff);
    }

    public void autoCreateDeviceNode(String Device) throws IOException {
        String outputStr = "4," + Device + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    int getLineNumber() {
        return this.lineNumber.get();
    }

    void setLineNumber(int number) {
        this.lineNumber.set(number);
    }
}

