/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public abstract class AbstractCompactionWriter
implements AutoCloseable {
    protected IChunkWriter chunkWriter;
    protected boolean isAlign;
    protected String deviceId;
    private final long targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    private int measurementPointCount;

    public abstract void startChunkGroup(String var1, boolean var2) throws IOException;

    public abstract void endChunkGroup() throws IOException;

    public void startMeasurement(List<IMeasurementSchema> measurementSchemaList) {
        this.measurementPointCount = 0;
        this.chunkWriter = this.isAlign ? new AlignedChunkWriterImpl(measurementSchemaList) : new ChunkWriterImpl(measurementSchemaList.get(0), true);
    }

    public abstract void endMeasurement() throws IOException;

    public abstract void write(long var1, Object var3) throws IOException;

    public abstract void write(long[] var1, Object var2);

    public abstract void endFile() throws IOException;

    @Override
    public abstract void close() throws IOException;

    protected void writeDataPoint(Long timestamp, Object value) {
        if (!this.isAlign) {
            ChunkWriterImpl chunkWriter = (ChunkWriterImpl)this.chunkWriter;
            switch (chunkWriter.getDataType()) {
                case TEXT: {
                    chunkWriter.write(timestamp.longValue(), (Binary)value);
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(timestamp.longValue(), ((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(timestamp.longValue(), ((Boolean)value).booleanValue());
                    break;
                }
                case INT64: {
                    chunkWriter.write(timestamp.longValue(), ((Long)value).longValue());
                    break;
                }
                case INT32: {
                    chunkWriter.write(timestamp.longValue(), ((Integer)value).intValue());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(timestamp.longValue(), ((Float)value).floatValue());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown data type " + chunkWriter.getDataType());
                }
            }
        } else {
            AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriter;
            block16: for (TsPrimitiveType val : (TsPrimitiveType[])value) {
                if (val == null) {
                    chunkWriter.write(timestamp.longValue(), null, true);
                    continue;
                }
                TSDataType tsDataType = chunkWriter.getCurrentValueChunkType();
                switch (tsDataType) {
                    case TEXT: {
                        chunkWriter.write(timestamp.longValue(), val.getBinary(), false);
                        continue block16;
                    }
                    case DOUBLE: {
                        chunkWriter.write(timestamp.longValue(), val.getDouble(), false);
                        continue block16;
                    }
                    case BOOLEAN: {
                        chunkWriter.write(timestamp.longValue(), val.getBoolean(), false);
                        continue block16;
                    }
                    case INT64: {
                        chunkWriter.write(timestamp.longValue(), val.getLong(), false);
                        continue block16;
                    }
                    case INT32: {
                        chunkWriter.write(timestamp.longValue(), val.getInt(), false);
                        continue block16;
                    }
                    case FLOAT: {
                        chunkWriter.write(timestamp.longValue(), val.getFloat(), false);
                        continue block16;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown data type " + tsDataType);
                    }
                }
            }
            chunkWriter.write(timestamp.longValue());
        }
        ++this.measurementPointCount;
    }

    protected void checkChunkSizeAndMayOpenANewChunk(TsFileIOWriter fileWriter) throws IOException {
        if (this.measurementPointCount % 10 == 0 && this.checkChunkSize()) {
            this.writeRateLimit(this.chunkWriter.estimateMaxSeriesMemSize());
            this.chunkWriter.writeToFileWriter(fileWriter);
        }
    }

    private boolean checkChunkSize() {
        if (this.chunkWriter instanceof AlignedChunkWriterImpl) {
            return ((AlignedChunkWriterImpl)this.chunkWriter).checkIsChunkSizeOverThreshold(this.targetChunkSize);
        }
        return this.chunkWriter.estimateMaxSeriesMemSize() > this.targetChunkSize;
    }

    protected void writeRateLimit(long bytesLength) {
        CompactionTaskManager.mergeRateLimiterAcquire(CompactionTaskManager.getInstance().getMergeWriteRateLimiter(), bytesLength);
    }

    protected void updateDeviceStartAndEndTime(TsFileResource targetResource, long timestamp) {
        targetResource.updateStartTime(this.deviceId, timestamp);
        targetResource.updateEndTime(this.deviceId, timestamp);
    }
}

