/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.querycontext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.reader.chunk.MemAlignedChunkLoader;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedReadOnlyMemChunk
extends ReadOnlyMemChunk {
    private final List<List<TimeRange>> deletionList;
    private String measurementUid;
    private TSDataType dataType;
    private List<TSEncoding> encodingList;
    private static final Logger logger = LoggerFactory.getLogger(AlignedReadOnlyMemChunk.class);
    private int floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
    private AlignedTVList chunkData;
    private int chunkDataSize;

    public AlignedReadOnlyMemChunk(IMeasurementSchema schema, TVList tvList, int size, List<List<TimeRange>> deletionList) throws IOException, QueryProcessException {
        this.measurementUid = schema.getMeasurementId();
        this.dataType = schema.getType();
        this.encodingList = ((VectorMeasurementSchema)schema).getSubMeasurementsTSEncodingList();
        this.chunkData = (AlignedTVList)tvList;
        this.chunkDataSize = size;
        this.deletionList = deletionList;
        this.chunkPointReader = this.chunkData.getAlignedIterator(this.floatPrecision, this.encodingList, this.chunkDataSize, deletionList);
        this.initAlignedChunkMeta((VectorMeasurementSchema)schema);
    }

    private void initAlignedChunkMeta(VectorMeasurementSchema schema) throws IOException, QueryProcessException {
        AlignedTVList alignedChunkData = this.chunkData;
        List measurementList = schema.getSubMeasurementsList();
        List dataTypeList = schema.getSubMeasurementsTSDataTypeList();
        Statistics timeStatistics = Statistics.getStatsByType((TSDataType)TSDataType.VECTOR);
        ChunkMetadata timeChunkMetadata = new ChunkMetadata(this.measurementUid, TSDataType.VECTOR, 0L, timeStatistics);
        ArrayList<ChunkMetadata> valueChunkMetadataList = new ArrayList<ChunkMetadata>();
        for (int row = 0; row < alignedChunkData.rowCount(); ++row) {
            timeStatistics.update(alignedChunkData.getTime(row));
        }
        timeStatistics.setEmpty(false);
        for (int column = 0; column < measurementList.size(); ++column) {
            Statistics valueStatistics = Statistics.getStatsByType((TSDataType)((TSDataType)dataTypeList.get(column)));
            ChunkMetadata valueChunkMetadata = new ChunkMetadata((String)measurementList.get(column), (TSDataType)dataTypeList.get(column), 0L, valueStatistics);
            valueChunkMetadataList.add(valueChunkMetadata);
            if (alignedChunkData.getValues().get(column) == null) {
                valueStatistics.setEmpty(true);
                continue;
            }
            block10: for (int row = 0; row < alignedChunkData.rowCount(); ++row) {
                long time = alignedChunkData.getTime(row);
                int originRowIndex = alignedChunkData.getValueIndex(row);
                boolean isNull = alignedChunkData.isValueMarked(originRowIndex, column);
                if (isNull) continue;
                switch ((TSDataType)dataTypeList.get(column)) {
                    case BOOLEAN: {
                        valueStatistics.update(time, alignedChunkData.getBooleanByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    case TEXT: {
                        valueStatistics.update(time, alignedChunkData.getBinaryByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    case FLOAT: {
                        valueStatistics.update(time, alignedChunkData.getFloatByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    case INT32: {
                        valueStatistics.update(time, alignedChunkData.getIntByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    case INT64: {
                        valueStatistics.update(time, alignedChunkData.getLongByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    case DOUBLE: {
                        valueStatistics.update(time, alignedChunkData.getDoubleByValueIndex(originRowIndex, column));
                        continue block10;
                    }
                    default: {
                        throw new QueryProcessException("Unsupported data type:" + this.dataType);
                    }
                }
            }
            valueStatistics.setEmpty(false);
        }
        AlignedChunkMetadata vectorChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadata, valueChunkMetadataList);
        vectorChunkMetadata.setChunkLoader((IChunkLoader)new MemAlignedChunkLoader(this));
        vectorChunkMetadata.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = vectorChunkMetadata;
    }

    @Override
    public IPointReader getPointReader() {
        this.chunkPointReader = this.chunkData.getAlignedIterator(this.floatPrecision, this.encodingList, this.chunkDataSize, this.deletionList);
        return this.chunkPointReader;
    }
}

