/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.ClusterQueryRouter;
import org.apache.iotdb.cluster.query.filter.SlotSgFilter;
import org.apache.iotdb.cluster.query.manage.QueryCoordinator;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPlanExecutor
extends PlanExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPlanExecutor.class);
    private final MetaGroupMember metaGroupMember;
    public static final int THREAD_POOL_SIZE = 6;
    public static final String LOG_FAIL_CONNECT = "Failed to connect to node: {}";

    public ClusterPlanExecutor(MetaGroupMember metaGroupMember) throws QueryProcessException {
        this.metaGroupMember = metaGroupMember;
        this.queryRouter = new ClusterQueryRouter(metaGroupMember);
    }

    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException, MetadataException, InterruptedException {
        if (queryPlan instanceof QueryPlan) {
            logger.debug("Executing a query: {}", (Object)queryPlan);
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof ShowPlan) {
            try {
                this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
            }
            catch (CheckConsistencyException e) {
                throw new QueryProcessException(e.getMessage());
            }
            return this.processShowQuery((ShowPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            try {
                this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
            }
            catch (CheckConsistencyException e) {
                throw new QueryProcessException(e.getMessage());
            }
            return this.processAuthorQuery((AuthorPlan)queryPlan);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    protected List<MeasurementPath> getPathsName(PartialPath path) throws MetadataException {
        return ((CMManager)IoTDB.metaManager).getMatchedPaths(path);
    }

    protected int getDevicesNum(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return this.getDevicesNum(path) + (isPrefixMatch ? this.getDevicesNum(path.concatNode("**")) : 0);
    }

    protected int getDevicesNum(PartialPath path) throws MetadataException {
        int ret;
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new MetadataException((Throwable)e);
        }
        Map sgPathMap = IoTDB.metaManager.groupPathByStorageGroup(path);
        if (sgPathMap.isEmpty()) {
            throw new PathNotExistException(path.getFullPath());
        }
        logger.debug("The storage groups of path {} are {}", (Object)path, sgPathMap.keySet());
        try {
            ret = this.getDeviceCount(sgPathMap, path);
        }
        catch (CheckConsistencyException e) {
            throw new MetadataException((Throwable)e);
        }
        logger.debug("The number of devices satisfying {} is {}", (Object)path, (Object)ret);
        return ret;
    }

    private int getDeviceCount(Map<String, List<PartialPath>> sgPathMap, PartialPath queryPath) throws CheckConsistencyException, MetadataException {
        AtomicInteger result = new AtomicInteger();
        HashMap<PartitionGroup, List> groupPathMap = new HashMap<PartitionGroup, List>();
        for (String storageGroupName : sgPathMap.keySet()) {
            PartialPath targetPath;
            PartialPath pathUnderSG = new PartialPath(storageGroupName);
            PartitionGroup partitionGroup = this.metaGroupMember.getPartitionTable().route(storageGroupName, 0L);
            if (pathUnderSG.getNodeLength() >= queryPath.getNodeLength()) {
                targetPath = pathUnderSG;
            } else {
                String[] targetNodes = new String[queryPath.getNodeLength()];
                for (int i = 0; i < queryPath.getNodeLength(); ++i) {
                    targetNodes[i] = i < pathUnderSG.getNodeLength() ? pathUnderSG.getNodes()[i] : queryPath.getNodes()[i];
                }
                targetPath = new PartialPath(targetNodes);
            }
            if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), partitionGroup.getRaftId()).syncLeaderWithConsistencyCheck(false);
                int localResult = this.getLocalDeviceCount(targetPath);
                logger.debug("{}: get device count of {} locally, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, localResult});
                result.addAndGet(localResult);
                continue;
            }
            groupPathMap.computeIfAbsent(partitionGroup, p -> new ArrayList()).add(targetPath.getFullPath());
        }
        if (groupPathMap.isEmpty()) {
            return result.get();
        }
        ExecutorService remoteQueryThreadPool = Executors.newFixedThreadPool(groupPathMap.size());
        ArrayList<Future<Void>> remoteFutures = new ArrayList<Future<Void>>();
        for (Map.Entry partitionGroupPathEntry : groupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)partitionGroupPathEntry.getKey();
            List pathsToQuery = (List)partitionGroupPathEntry.getValue();
            remoteFutures.add(remoteQueryThreadPool.submit(() -> {
                try {
                    result.addAndGet(this.getRemoteDeviceCount(partitionGroup, pathsToQuery));
                }
                catch (MetadataException e) {
                    logger.warn("Cannot get remote device count of {} from {}", new Object[]{pathsToQuery, partitionGroup, e});
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(remoteFutures, remoteQueryThreadPool, "getDeviceCount()");
        return result.get();
    }

    private int getLocalDeviceCount(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevicesNum(path);
    }

    private int getRemoteDeviceCount(PartitionGroup partitionGroup, List<String> pathsToCount) throws MetadataException {
        List<Node> coordinatedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : coordinatedNodes) {
            try {
                Integer count = this.getRemoteDeviceCountForOneNode(node, partitionGroup, pathsToCount);
                logger.debug("{}: get device count of {} from {}, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, node, count});
                if (count == null) continue;
                return count;
            }
            catch (IOException | TException e) {
                throw new MetadataException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MetadataException((Throwable)e);
            }
        }
        logger.warn("Cannot get devices of {} from {}", pathsToCount, (Object)partitionGroup);
        return 0;
    }

    private Integer getRemoteDeviceCountForOneNode(Node node, PartitionGroup partitionGroup, List<String> pathsToCount) throws IOException, TException, InterruptedException {
        Integer count;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            client.setTimeout(ClusterConstant.getReadOperationTimeoutMS());
            count = SyncClientAdaptor.getDeviceCount(client, partitionGroup.getHeader(), pathsToCount);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                syncDataClient.setTimeout(ClusterConstant.getReadOperationTimeoutMS());
                count = syncDataClient.getDeviceCount(partitionGroup.getHeader(), pathsToCount);
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return count;
    }

    protected int getPathsNum(PartialPath path, boolean isPrefixMatch) throws MetadataException {
        return this.getNodesNumInGivenLevel(path, -1, isPrefixMatch);
    }

    protected int getNodesNumInGivenLevel(PartialPath path, int level, boolean isPrefixMatch) throws MetadataException {
        int result = this.getNodesNumInGivenLevel(path, level);
        if (isPrefixMatch) {
            result += this.getNodesNumInGivenLevel(path.concatNode("**"), level);
        }
        return result;
    }

    protected int getNodesNumInGivenLevel(PartialPath path, int level) throws MetadataException {
        Map sgPathMap;
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new MetadataException((Throwable)e);
        }
        PartialPath wildcardPath = path;
        if (!wildcardPath.getMeasurement().equals("**")) {
            wildcardPath = wildcardPath.concatNode("**");
        }
        if ((sgPathMap = IoTDB.metaManager.groupPathByStorageGroup(wildcardPath)).isEmpty()) {
            return 0;
        }
        logger.debug("The storage groups of path {} are {}", (Object)path, sgPathMap.keySet());
        int ret = 0;
        try {
            if (level >= 0) {
                String currentPart;
                int prefixPartIdx;
                for (prefixPartIdx = 0; prefixPartIdx < path.getNodeLength() && !(currentPart = path.getNodes()[prefixPartIdx]).equals("**"); ++prefixPartIdx) {
                    if (!currentPart.equals("*")) continue;
                    if (level == prefixPartIdx) break;
                    return 0;
                }
                if (level < prefixPartIdx - 1) {
                    return 0;
                }
                HashSet<String> deletedSg = new HashSet<String>();
                HashSet<PartialPath> matchedPath = new HashSet<PartialPath>(0);
                for (String sg : sgPathMap.keySet()) {
                    PartialPath p = new PartialPath(sg);
                    if (p.getNodeLength() - 1 < level) continue;
                    deletedSg.add(sg);
                    matchedPath.add(new PartialPath(Arrays.copyOfRange(p.getNodes(), 0, level + 1)));
                }
                for (String sg : deletedSg) {
                    sgPathMap.remove(sg);
                }
                ret += matchedPath.size();
            }
        }
        catch (CheckConsistencyException e) {
            throw new MetadataException((Throwable)e);
        }
        logger.debug("The number of paths satisfying {}@{} is {}", new Object[]{path, level, ret += this.getPathCount(sgPathMap, level)});
        return ret;
    }

    private int getPathCount(Map<String, List<PartialPath>> sgPathMap, int level) throws MetadataException, CheckConsistencyException {
        PartitionGroup partitionGroup;
        AtomicInteger result = new AtomicInteger();
        HashMap<PartitionGroup, List> groupPathMap = new HashMap<PartitionGroup, List>();
        for (Map.Entry<String, List<PartialPath>> sgPathEntry : sgPathMap.entrySet()) {
            String storageGroupName = sgPathEntry.getKey();
            List<PartialPath> paths = sgPathEntry.getValue();
            partitionGroup = this.metaGroupMember.getPartitionTable().route(storageGroupName, 0L);
            if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), partitionGroup.getRaftId()).syncLeaderWithConsistencyCheck(false);
                int localResult = 0;
                for (PartialPath path : paths) {
                    localResult += this.getLocalPathCount(path, level);
                }
                logger.debug("{}: get path count of {} locally, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, localResult});
                result.addAndGet(localResult);
                continue;
            }
            for (PartialPath path : paths) {
                groupPathMap.computeIfAbsent(partitionGroup, p -> new ArrayList()).add(path.getFullPath());
            }
        }
        if (groupPathMap.isEmpty()) {
            return result.get();
        }
        ExecutorService remoteQueryThreadPool = Executors.newFixedThreadPool(groupPathMap.size());
        ArrayList<Future<Void>> remoteFutures = new ArrayList<Future<Void>>();
        for (Map.Entry partitionGroupPathEntry : groupPathMap.entrySet()) {
            partitionGroup = (PartitionGroup)partitionGroupPathEntry.getKey();
            List pathsToQuery = (List)partitionGroupPathEntry.getValue();
            remoteFutures.add(remoteQueryThreadPool.submit(() -> {
                try {
                    result.addAndGet(this.getRemotePathCount(partitionGroup, pathsToQuery, level));
                }
                catch (MetadataException e) {
                    logger.warn("Cannot get remote path count of {} from {}", new Object[]{pathsToQuery, partitionGroup, e});
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(remoteFutures, remoteQueryThreadPool, "getPathCount()");
        return result.get();
    }

    private int getLocalPathCount(PartialPath path, int level) throws MetadataException {
        int localResult = level == -1 ? IoTDB.metaManager.getAllTimeseriesCount(path) : IoTDB.metaManager.getNodesCountInGivenLevel(path, level);
        return localResult;
    }

    private int getRemotePathCount(PartitionGroup partitionGroup, List<String> pathsToQuery, int level) throws MetadataException {
        List<Node> coordinatedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : coordinatedNodes) {
            try {
                Integer count = this.getRemotePathCountForOneNode(node, partitionGroup, pathsToQuery, level);
                logger.debug("{}: get path count of {} from {}, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, node, count});
                if (count == null) continue;
                return count;
            }
            catch (IOException | TException e) {
                throw new MetadataException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MetadataException((Throwable)e);
            }
        }
        logger.warn("Cannot get paths of {} from {}", pathsToQuery, (Object)partitionGroup);
        return 0;
    }

    private Integer getRemotePathCountForOneNode(Node node, PartitionGroup partitionGroup, List<String> pathsToQuery, int level) throws IOException, TException, InterruptedException {
        Integer count;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            client.setTimeout(ClusterConstant.getReadOperationTimeoutMS());
            count = SyncClientAdaptor.getPathCount(client, partitionGroup.getHeader(), pathsToQuery, level);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                syncDataClient.setTimeout(ClusterConstant.getReadOperationTimeoutMS());
                count = syncDataClient.getPathCount(partitionGroup.getHeader(), pathsToQuery, level);
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return count;
    }

    protected List<PartialPath> getNodesList(PartialPath schemaPattern, int level) throws MetadataException {
        ConcurrentSkipListSet nodeSet = new ConcurrentSkipListSet();
        ExecutorService pool = Executors.newFixedThreadPool(6);
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (PartitionGroup group : this.metaGroupMember.getPartitionTable().getGlobalGroups()) {
            futureList.add(pool.submit(() -> {
                List<PartialPath> paths = this.getNodesList(group, schemaPattern, level);
                if (paths != null) {
                    nodeSet.addAll(paths);
                } else {
                    logger.error("Fail to get node list of {}@{} from {}", new Object[]{schemaPattern, level, group});
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(futureList, pool, "getNodesList()");
        return new ArrayList<PartialPath>(nodeSet);
    }

    private List<PartialPath> getNodesList(PartitionGroup group, PartialPath schemaPattern, int level) throws CheckConsistencyException, MetadataException {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            return this.getLocalNodesList(group, schemaPattern, level);
        }
        return this.getRemoteNodesList(group, schemaPattern, level);
    }

    private List<PartialPath> getLocalNodesList(PartitionGroup group, PartialPath schemaPattern, int level) throws CheckConsistencyException, MetadataException {
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(group.getHeader());
        localDataMember.syncLeaderWithConsistencyCheck(false);
        try {
            return IoTDB.metaManager.getNodesListInGivenLevel(schemaPattern, level, (MManager.StorageGroupFilter)new SlotSgFilter(((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).getNodeSlots(group.getHeader())));
        }
        catch (MetadataException e) {
            logger.error("Cannot not get node list of {}@{} from {} locally", new Object[]{schemaPattern, level, group});
            throw e;
        }
    }

    private List<PartialPath> getRemoteNodesList(PartitionGroup group, PartialPath schemaPattern, int level) {
        List<String> paths = null;
        for (Node node : group) {
            try {
                paths = this.getRemoteNodesListForOneNode(node, group, schemaPattern, level);
                if (paths == null) continue;
                break;
            }
            catch (IOException e) {
                logger.error(LOG_FAIL_CONNECT, (Object)node, (Object)e);
            }
            catch (TException e) {
                logger.error("Error occurs when getting node lists in node {}.", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted when getting node lists in node {}.", (Object)node, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        return PartialPath.fromStringList(paths);
    }

    private List<String> getRemoteNodesListForOneNode(Node node, PartitionGroup group, PartialPath schemaPattern, int level) throws TException, InterruptedException, IOException {
        List paths;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            paths = SyncClientAdaptor.getNodeList(client, group.getHeader(), schemaPattern.getFullPath(), level);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                paths = syncDataClient.getNodeList(group.getHeader(), schemaPattern.getFullPath(), level);
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return paths;
    }

    protected Set<String> getNodeNextChildren(PartialPath path) throws MetadataException {
        ConcurrentSkipListSet<String> resultSet = new ConcurrentSkipListSet<String>();
        List<PartitionGroup> globalGroups = this.metaGroupMember.getPartitionTable().getGlobalGroups();
        ExecutorService pool = Executors.newFixedThreadPool(6);
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (PartitionGroup group : globalGroups) {
            futureList.add(pool.submit(() -> {
                Set<String> nextChildrenNodes = null;
                try {
                    nextChildrenNodes = this.getChildNodeInNextLevel(group, path);
                }
                catch (CheckConsistencyException e) {
                    logger.error("Fail to get next children nodes of {} from {}", new Object[]{path, group, e});
                }
                if (nextChildrenNodes != null) {
                    resultSet.addAll(nextChildrenNodes);
                } else {
                    logger.error("Fail to get next children nodes of {} from {}", (Object)path, (Object)group);
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(futureList, pool, "getChildNodeInNextLevel()");
        return resultSet;
    }

    private Set<String> getChildNodeInNextLevel(PartitionGroup group, PartialPath path) throws CheckConsistencyException {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            return this.getLocalChildNodeInNextLevel(group, path);
        }
        return this.getRemoteChildNodeInNextLevel(group, path);
    }

    private Set<String> getLocalChildNodeInNextLevel(PartitionGroup group, PartialPath path) throws CheckConsistencyException {
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(group.getHeader(), group.getRaftId());
        localDataMember.syncLeaderWithConsistencyCheck(false);
        try {
            return IoTDB.metaManager.getChildNodeNameInNextLevel(path);
        }
        catch (MetadataException e) {
            logger.error("Cannot not get next children nodes of {} from {} locally", (Object)path, (Object)group);
            return Collections.emptySet();
        }
    }

    private Set<String> getRemoteChildNodeInNextLevel(PartitionGroup group, PartialPath path) {
        Set<String> nextChildrenNodes = null;
        for (Node node : group) {
            try {
                nextChildrenNodes = this.getRemoteChildNodeInNextLevelForOneNode(node, group, path);
                if (nextChildrenNodes == null) continue;
                break;
            }
            catch (IOException e) {
                logger.error(LOG_FAIL_CONNECT, (Object)node, (Object)e);
            }
            catch (TException e) {
                logger.error("Error occurs when getting node lists in node {}.", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted when getting node lists in node {}.", (Object)node, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        return nextChildrenNodes;
    }

    private Set<String> getRemoteChildNodeInNextLevelForOneNode(Node node, PartitionGroup group, PartialPath path) throws TException, InterruptedException, IOException {
        Set nextChildrenNodes;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            nextChildrenNodes = SyncClientAdaptor.getChildNodeInNextLevel(client, group.getHeader(), path.getFullPath());
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                nextChildrenNodes = syncDataClient.getChildNodeInNextLevel(group.getHeader(), path.getFullPath());
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return nextChildrenNodes;
    }

    protected Set<String> getPathNextChildren(PartialPath path) throws MetadataException {
        ConcurrentSkipListSet<String> resultSet = new ConcurrentSkipListSet<String>();
        ExecutorService pool = Executors.newFixedThreadPool(6);
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (PartitionGroup group : this.metaGroupMember.getPartitionTable().getGlobalGroups()) {
            futureList.add(pool.submit(() -> {
                Set<String> nextChildren = null;
                try {
                    nextChildren = this.getNextChildren(group, path);
                }
                catch (CheckConsistencyException e) {
                    logger.error("Fail to get next children of {} from {}", new Object[]{path, group, e});
                }
                if (nextChildren != null) {
                    resultSet.addAll(nextChildren);
                } else {
                    logger.error("Fail to get next children of {} from {}", (Object)path, (Object)group);
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(futureList, pool, "getPathNextChildren()");
        return resultSet;
    }

    public static void waitForThreadPool(List<Future<Void>> futures, ExecutorService pool, String methodName) throws MetadataException {
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption when waiting for {}", (Object)methodName, (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException | ExecutionException e) {
                throw new MetadataException((Throwable)e);
            }
        }
        pool.shutdown();
        try {
            pool.awaitTermination(ClusterConstant.getReadOperationTimeoutMS(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for {}", (Object)methodName, (Object)e);
        }
    }

    private Set<String> getNextChildren(PartitionGroup group, PartialPath path) throws CheckConsistencyException {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            return this.getLocalNextChildren(group, path);
        }
        return this.getRemoteNextChildren(group, path);
    }

    private Set<String> getLocalNextChildren(PartitionGroup group, PartialPath path) throws CheckConsistencyException {
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(group.getHeader());
        localDataMember.syncLeaderWithConsistencyCheck(false);
        try {
            return IoTDB.metaManager.getChildNodePathInNextLevel(path);
        }
        catch (MetadataException e) {
            logger.error("Cannot not get next children of {} from {} locally", (Object)path, (Object)group);
            return Collections.emptySet();
        }
    }

    private Set<String> getRemoteNextChildren(PartitionGroup group, PartialPath path) {
        Set<String> nextChildren = null;
        for (Node node : group) {
            try {
                nextChildren = this.getRemoteNextChildrenForOneNode(node, group, path);
                if (nextChildren == null) continue;
                break;
            }
            catch (IOException e) {
                logger.error(LOG_FAIL_CONNECT, (Object)node, (Object)e);
            }
            catch (TException e) {
                logger.error("Error occurs when getting node lists in node {}.", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted when getting node lists in node {}.", (Object)node, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        return nextChildren;
    }

    private Set<String> getRemoteNextChildrenForOneNode(Node node, PartitionGroup group, PartialPath path) throws TException, InterruptedException, IOException {
        Set nextChildren;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            nextChildren = SyncClientAdaptor.getNextChildren(client, group.getHeader(), path.getFullPath());
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                nextChildren = syncDataClient.getChildNodePathInNextLevel(group.getHeader(), path.getFullPath());
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return nextChildren;
    }

    protected List<IStorageGroupMNode> getAllStorageGroupNodes() {
        try {
            this.metaGroupMember.syncLeader(null);
        }
        catch (CheckConsistencyException e) {
            logger.warn("Failed to check consistency.", (Throwable)e);
        }
        return IoTDB.metaManager.getAllStorageGroupNodes();
    }

    protected void loadConfiguration(LoadConfigurationPlan plan) throws QueryProcessException {
        switch (plan.getLoadConfigurationPlanType()) {
            case GLOBAL: {
                IoTDBDescriptor.getInstance().loadHotModifiedProps(plan.getIoTDBProperties());
                ClusterDescriptor.getInstance().loadHotModifiedProps(plan.getClusterProperties());
                break;
            }
            case LOCAL: {
                IoTDBDescriptor.getInstance().loadHotModifiedProps();
                ClusterDescriptor.getInstance().loadHotModifiedProps();
                break;
            }
            default: {
                throw new QueryProcessException(String.format("Unrecognized load configuration plan type: %s", plan.getLoadConfigurationPlanType()));
            }
        }
    }

    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        if (deletePlan.getPaths().isEmpty()) {
            logger.info("TimeSeries list to be deleted is empty.");
            return;
        }
        for (PartialPath path : deletePlan.getPaths()) {
            this.delete(path, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime(), deletePlan.getIndex(), deletePlan.getPartitionFilter());
        }
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex, VirtualStorageGroupProcessor.TimePartitionFilter timePartitionFilter) throws QueryProcessException {
        try {
            StorageEngine.getInstance().delete(path, startTime, endTime, planIndex, timePartitionFilter);
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }
}

