/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.utils.Pair;

public class RawDataQueryPlan
extends QueryPlan {
    private List<PartialPath> deduplicatedPaths = new ArrayList<PartialPath>();
    private IExpression expression = null;
    private Map<String, Set<String>> deviceToMeasurements = new HashMap<String, Set<String>>();
    private List<PartialPath> deduplicatedVectorPaths = new ArrayList<PartialPath>();

    @Override
    public void deduplicate(PhysicalGenerator physicalGenerator) throws MetadataException {
        ArrayList<Pair> indexedPaths = new ArrayList<Pair>();
        for (int i = 0; i < this.paths.size(); ++i) {
            indexedPaths.add(new Pair((Object)((PartialPath)this.paths.get(i)), (Object)i));
        }
        indexedPaths.sort(Comparator.comparing(pair -> (PartialPath)pair.left));
        HashSet<String> columnForReaderSet = new HashSet<String>();
        HashSet<String> columnForDisplaySet = new HashSet<String>();
        for (Pair indexedPath : indexedPaths) {
            String columnForDisplay;
            PartialPath originalPath = (PartialPath)indexedPath.left;
            Integer originalIndex = (Integer)indexedPath.right;
            String columnForReader = this.getColumnForReaderFromPath(originalPath, originalIndex);
            if (!columnForReaderSet.contains(columnForReader)) {
                this.addDeduplicatedPaths(originalPath);
                if (this instanceof AggregationPlan) {
                    ((AggregationPlan)this).addDeduplicatedAggregations(this.getAggregations().get(originalIndex));
                }
                columnForReaderSet.add(columnForReader);
            }
            if (columnForDisplaySet.contains(columnForDisplay = this.getColumnForDisplay(columnForReader, originalIndex))) continue;
            this.setColumnNameToDatasetOutputIndex(columnForDisplay, this.getPathToIndex().size());
            columnForDisplaySet.add(columnForDisplay);
        }
        this.groupVectorPaths(physicalGenerator);
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression expression) throws QueryProcessException {
        this.expression = expression;
        this.updateDeviceMeasurementsUsingExpression(expression);
    }

    public void updateDeviceMeasurementsUsingExpression(IExpression expression) {
        if (expression instanceof SingleSeriesExpression) {
            Path path = ((SingleSeriesExpression)expression).getSeriesPath();
            this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        } else if (expression instanceof IBinaryExpression) {
            this.updateDeviceMeasurementsUsingExpression(((IBinaryExpression)expression).getLeft());
            this.updateDeviceMeasurementsUsingExpression(((IBinaryExpression)expression).getRight());
        }
    }

    public List<PartialPath> getDeduplicatedPaths() {
        return this.deduplicatedPaths;
    }

    public void addDeduplicatedPaths(PartialPath path) {
        this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        this.deduplicatedPaths.add(path);
    }

    public List<TSDataType> getDeduplicatedDataTypes() {
        return SchemaUtils.getSeriesTypesByPaths(this.deduplicatedPaths);
    }

    public void setDeduplicatedPathsAndUpdate(List<PartialPath> deduplicatedPaths) {
        this.deviceToMeasurements.clear();
        deduplicatedPaths.forEach(path -> {
            Set set = this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet());
            if (path instanceof AlignedPath) {
                set.addAll(((AlignedPath)path).getMeasurementList());
            } else {
                set.add(path.getMeasurement());
            }
        });
        this.deduplicatedPaths = deduplicatedPaths;
    }

    public void setDeduplicatedPaths(List<PartialPath> deduplicatedPaths) {
        this.deduplicatedPaths = deduplicatedPaths;
    }

    public Set<String> getAllMeasurementsInDevice(String device) {
        return this.deviceToMeasurements.getOrDefault(device, new HashSet());
    }

    public void addFilterPathInDeviceToMeasurements(Path path) {
        this.deviceToMeasurements.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
    }

    public Map<String, Set<String>> getDeviceToMeasurements() {
        return this.deviceToMeasurements;
    }

    public void groupVectorPaths(PhysicalGenerator physicalGenerator) throws MetadataException {
        List<PartialPath> vectorizedDeduplicatedPaths = physicalGenerator.groupVectorPaths(this.getDeduplicatedPaths());
        this.setDeduplicatedVectorPaths(vectorizedDeduplicatedPaths);
    }

    public void setDeduplicatedVectorPaths(List<PartialPath> deduplicatedVectorPaths) {
        this.deduplicatedVectorPaths = deduplicatedVectorPaths;
    }

    public void transformToVector() {
        if (!this.deduplicatedVectorPaths.isEmpty()) {
            this.deduplicatedPaths = this.deduplicatedVectorPaths;
        }
    }
}

