/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionSelector
extends AbstractInnerSpaceCompactionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public SizeTieredCompactionSelector(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, boolean sequence, InnerSpaceCompactionTaskFactory taskFactory) {
        super(logicalStorageGroupName, virtualStorageGroupName, timePartition, tsFileManager, sequence, taskFactory);
    }

    @Override
    public void selectAndSubmit() {
        PriorityQueue<Pair<List<TsFileResource>, Long>> taskPriorityQueue = new PriorityQueue<Pair<List<TsFileResource>, Long>>(new SizeTieredCompactionTaskComparator());
        try {
            int maxLevel = this.searchMaxFileLevel();
            for (int currentLevel = 0; currentLevel <= maxLevel && this.selectLevelTask(currentLevel, taskPriorityQueue); ++currentLevel) {
            }
            while (taskPriorityQueue.size() > 0) {
                this.createAndSubmitTask((List)taskPriorityQueue.poll().left);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs while selecting files", (Throwable)e);
        }
    }

    private boolean selectLevelTask(int level, PriorityQueue<Pair<List<TsFileResource>, Long>> taskPriorityQueue) throws IOException {
        boolean shouldContinueToSearch = true;
        ArrayList<TsFileResource> selectedFileList = new ArrayList<TsFileResource>();
        long selectedFileSize = 0L;
        long targetCompactionFileSize = config.getTargetCompactionFileSize();
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() != level || currentFile.isCompactionCandidate()) {
                selectedFileList.clear();
                selectedFileSize = 0L;
                continue;
            }
            LOGGER.debug("Current File is {}, size is {}", (Object)currentFile, (Object)currentFile.getTsFileSize());
            selectedFileList.add(currentFile);
            LOGGER.debug("Add tsfile {}, current select file num is {}, size is {}", new Object[]{currentFile, selectedFileList.size(), selectedFileSize += currentFile.getTsFileSize()});
            if (selectedFileSize < targetCompactionFileSize && selectedFileList.size() < config.getMaxInnerCompactionCandidateFileNum()) continue;
            if (selectedFileList.size() > 1) {
                taskPriorityQueue.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
            }
            selectedFileList = new ArrayList();
            selectedFileSize = 0L;
            shouldContinueToSearch = false;
        }
        return shouldContinueToSearch;
    }

    private int searchMaxFileLevel() throws IOException {
        int maxLevel = -1;
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() <= maxLevel) continue;
            maxLevel = currentName.getInnerCompactionCnt();
        }
        return maxLevel;
    }

    private boolean createAndSubmitTask(List<TsFileResource> selectedFileList) throws InterruptedException {
        AbstractCompactionTask compactionTask = this.taskFactory.createTask(this.logicalStorageGroupName, this.virtualStorageGroupName, this.timePartition, this.tsFileManager, selectedFileList, this.sequence);
        return CompactionTaskManager.getInstance().addTaskToWaitingQueue(compactionTask);
    }

    private class SizeTieredCompactionTaskComparator
    implements Comparator<Pair<List<TsFileResource>, Long>> {
        private SizeTieredCompactionTaskComparator() {
        }

        @Override
        public int compare(Pair<List<TsFileResource>, Long> o1, Pair<List<TsFileResource>, Long> o2) {
            TsFileResource resourceOfO1 = (TsFileResource)((List)o1.left).get(0);
            TsFileResource resourceOfO2 = (TsFileResource)((List)o2.left).get(0);
            try {
                TsFileNameGenerator.TsFileName fileNameOfO1 = TsFileNameGenerator.getTsFileName(resourceOfO1.getTsFile().getName());
                TsFileNameGenerator.TsFileName fileNameOfO2 = TsFileNameGenerator.getTsFileName(resourceOfO2.getTsFile().getName());
                if (fileNameOfO1.getInnerCompactionCnt() != fileNameOfO2.getInnerCompactionCnt()) {
                    return fileNameOfO2.getInnerCompactionCnt() - fileNameOfO1.getInnerCompactionCnt();
                }
                return (int)(fileNameOfO2.getVersion() - fileNameOfO1.getVersion());
            }
            catch (IOException e) {
                return 0;
            }
        }
    }
}

