/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class IntTVList
extends TVList {
    private List<int[]> values = new ArrayList<int[]>();
    private int[][] sortedValues;
    private int pivotValue;

    IntTVList() {
    }

    @Override
    public void putInt(long timestamp, int value) {
        this.checkExpansion();
        int arrayIndex = this.size / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.size % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.size;
        if (this.sorted && this.size > 1 && timestamp < this.getTime(this.size - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public int getInt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, int value) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public IntTVList clone() {
        IntTVList cloneList = new IntTVList();
        this.cloneAs(cloneList);
        for (int[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private int[] cloneValue(int[] array) {
        int[] cloneArray = new int[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.size)) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.size);
        }
        if (this.sortedValues == null || this.sortedValues.length < PrimitiveArrayManager.getArrayRowCount(this.size)) {
            this.sortedValues = (int[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT32, this.size);
        }
        this.sort(0, this.size);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (int[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedValues[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        int srcV = this.getInt(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedValues[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getInt(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            int loV = this.getInt(lo);
            long hiT = this.getTime(hi);
            int hiV = this.getInt(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getInt(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)this.getInt(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)this.getInt(index)));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putInts(long[] time, int[] value, int start, int end) {
        this.checkExpansion();
        int idx = start;
        this.updateMinTimeAndSorted(time, start, end);
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.size / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.size % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.size += inputRemaining;
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.size += internalRemaining;
            this.checkExpansion();
        }
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.INT32;
    }
}

