/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure.tv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.db.query.udf.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableIntTVList
extends SerializableTVList {
    protected static int calculateCapacity(float memoryLimitInMB) {
        float memoryLimitInB = memoryLimitInMB * 1048576.0f / 2.0f;
        return 1000 * (int)(memoryLimitInB / 12000.0f);
    }

    protected SerializableIntTVList(SerializableList.SerializationRecorder serializationRecorder) {
        super(TSDataType.INT32, serializationRecorder);
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int size = this.length();
        this.serializationRecorder.setSerializedElementSize(size);
        int serializedByteLength = 0;
        for (int i = 0; i < size; ++i) {
            serializedByteLength += ReadWriteIOUtils.write((long)this.getTimeByIndex(i), (OutputStream)outputStream);
            serializedByteLength += ReadWriteIOUtils.write((int)this.getIntByIndex(i), (OutputStream)outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        for (int i = 0; i < serializedElementSize; ++i) {
            this.putInt(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public void release() {
        this.timeRet = null;
        this.intRet = null;
    }
}

