/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByWithValueFilterDataSet
extends GroupByEngineDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByWithValueFilterDataSet.class);
    private List<IReaderByTimestamp> allDataReaderList;
    private GroupByTimePlan groupByTimePlan;
    private TimeGenerator timestampGenerator;
    private LinkedList<Long> cachedTimestamps = new LinkedList();
    protected int timeStampFetchSize;
    private long lastTimestamp;

    protected GroupByWithValueFilterDataSet() {
    }

    public GroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) throws StorageEngineException, QueryProcessException {
        super(context, groupByTimePlan);
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
        this.initGroupBy(context, groupByTimePlan);
    }

    public GroupByWithValueFilterDataSet(long queryId, GroupByTimePlan groupByTimePlan) {
        super(new QueryContext(queryId), groupByTimePlan);
        this.allDataReaderList = new ArrayList<IReaderByTimestamp>();
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
    }

    protected void initGroupBy(QueryContext context, GroupByTimePlan groupByTimePlan) throws StorageEngineException, QueryProcessException {
        this.timestampGenerator = this.getTimeGenerator(context, groupByTimePlan);
        this.allDataReaderList = new ArrayList<IReaderByTimestamp>();
        this.groupByTimePlan = groupByTimePlan;
        AndFilter timeFilter = FilterFactory.and((Filter)TimeFilter.gtEq((long)groupByTimePlan.getStartTime()), (Filter)TimeFilter.lt((long)groupByTimePlan.getEndTime()));
        Pair<List<StorageGroupProcessor>, Map<StorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(this.paths.stream().map(p -> (PartialPath)p).collect(Collectors.toList()));
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, (Filter)timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (int i = 0; i < this.paths.size(); ++i) {
            PartialPath path = (PartialPath)this.paths.get(i);
            this.allDataReaderList.add(this.getReaderByTime(path, groupByTimePlan, (TSDataType)this.dataTypes.get(i), context, null));
        }
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan queryPlan, TSDataType dataType, QueryContext context, TsFileFilter fileFilter) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), fileFilter, this.ascending);
    }

    @Override
    public RowRecord nextWithoutConstraint() throws IOException {
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithoutValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        for (int i = 0; i < this.paths.size(); ++i) {
            aggregateResultList.add(AggregateResultFactory.getAggrResultByName(this.groupByTimePlan.getDeduplicatedAggregations().get(i), this.groupByTimePlan.getDeduplicatedDataTypes().get(i), this.ascending));
        }
        long[] timestampArray = new long[this.timeStampFetchSize];
        int timeArrayLength = 0;
        if (!this.cachedTimestamps.isEmpty()) {
            long timestamp = this.cachedTimestamps.remove();
            if (timestamp < this.curEndTime) {
                if (!this.groupByTimePlan.isAscending() && timestamp < this.curStartTime) {
                    this.cachedTimestamps.addFirst(timestamp);
                    return this.constructRowRecord(aggregateResultList);
                }
                if (timestamp >= this.curStartTime) {
                    timestampArray[timeArrayLength++] = timestamp;
                }
            } else {
                this.cachedTimestamps.addFirst(timestamp);
                return this.constructRowRecord(aggregateResultList);
            }
        }
        while (!this.cachedTimestamps.isEmpty() || this.timestampGenerator.hasNext()) {
            timeArrayLength = this.constructTimeArrayForOneCal(timestampArray, timeArrayLength);
            for (int i = 0; i < this.paths.size(); ++i) {
                ((AggregateResult)aggregateResultList.get(i)).updateResultUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
            timeArrayLength = 0;
            if ((!this.groupByTimePlan.isAscending() || this.lastTimestamp < this.curEndTime) && (this.groupByTimePlan.isAscending() || this.lastTimestamp >= this.curStartTime)) continue;
        }
        if (timeArrayLength > 0) {
            for (int i = 0; i < this.paths.size(); ++i) {
                ((AggregateResult)aggregateResultList.get(i)).updateResultUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
        }
        return this.constructRowRecord(aggregateResultList);
    }

    @Override
    public Pair<Long, Object> peekNextNotNullValue(Path path, int i) throws IOException {
        if (!this.timestampGenerator.hasNext() && this.cachedTimestamps.isEmpty() || this.allDataReaderList.get(i).readerIsEmpty()) {
            return null;
        }
        long[] timestampArray = new long[1];
        AggregateResult aggrResultByName = AggregateResultFactory.getAggrResultByName(this.groupByTimePlan.getDeduplicatedAggregations().get(i), this.groupByTimePlan.getDeduplicatedDataTypes().get(i), this.ascending);
        long tmpStartTime = this.curStartTime - this.slidingStep;
        int index = 0;
        while (tmpStartTime >= this.startTime && (this.timestampGenerator.hasNext() || !this.cachedTimestamps.isEmpty())) {
            long timestamp = Long.MIN_VALUE;
            if (this.timestampGenerator.hasNext()) {
                this.cachedTimestamps.add(this.timestampGenerator.next());
            }
            if (!this.cachedTimestamps.isEmpty() && index < this.cachedTimestamps.size()) {
                timestamp = this.cachedTimestamps.get(index++);
            }
            if (timestamp >= tmpStartTime) {
                timestampArray[0] = timestamp;
            } else {
                do {
                    if (timestamp < (tmpStartTime -= this.slidingStep)) continue;
                    timestampArray[0] = timestamp;
                    break;
                } while (tmpStartTime >= this.startTime);
            }
            aggrResultByName.updateResultUsingTimestamps(timestampArray, 1, this.allDataReaderList.get(i));
            if (aggrResultByName.getResult() == null) continue;
            return new Pair((Object)tmpStartTime, aggrResultByName.getResult());
        }
        return null;
    }

    private int constructTimeArrayForOneCal(long[] timestampArray, int timeArrayLength) throws IOException {
        for (int cnt = 1; cnt < this.timeStampFetchSize - 1 && (!this.cachedTimestamps.isEmpty() || this.timestampGenerator.hasNext()); ++cnt) {
            this.lastTimestamp = !this.cachedTimestamps.isEmpty() ? this.cachedTimestamps.remove().longValue() : this.timestampGenerator.next();
            if (this.groupByTimePlan.isAscending() && this.lastTimestamp < this.curEndTime) {
                timestampArray[timeArrayLength++] = this.lastTimestamp;
                continue;
            }
            if (!this.groupByTimePlan.isAscending() && this.lastTimestamp >= this.curStartTime) {
                timestampArray[timeArrayLength++] = this.lastTimestamp;
                continue;
            }
            if (!this.cachedTimestamps.isEmpty() && this.lastTimestamp <= this.cachedTimestamps.peek()) {
                this.cachedTimestamps.addFirst(this.lastTimestamp);
                break;
            }
            this.cachedTimestamps.add(this.lastTimestamp);
            break;
        }
        return timeArrayLength;
    }

    private RowRecord constructRowRecord(List<AggregateResult> aggregateResultList) {
        RowRecord record = this.leftCRightO ? new RowRecord(this.curStartTime) : new RowRecord(this.curEndTime - 1L);
        for (int i = 0; i < this.paths.size(); ++i) {
            AggregateResult aggregateResult = aggregateResultList.get(i);
            record.addField(aggregateResult.getResult(), aggregateResult.getResultDataType());
        }
        return record;
    }
}

