/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.StatusUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;

public class DeleteTimeSeriesPlan
extends PhysicalPlan {
    private List<PartialPath> deletePathList;
    private Map<Integer, TSStatus> results = new TreeMap<Integer, TSStatus>();

    public DeleteTimeSeriesPlan(List<PartialPath> deletePathList) {
        super(false, Operator.OperatorType.DELETE_TIMESERIES);
        this.deletePathList = deletePathList;
    }

    public DeleteTimeSeriesPlan() {
        super(false, Operator.OperatorType.DELETE_TIMESERIES);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.deletePathList;
    }

    public void setDeletePathList(List<PartialPath> deletePathList) {
        this.deletePathList = deletePathList;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.DELETE_TIMESERIES.ordinal();
        stream.writeByte((byte)type);
        stream.writeInt(this.deletePathList.size());
        for (PartialPath path : this.deletePathList) {
            this.putString(stream, path.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE_TIMESERIES.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.deletePathList.size());
        for (PartialPath path : this.deletePathList) {
            this.putString(buffer, path.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int pathNumber = buffer.getInt();
        this.deletePathList = new ArrayList<PartialPath>();
        for (int i = 0; i < pathNumber; ++i) {
            this.deletePathList.add(new PartialPath(this.readString(buffer)));
        }
        this.index = buffer.getLong();
    }

    @Override
    public void setPaths(List<PartialPath> fullPaths) {
        this.deletePathList = fullPaths;
    }

    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, this.deletePathList.size());
    }
}

