/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.level;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.utils.CompactionUtils;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelCompactionTsFileManagement
extends TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(LevelCompactionTsFileManagement.class);
    private final int seqLevelNum = Math.max(IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum(), 1);
    private final int seqFileNumInEachLevel = Math.max(IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel(), 1);
    private final int unseqLevelNum = Math.max(IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum(), 1);
    private final int unseqFileNumInEachLevel = Math.max(IoTDBDescriptor.getInstance().getConfig().getUnseqFileNumInEachLevel(), 1);
    private final boolean enableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
    private final Map<Long, List<SortedSet<TsFileResource>>> sequenceTsFileResources = new TreeMap<Long, List<SortedSet<TsFileResource>>>();
    private final Map<Long, List<List<TsFileResource>>> unSequenceTsFileResources = new TreeMap<Long, List<List<TsFileResource>>>();
    private final List<List<TsFileResource>> forkedSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
    private final List<List<TsFileResource>> forkedUnSequenceTsFileResources = new ArrayList<List<TsFileResource>>();

    public LevelCompactionTsFileManagement(String storageGroupName, String virtualStorageGroupId, String storageGroupDir) {
        super(storageGroupName, virtualStorageGroupId, storageGroupDir);
        this.clear();
    }

    @Override
    protected void deleteLevelFilesInDisk(Collection<TsFileResource> mergeTsFiles) {
        logger.info("{} [compaction] merge starts to delete real file", (Object)this.storageGroupName);
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            this.deleteLevelFile(mergeTsFile);
            logger.info("{} [Compaction] delete TsFile {}", (Object)this.storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
    }

    protected void deleteLevelFilesInList(long timePartitionId, Collection<TsFileResource> mergeTsFiles, int level, boolean sequence) {
        logger.info("{} [compaction] merge starts to delete file list", (Object)this.storageGroupName);
        if (sequence) {
            if (this.sequenceTsFileResources.containsKey(timePartitionId) && this.sequenceTsFileResources.get(timePartitionId).size() > level) {
                this.sequenceTsFileResources.get(timePartitionId).get(level).removeAll(mergeTsFiles);
            }
        } else if (this.unSequenceTsFileResources.containsKey(timePartitionId) && this.unSequenceTsFileResources.get(timePartitionId).size() > level) {
            this.unSequenceTsFileResources.get(timePartitionId).get(level).removeAll(mergeTsFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<TsFileResource> getTsFileList(boolean sequence) {
        this.readLock();
        try {
            Object object;
            ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
            if (sequence) {
                object = this.sequenceTsFileResources.keySet().iterator();
                while (object.hasNext()) {
                    long timePartition = object.next();
                    result.addAll(this.getTsFileListByTimePartition(true, timePartition));
                }
            } else {
                object = this.unSequenceTsFileResources.keySet().iterator();
                while (object.hasNext()) {
                    long timePartition = object.next();
                    result.addAll(this.getTsFileListByTimePartition(false, timePartition));
                }
            }
            object = result;
            return object;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TsFileResource> getTsFileListByTimePartition(boolean sequence, long timePartition) {
        this.readLock();
        try {
            ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
            if (sequence) {
                List sequenceTsFileList = this.sequenceTsFileResources.getOrDefault(timePartition, new ArrayList());
                for (int i = sequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection)sequenceTsFileList.get(i));
                }
            } else {
                List unSequenceTsFileList = this.unSequenceTsFileResources.getOrDefault(timePartition, new ArrayList());
                for (int i = unSequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection)unSequenceTsFileList.get(i));
                }
            }
            ArrayList<TsFileResource> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        this.readLock();
        try {
            Iterator<TsFileResource> iterator = this.getTsFileList(sequence).iterator();
            return iterator;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock();
        try {
            if (sequence) {
                for (SortedSet<TsFileResource> sequenceTsFileResource : this.sequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                    sequenceTsFileResource.remove(tsFileResource);
                }
            } else {
                for (List<TsFileResource> unSequenceTsFileResource : this.unSequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                    unSequenceTsFileResource.remove(tsFileResource);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock();
        try {
            if (sequence) {
                for (List<SortedSet<TsFileResource>> partitionSequenceTsFileResource : this.sequenceTsFileResources.values()) {
                    for (SortedSet<TsFileResource> levelTsFileResource : partitionSequenceTsFileResource) {
                        levelTsFileResource.removeAll(tsFileResourceList);
                    }
                }
            } else {
                for (List<List<TsFileResource>> partitionUnSequenceTsFileResource : this.unSequenceTsFileResources.values()) {
                    for (List<TsFileResource> levelTsFileResource : partitionUnSequenceTsFileResource) {
                        levelTsFileResource.removeAll(tsFileResourceList);
                    }
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) throws IOException {
        this.writeLock();
        try {
            long timePartitionId = tsFileResource.getTimePartition();
            int level = TsFileResource.getMergeLevel(tsFileResource.getTsFile().getName());
            if (sequence) {
                if (level <= this.seqLevelNum - 1) {
                    ((SortedSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(level)).add(tsFileResource);
                } else {
                    ((SortedSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(this.seqLevelNum - 1)).add(tsFileResource);
                }
            } else if (level <= this.unseqLevelNum - 1) {
                ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(level)).add(tsFileResource);
            } else {
                ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(this.unseqLevelNum - 1)).add(tsFileResource);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) throws IOException {
        this.writeLock();
        try {
            for (TsFileResource tsFileResource : tsFileResourceList) {
                this.add(tsFileResource, sequence);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                for (SortedSet sequenceTsFileResource : this.sequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newSequenceTsFileResources)) {
                    if (!sequenceTsFileResource.contains(tsFileResource)) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                for (List unSequenceTsFileResource : this.unSequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newUnSequenceTsFileResources)) {
                    if (!unSequenceTsFileResource.contains(tsFileResource)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void clear() {
        this.writeLock();
        try {
            this.sequenceTsFileResources.clear();
            this.unSequenceTsFileResources.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                for (List<SequencedCollection<TsFileResource>> list : this.sequenceTsFileResources.values()) {
                    for (SortedSet sortedSet : list) {
                        if (sortedSet.isEmpty()) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            } else {
                for (List<SequencedCollection<TsFileResource>> list : this.unSequenceTsFileResources.values()) {
                    for (List list2 : list) {
                        if (list2.isEmpty()) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean sequence) {
        this.readLock();
        try {
            int result = 0;
            if (sequence) {
                for (List<SequencedCollection<TsFileResource>> list : this.sequenceTsFileResources.values()) {
                    for (int i = this.seqLevelNum - 1; i >= 0; --i) {
                        result += ((SortedSet)list.get(i)).size();
                    }
                }
            } else {
                for (List<SequencedCollection<TsFileResource>> list : this.unSequenceTsFileResources.values()) {
                    for (int i = this.unseqLevelNum - 1; i >= 0; --i) {
                        result += ((List)list.get(i)).size();
                    }
                }
            }
            int n = result;
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
        this.readLock();
        try {
            this.forkTsFileList(this.forkedSequenceTsFileResources, this.sequenceTsFileResources.computeIfAbsent(timePartition, this::newSequenceTsFileResources), this.seqLevelNum);
            this.forkTsFileList(this.forkedUnSequenceTsFileResources, this.unSequenceTsFileResources.computeIfAbsent(timePartition, this::newUnSequenceTsFileResources), this.unseqLevelNum + 1);
        }
        finally {
            this.readUnLock();
        }
    }

    private void forkTsFileList(List<List<TsFileResource>> forkedTsFileResources, List rawTsFileResources, int currMaxLevel) {
        forkedTsFileResources.clear();
        for (int i = 0; i < currMaxLevel - 1; ++i) {
            ArrayList<TsFileResource> forkedLevelTsFileResources = new ArrayList<TsFileResource>();
            Collection levelRawTsFileResources = (Collection)rawTsFileResources.get(i);
            for (TsFileResource tsFileResource : levelRawTsFileResources) {
                if (!tsFileResource.isClosed()) continue;
                forkedLevelTsFileResources.add(tsFileResource);
            }
            forkedTsFileResources.add(forkedLevelTsFileResources);
        }
    }

    @Override
    protected void merge(long timePartition) {
        this.isMergeExecutedInCurrentTask = this.merge(this.forkedSequenceTsFileResources, true, timePartition, this.seqLevelNum, this.seqFileNumInEachLevel);
        this.isMergeExecutedInCurrentTask = this.enableUnseqCompaction && this.unseqLevelNum <= 1 && this.forkedUnSequenceTsFileResources.get(0).size() > 0 ? this.merge(this.isForceFullMerge, this.getTsFileListByTimePartition(true, timePartition), this.forkedUnSequenceTsFileResources.get(0), Long.MAX_VALUE) || this.isMergeExecutedInCurrentTask : this.merge(this.forkedUnSequenceTsFileResources, false, timePartition, this.unseqLevelNum, this.unseqFileNumInEachLevel) || this.isMergeExecutedInCurrentTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean merge(List<List<TsFileResource>> mergeResources, boolean sequence, long timePartition, int currMaxLevel, int currMaxFileNumInEachLevel) {
        mergingFiles = new ArrayList<TsFileResource>();
        while (this.isUnseqMerging) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LevelCompactionTsFileManagement.logger.error("{} [Compaction] shutdown", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        this.isSeqMerging = true;
        startTimeMillis = System.currentTimeMillis();
        isMergeExecutedInCurrentTask = false;
        compactionLogger = null;
        newResource = null;
        try {
            LevelCompactionTsFileManagement.logger.debug("{} start to filter compaction condition", (Object)this.storageGroupName);
            i = 0;
lbl18:
            // 2 sources

            while (i < currMaxLevel - 1) {
                block28: {
                    currLevelTsFileResource = mergeResources.get(i);
                    if (currMaxFileNumInEachLevel > currLevelTsFileResource.size()) ** GOTO lbl111
                    isMergeExecutedInCurrentTask = true;
                    if (!this.enableUnseqCompaction || sequence || i != currMaxLevel - 2) break block28;
                    this.isSeqMerging = false;
                    isMergeExecutedInCurrentTask = this.merge(this.isForceFullMerge, this.getTsFileListByTimePartition(true, timePartition), mergeResources.get(i), 0x7FFFFFFFFFFFFFFFL);
                    ** GOTO lbl111
                }
                toMergeTsFiles = mergeResources.get(i).subList(0, currMaxFileNumInEachLevel);
                this.compactionSelectionLock.lock();
                if (this.checkAndSetFilesMergingIfNotSet(toMergeTsFiles, null)) ** GOTO lbl63
                var16_18 = false;
                this.compactionSelectionLock.unlock();
                this.isSeqMerging = false;
                if (isMergeExecutedInCurrentTask == false) return var16_18;
                ** GOTO lbl61
            }
            ** GOTO lbl113
        }
        catch (Throwable e) {
            block29: {
                try {
                    if (compactionLogger != null) {
                        try {
                            compactionLogger.close();
                        }
                        catch (IOException ioException) {
                            LevelCompactionTsFileManagement.logger.error("{} Compaction log close fail", (Object)(this.storageGroupName + ".compaction.log"));
                        }
                    }
                    for (TsFileResource resource : mergingFiles) {
                        resource.setMerging(false);
                    }
                    isMergeExecutedInCurrentTask = false;
                    this.handleExceptionForCompaction(mergingFiles, newResource, sequence);
                    LevelCompactionTsFileManagement.logger.error("Error occurred in Compaction Merge thread", e);
                    this.isSeqMerging = false;
                    if (isMergeExecutedInCurrentTask == false) return isMergeExecutedInCurrentTask;
                }
                catch (Throwable var20_26) {
                    this.isSeqMerging = false;
                    if (isMergeExecutedInCurrentTask == false) throw var20_26;
                    LevelCompactionTsFileManagement.logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
                    throw var20_26;
                }
lbl61:
                // 1 sources

                LevelCompactionTsFileManagement.logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
                return var16_18;
lbl63:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [2 : 283->293)] { 
lbl64:
                // 1 sources

                break block29;
lbl65:
                // 1 sources

                finally {
                    this.compactionSelectionLock.unlock();
                }
            }
            mergingFiles.addAll(toMergeTsFiles);
            compactionLogger = new CompactionLogger(this.storageGroupDir, this.storageGroupName);
            for (TsFileResource var17_22 : toMergeTsFiles) {
                compactionLogger.logFile("info-source", this.storageGroupName, this.virtualStorageGroupId, timePartition, var17_22.getTsFile(), sequence);
            }
            newLevelFile = TsFileResource.modifyTsFileNameMergeCnt(mergeResources.get(i).get(0).getTsFile());
            compactionLogger.logSequence(sequence);
            compactionLogger.logFile("info-target", this.storageGroupName, this.virtualStorageGroupId, timePartition, newLevelFile, sequence);
            LevelCompactionTsFileManagement.logger.info("{} [Compaction] merge level-{}'s {} TsFiles to next level", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
            for (TsFileResource toMergeTsFile : toMergeTsFiles) {
                LevelCompactionTsFileManagement.logger.info("{} [Compaction] start to merge TsFile {}", (Object)this.storageGroupName, (Object)toMergeTsFile);
            }
            newResource = new TsFileResource(newLevelFile);
            var17_19 = new ArrayList<Modification>();
            CompactionUtils.merge(newResource, toMergeTsFiles, this.storageGroupName, compactionLogger, new HashSet<String>(), sequence, var17_19, null);
            LevelCompactionTsFileManagement.logger.info("{} [Compaction] merged level-{}'s {} TsFiles to next level, and start to delete old files", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
            this.writeLock();
            try {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException(String.format("%s [Compaction] abort", new Object[]{this.storageGroupName}));
                }
                if (sequence) {
                    this.sequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                } else {
                    this.unSequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                }
                this.deleteLevelFilesInList(timePartition, toMergeTsFiles, i, sequence);
                if (mergeResources.size() > i + 1) {
                    mergeResources.get(i + 1).add(newResource);
                }
            }
            finally {
                this.writeUnlock();
            }
            this.deleteLevelFilesInDisk(toMergeTsFiles);
            this.renameLevelFilesMods(var17_19, toMergeTsFiles, newResource);
            compactionLogger.close();
            logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
            if (logFile.exists()) {
                Files.delete(logFile.toPath());
            }
lbl111:
            // 5 sources

            ++i;
            ** GOTO lbl18
lbl113:
            // 1 sources

            this.isSeqMerging = false;
            if (isMergeExecutedInCurrentTask == false) return isMergeExecutedInCurrentTask;
            LevelCompactionTsFileManagement.logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
            return isMergeExecutedInCurrentTask;
            LevelCompactionTsFileManagement.logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
            return isMergeExecutedInCurrentTask;
        }
    }

    private List<SortedSet<TsFileResource>> newSequenceTsFileResources(Long k) {
        ArrayList<SortedSet<TsFileResource>> newSequenceTsFileResources = new ArrayList<SortedSet<TsFileResource>>();
        for (int i = 0; i < this.seqLevelNum; ++i) {
            newSequenceTsFileResources.add(new TreeSet((o1, o2) -> {
                try {
                    int rangeCompare = Long.compare(Long.parseLong(o1.getTsFile().getParentFile().getName()), Long.parseLong(o2.getTsFile().getParentFile().getName()));
                    return rangeCompare == 0 ? LevelCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()) : rangeCompare;
                }
                catch (NumberFormatException e) {
                    return LevelCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile());
                }
            }));
        }
        return newSequenceTsFileResources;
    }

    private List<List<TsFileResource>> newUnSequenceTsFileResources(Long k) {
        ArrayList<List<TsFileResource>> newUnSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
        for (int i = 0; i < this.unseqLevelNum; ++i) {
            newUnSequenceTsFileResources.add(new ArrayList());
        }
        return newUnSequenceTsFileResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TsFileResource getTsFileResource(String filePath, boolean isSeq) {
        block16: {
            this.readLock();
            try {
                File file = new File(filePath);
                if (!file.exists()) {
                    TsFileResource tsFileResource = null;
                    return tsFileResource;
                }
                if (isSeq) {
                    for (List<SequencedCollection<TsFileResource>> list : this.sequenceTsFileResources.values()) {
                        for (SortedSet sortedSet : list) {
                            for (TsFileResource tsFileResource : sortedSet) {
                                if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                                TsFileResource tsFileResource2 = tsFileResource;
                                return tsFileResource2;
                            }
                        }
                    }
                    break block16;
                }
                for (List<SequencedCollection<TsFileResource>> list : this.unSequenceTsFileResources.values()) {
                    for (List list2 : list) {
                        for (TsFileResource tsFileResource : list2) {
                            if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                            TsFileResource tsFileResource3 = tsFileResource;
                            return tsFileResource3;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("cannot get tsfile resource path: {}", (Object)filePath, (Object)e);
                Iterator<List<SequencedCollection<TsFileResource>>> iterator = null;
                return iterator;
            }
            finally {
                this.readUnLock();
            }
        }
        return null;
    }

    private void handleExceptionForCompaction(List<TsFileResource> sourceTsFiles, TsFileResource targetTsFile, boolean sequence) {
        File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
        logger.info("{}-{} [Compaction][Restore] Start to restore compaction", (Object)this.storageGroupName, (Object)this.virtualStorageGroupId);
        try {
            if (targetTsFile == null || !targetTsFile.getTsFile().exists()) {
                logger.warn("{}-{} [Compaction][Restore] Cannot find compaction target file {}", new Object[]{this.storageGroupName, this.virtualStorageGroupId, targetTsFile});
            } else {
                RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(targetTsFile.getTsFile());
                if (writer.hasCrashed()) {
                    writer.close();
                    logger.info("{}-{} [Compaction][Restore] target file {} is incomplete, delete it", new Object[]{this.storageGroupName, this.virtualStorageGroupId, targetTsFile});
                    Files.delete(targetTsFile.getTsFile().toPath());
                } else {
                    logger.info("{}-{} [Compaction][Restore] target file {} is complete, delete source files", new Object[]{this.storageGroupName, this.virtualStorageGroupId, targetTsFile});
                    for (TsFileResource sourceFile : sourceTsFiles) {
                        logger.info("{}-{} [Compaction][Restore] deleting source file {}", new Object[]{this.storageGroupName, this.virtualStorageGroupId, sourceFile});
                        sourceFile.remove();
                        this.remove(sourceFile, sequence);
                    }
                }
            }
            if (logFile.exists()) {
                Files.delete(logFile.toPath());
            }
        }
        catch (IOException e) {
            logger.error("{}-{} [Compaction][Restore] exception occurs during restoring compaction with source files {}, target file {}, set canMerge to false", new Object[]{this.storageGroupName, this.virtualStorageGroupId, sourceTsFiles, targetTsFile, e});
            this.canMerge = false;
        }
    }

    public Map<Long, List<SortedSet<TsFileResource>>> getSequenceTsFileResources() {
        return this.sequenceTsFileResources;
    }
}

