/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileNumUtil {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileNumUtil.class);
    private static final int PID_ERROR_CODE = -1;
    private static final int UNSUPPORTED_OS_ERROR_CODE = -2;
    private static final int UNKNOWN_STATISTICS_ERROR_CODE = -3;
    private static final String IOTDB_PROCESS_KEY_WORD = "IoTDB";
    private static final String LINUX_OS_NAME = "linux";
    private static final String MAC_OS_NAME = "mac";
    private static final String SEARCH_PID_LINUX = "ps -aux | grep -i %s | grep -v grep";
    private static final String SEARCH_PID_MAC = "ps aux | grep -i %s | grep -v grep";
    private static final String SEARCH_OPEN_DATA_FILE_BY_PID = "lsof -p %d";
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static DirectoryManager directoryManager = DirectoryManager.getInstance();
    private static final String[] COMMAND_TEMPLATE = new String[]{"/bin/bash", "-c", ""};
    private static boolean isOutputValid = false;
    private int pid = OpenFileNumUtil.getIotdbPid();

    private OpenFileNumUtil() {
    }

    public static OpenFileNumUtil getInstance() {
        return OpenFileNumUtilHolder.INSTANCE;
    }

    private static boolean isNumeric(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int getIotdbPid() {
        int iotdbPid = -1;
        Runtime r = Runtime.getRuntime();
        String os = System.getProperty("os.name");
        String osName = os.toLowerCase();
        if (osName.startsWith(LINUX_OS_NAME) || osName.startsWith(MAC_OS_NAME)) {
            try {
                String line;
                String command = osName.startsWith(LINUX_OS_NAME) ? String.format(SEARCH_PID_LINUX, IOTDB_PROCESS_KEY_WORD) : String.format(SEARCH_PID_MAC, IOTDB_PROCESS_KEY_WORD);
                OpenFileNumUtil.COMMAND_TEMPLATE[2] = command;
                Process pro1 = r.exec(COMMAND_TEMPLATE);
                BufferedReader in1 = new BufferedReader(new InputStreamReader(pro1.getInputStream()));
                while ((line = in1.readLine()) != null) {
                    String[] temp = (line = line.trim()).split("\\s+");
                    if (temp.length <= 1 || !OpenFileNumUtil.isNumeric(temp[1])) continue;
                    iotdbPid = Integer.parseInt(temp[1]);
                    break;
                }
                in1.close();
                pro1.destroy();
            }
            catch (IOException e) {
                logger.error("Cannot get PID of IoTDB process because ", (Throwable)e);
            }
        } else {
            logger.warn("Unsupported OS {} for OpenFileNumUtil to get the PID of IoTDB.", (Object)os);
        }
        return iotdbPid;
    }

    void setPid(int pid) {
        this.pid = pid;
    }

    private static EnumMap<OpenFileNumStatistics, Integer> getOpenFile(int pid) {
        EnumMap<OpenFileNumStatistics, Integer> resultMap = new EnumMap<OpenFileNumStatistics, Integer>(OpenFileNumStatistics.class);
        for (OpenFileNumStatistics openFileNumStatistics : OpenFileNumStatistics.values()) {
            resultMap.put(openFileNumStatistics, 0);
        }
        int lineCount = 0;
        Runtime r = Runtime.getRuntime();
        try {
            String command;
            OpenFileNumUtil.COMMAND_TEMPLATE[2] = command = String.format(SEARCH_OPEN_DATA_FILE_BY_PID, pid);
            Process pro = r.exec(COMMAND_TEMPLATE);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(pro.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    ++lineCount;
                    OpenFileNumUtil.countOneFile(line, pid, resultMap);
                }
            }
            if (lineCount < OpenFileNumStatistics.values().length) {
                isOutputValid = false;
                for (OpenFileNumStatistics statistics : OpenFileNumStatistics.values()) {
                    resultMap.put(statistics, -2);
                }
            } else {
                isOutputValid = true;
            }
            pro.destroy();
        }
        catch (Exception e) {
            logger.error("Cannot get open file number of IoTDB process because ", (Throwable)e);
        }
        return resultMap;
    }

    private static void countOneFile(String line, int pid, EnumMap<OpenFileNumStatistics, Integer> resultMap) {
        String[] temp = line.split("\\s+");
        if (!line.contains(Integer.toString(pid)) || temp.length <= 8) {
            return;
        }
        int oldValue = resultMap.get((Object)OpenFileNumStatistics.TOTAL_OPEN_FILE_NUM);
        resultMap.put(OpenFileNumStatistics.TOTAL_OPEN_FILE_NUM, oldValue + 1);
        for (OpenFileNumStatistics openFileNumStatistics : OpenFileNumStatistics.values()) {
            if (openFileNumStatistics.path == null) continue;
            for (String path : openFileNumStatistics.path) {
                if (!temp[8].contains(path)) continue;
                oldValue = resultMap.get((Object)openFileNumStatistics);
                resultMap.put(openFileNumStatistics, oldValue + 1);
            }
        }
        if (temp[7].contains("TCP") || temp[7].contains("UDP")) {
            oldValue = resultMap.get((Object)OpenFileNumStatistics.SOCKET_OPEN_FILE_NUM);
            resultMap.put(OpenFileNumStatistics.SOCKET_OPEN_FILE_NUM, oldValue + 1);
        }
    }

    private EnumMap<OpenFileNumStatistics, Integer> getStatisticMap() {
        EnumMap<OpenFileNumStatistics, Integer> resultMap = new EnumMap(OpenFileNumStatistics.class);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith(LINUX_OS_NAME) || osName.startsWith(MAC_OS_NAME)) {
            if (this.pid > 0) {
                resultMap = OpenFileNumUtil.getOpenFile(this.pid);
            } else {
                for (OpenFileNumStatistics statistics : OpenFileNumStatistics.values()) {
                    resultMap.put(statistics, -1);
                }
            }
        } else {
            for (OpenFileNumStatistics statistics : OpenFileNumStatistics.values()) {
                resultMap.put(statistics, -2);
            }
        }
        return resultMap;
    }

    public int get(OpenFileNumStatistics statistics) {
        EnumMap<OpenFileNumStatistics, Integer> statisticsMap = this.getStatisticMap();
        return statisticsMap.getOrDefault((Object)statistics, -3);
    }

    boolean isCommandValid() {
        return isOutputValid;
    }

    static /* synthetic */ DirectoryManager access$200() {
        return directoryManager;
    }

    static /* synthetic */ IoTDBConfig access$300() {
        return config;
    }

    private static class OpenFileNumUtilHolder {
        private static final OpenFileNumUtil INSTANCE = new OpenFileNumUtil();

        private OpenFileNumUtilHolder() {
        }
    }

    public static enum OpenFileNumStatistics {
        TOTAL_OPEN_FILE_NUM(null),
        SEQUENCE_FILE_OPEN_NUM(OpenFileNumUtil.access$200().getAllSequenceFileFolders()),
        UNSEQUENCE_FILE_OPEN_NUM(OpenFileNumUtil.access$200().getAllUnSequenceFileFolders()),
        WAL_OPEN_FILE_NUM(Collections.singletonList(OpenFileNumUtil.access$300().getWalDir())),
        DIGEST_OPEN_FILE_NUM(Collections.singletonList(OpenFileNumUtil.access$300().getSystemDir())),
        SOCKET_OPEN_FILE_NUM(null);

        private List<String> path;

        private OpenFileNumStatistics(List<String> path) {
            this.path = path;
        }

        public List<String> getPath() {
            return this.path;
        }
    }
}

