/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDFContext {
    private final String name;
    private final Map<String, String> attributes;
    private List<PartialPath> paths;
    private List<TSDataType> dataTypes;
    private String columnParameterPart;
    private String column;

    public UDFContext(String name) {
        this.name = name;
        this.attributes = new LinkedHashMap<String, String>();
        this.paths = new ArrayList<PartialPath>();
    }

    public UDFContext(String name, Map<String, String> attributes, List<PartialPath> paths) {
        this.name = name;
        this.attributes = attributes;
        this.paths = paths;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public List<TSDataType> getDataTypes() throws MetadataException {
        if (this.dataTypes == null) {
            this.dataTypes = new ArrayList<TSDataType>();
            for (PartialPath path : this.paths) {
                this.dataTypes.add(IoTDB.metaManager.getSeriesType(path));
            }
        }
        return this.dataTypes;
    }

    public String getColumnName() {
        if (this.column == null) {
            this.column = this.name + "(" + this.getColumnNameParameterPart() + ")";
        }
        return this.column;
    }

    private String getColumnNameParameterPart() {
        if (this.columnParameterPart == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.paths.isEmpty()) {
                builder.append(this.paths.get(0).getFullPath());
                for (int i = 1; i < this.paths.size(); ++i) {
                    builder.append(", ").append(this.paths.get(i).getFullPath());
                }
            }
            if (!this.attributes.isEmpty()) {
                if (!this.paths.isEmpty()) {
                    builder.append(", ");
                }
                Iterator<Map.Entry<String, String>> iterator = this.attributes.entrySet().iterator();
                Map.Entry<String, String> entry = iterator.next();
                builder.append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    builder.append(", ").append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                }
            }
            this.columnParameterPart = builder.toString();
        }
        return this.columnParameterPart;
    }
}

