/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.db.query.udf.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager;
    private static final Logger logger = LoggerFactory.getLogger(QueryResourceManager.class);
    private final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap;
    private final Map<Long, Map<String, QueryDataSource>> cachedQueryDataSourcesMap;

    private QueryResourceManager() {
        this.filePathsManager = new QueryFileManager();
        this.externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();
        this.cachedQueryDataSourcesMap = new ConcurrentHashMap<Long, Map<String, QueryDataSource>>();
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId(boolean isDataQuery) {
        long queryId = this.queryIdAtom.incrementAndGet();
        if (isDataQuery) {
            this.filePathsManager.addQueryId(queryId);
        }
        return queryId;
    }

    public void registerTempExternalSortFile(long queryId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(queryId, x -> new ArrayList()).add(deserializer);
    }

    public void initQueryDataSourceCache(Map<StorageGroupProcessor, List<PartialPath>> processorToSeriesMap, QueryContext context, Filter timeFilter) throws QueryProcessException {
        for (Map.Entry<StorageGroupProcessor, List<PartialPath>> entry : processorToSeriesMap.entrySet()) {
            StorageGroupProcessor processor = entry.getKey();
            List<PartialPath> pathList = entry.getValue();
            Set selectedDeviceIdSet = pathList.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
            long queryId = context.getQueryId();
            String storageGroupPath = processor.getStorageGroupPath();
            QueryDataSource cachedQueryDataSource = processor.query(pathList, selectedDeviceIdSet.size() == 1 ? (String)selectedDeviceIdSet.iterator().next() : null, context, this.filePathsManager, timeFilter);
            this.cachedQueryDataSourcesMap.computeIfAbsent(queryId, k -> new HashMap()).put(storageGroupPath, cachedQueryDataSource);
        }
    }

    public QueryDataSource getQueryDataSource(PartialPath selectedPath, QueryContext context, Filter timeFilter) throws StorageEngineException, QueryProcessException {
        QueryDataSource cachedQueryDataSource;
        long queryId = context.getQueryId();
        String storageGroupPath = StorageEngine.getInstance().getStorageGroupPath(selectedPath);
        String deviceId = selectedPath.getDevice();
        if (this.cachedQueryDataSourcesMap.containsKey(queryId) && this.cachedQueryDataSourcesMap.get(queryId).containsKey(storageGroupPath)) {
            cachedQueryDataSource = this.cachedQueryDataSourcesMap.get(queryId).get(storageGroupPath);
        } else {
            StorageGroupProcessor processor = StorageEngine.getInstance().getProcessor(selectedPath.getDevicePath());
            cachedQueryDataSource = processor.query(Collections.singletonList(selectedPath), selectedPath.getDevice(), context, this.filePathsManager, timeFilter);
        }
        QueryDataSource queryDataSource = new QueryDataSource(cachedQueryDataSource.getSeqResources(), cachedQueryDataSource.getUnseqResources());
        queryDataSource.setDataTTL(cachedQueryDataSource.getDataTTL());
        QueryUtils.fillOrderIndexes(queryDataSource, deviceId, context.isAscending());
        return queryDataSource;
    }

    public void endQuery(long queryId) throws StorageEngineException {
        try {
            if (this.CONFIG.isEnablePerformanceTracing() && TracingManager.getInstance().getTracingInfo(queryId) != null) {
                TracingManager.getInstance().writeTracingInfo(queryId);
                TracingManager.getInstance().writeEndTime(queryId);
            }
        }
        catch (IOException e) {
            logger.error("Error while writing performance info to {}, {}", (Object)(this.CONFIG.getTracingDir() + File.separator + "tracing.txt"), (Object)e.getMessage());
        }
        if (this.externalSortFileMap.get(queryId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(queryId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e);
                }
            }
            this.externalSortFileMap.remove(queryId);
        }
        this.filePathsManager.removeUsedFilesForQuery(queryId);
        TemporaryQueryDataFileService.getInstance().deregister(queryId);
        QueryTimeManager.getInstance().unRegisterQuery(queryId);
        this.cachedQueryDataSourcesMap.remove(queryId);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

