/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class QueryPlan
extends PhysicalPlan {
    protected List<PartialPath> paths = null;
    protected List<PartialPath> fromPaths = null;
    protected List<TSDataType> dataTypes = null;
    private boolean alignByTime = true;
    private int rowLimit = 0;
    private int rowOffset = 0;
    private boolean ascending = true;
    private Map<String, Integer> pathToIndex = new HashMap<String, Integer>();
    private boolean enableRedirect = false;
    private boolean withoutAnyNull;
    private boolean withoutAllNull;

    public QueryPlan() {
        super(true);
        this.setOperatorType(Operator.OperatorType.QUERY);
    }

    public QueryPlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    @Override
    public List<PartialPath> getFromPaths() {
        return this.fromPaths;
    }

    public void setFromPaths(List<PartialPath> fromPaths) {
        this.fromPaths = fromPaths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0;
    }

    public boolean isAlignByTime() {
        return this.alignByTime;
    }

    public void setAlignByTime(boolean align) throws QueryProcessException {
        this.alignByTime = align;
    }

    public void addPathToIndex(String columnName, Integer index) {
        this.pathToIndex.put(columnName, index);
    }

    public Map<String, Integer> getPathToIndex() {
        return this.pathToIndex;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getColumnForReaderFromPath(PartialPath path, int pathIndex) {
        String columnForReader;
        String string = columnForReader = path.isTsAliasExists() ? path.getTsAlias() : null;
        if (columnForReader == null) {
            columnForReader = path.isMeasurementAliasExists() ? path.getFullPathWithAlias() : path.toString();
        }
        return columnForReader;
    }

    public String getColumnForDisplay(String columnForReader, int pathIndex) throws IllegalPathException {
        return columnForReader;
    }

    public boolean isEnableRedirect() {
        return this.enableRedirect;
    }

    public void setEnableRedirect(boolean enableRedirect) {
        this.enableRedirect = enableRedirect;
    }

    public boolean isWithoutAnyNull() {
        return this.withoutAnyNull;
    }

    public void setWithoutAnyNull(boolean withoutAnyNull) {
        this.withoutAnyNull = withoutAnyNull;
    }

    public boolean isWithoutAllNull() {
        return this.withoutAllNull;
    }

    public void setWithoutAllNull(boolean withoutAllNull) {
        this.withoutAllNull = withoutAllNull;
    }
}

