/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class ReadWriteIOUtils {
    public static final int BOOLEAN_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int DOUBLE_LEN = 8;
    public static final int FLOAT_LEN = 4;
    private static final byte[] magicStringBytes = BytesUtils.stringToBytes("TsFile");
    private static final String RETURN_ERROR = "Intend to read %d bytes but %d are actually returned";

    private ReadWriteIOUtils() {
    }

    public static boolean readBool(InputStream inputStream) throws IOException {
        int flag = inputStream.read();
        return flag == 1;
    }

    public static boolean readBool(ByteBuffer buffer) {
        byte a = buffer.get();
        return a == 1;
    }

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static byte[] readBytes(ByteBuffer buffer, int size) {
        byte[] res = new byte[size];
        buffer.get(res);
        return res;
    }

    public static boolean readIsNull(InputStream inputStream) throws IOException {
        return ReadWriteIOUtils.readBool(inputStream);
    }

    public static boolean readIsNull(ByteBuffer buffer) {
        return ReadWriteIOUtils.readBool(buffer);
    }

    public static int write(Map<String, String> map, DataOutputStream stream) throws IOException {
        if (map == null) {
            return ReadWriteIOUtils.write(-1, (OutputStream)stream);
        }
        int length = 0;
        stream.writeInt(map.size());
        length += 4;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            length += ReadWriteIOUtils.write(entry.getKey(), (OutputStream)stream);
            length += ReadWriteIOUtils.write(entry.getValue(), (OutputStream)stream);
        }
        return length;
    }

    public static void write(List<Map<String, String>> maps, DataOutputStream stream) throws IOException {
        for (Map<String, String> map : maps) {
            ReadWriteIOUtils.write(map, stream);
        }
    }

    public static int write(Map<String, String> map, ByteBuffer buffer) {
        if (map == null) {
            return ReadWriteIOUtils.write(-1, buffer);
        }
        int length = 0;
        buffer.putInt(map.size());
        length += 4;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes();
            buffer.putInt(bytes.length);
            length += 4;
            buffer.put(bytes);
            length += bytes.length;
            bytes = entry.getValue().getBytes();
            buffer.putInt(bytes.length);
            length += 4;
            buffer.put(bytes);
            length += bytes.length;
        }
        return length;
    }

    public static void write(List<Map<String, String>> maps, ByteBuffer buffer) {
        for (Map<String, String> map : maps) {
            ReadWriteIOUtils.write(map, buffer);
        }
    }

    public static int write(Boolean flag, OutputStream outputStream) throws IOException {
        if (Boolean.TRUE.equals(flag)) {
            outputStream.write(1);
        } else {
            outputStream.write(0);
        }
        return 1;
    }

    public static int write(Boolean flag, ByteBuffer buffer) {
        byte a = Boolean.TRUE.equals(flag) ? (byte)1 : 0;
        buffer.put(a);
        return 1;
    }

    public static int write(byte n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
        return 1;
    }

    public static int write(short n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.shortToBytes(n);
        outputStream.write(bytes);
        return bytes.length;
    }

    public static int write(byte n, ByteBuffer buffer) {
        buffer.put(n);
        return 1;
    }

    public static int write(short n, ByteBuffer buffer) {
        buffer.putShort(n);
        return 2;
    }

    public static int write(Binary n, ByteBuffer buffer) {
        buffer.putInt(n.getLength());
        buffer.put(n.getValues());
        return 4 + n.getLength();
    }

    public static int write(int n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.intToBytes(n);
        outputStream.write(bytes);
        return 4;
    }

    public static int write(Binary binary, OutputStream outputStream) throws IOException {
        byte[] size = BytesUtils.intToBytes(binary.getValues().length);
        outputStream.write(size);
        outputStream.write(binary.getValues());
        return size.length + binary.getValues().length;
    }

    public static int write(int n, ByteBuffer buffer) {
        buffer.putInt(n);
        return 4;
    }

    public static int write(float n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.floatToBytes(n);
        outputStream.write(bytes);
        return 4;
    }

    public static int write(double n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.doubleToBytes(n);
        outputStream.write(bytes);
        return 8;
    }

    public static int write(long n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.longToBytes(n);
        outputStream.write(bytes);
        return 8;
    }

    public static int write(long n, ByteBuffer buffer) {
        buffer.putLong(n);
        return 8;
    }

    public static int write(float n, ByteBuffer buffer) {
        buffer.putFloat(n);
        return 4;
    }

    public static int write(double n, ByteBuffer buffer) {
        buffer.putDouble(n);
        return 8;
    }

    public static int write(String s, OutputStream outputStream) throws IOException {
        int len = 0;
        if (s == null) {
            return len += ReadWriteIOUtils.write(-1, outputStream);
        }
        byte[] bytes = s.getBytes();
        len += ReadWriteIOUtils.write(bytes.length, outputStream);
        outputStream.write(bytes);
        return len += bytes.length;
    }

    public static int writeVar(String s, OutputStream outputStream) throws IOException {
        int len = 0;
        if (s == null) {
            return len += ReadWriteForEncodingUtils.writeVarInt(-1, outputStream);
        }
        byte[] bytes = s.getBytes(TSFileConfig.STRING_CHARSET);
        len += ReadWriteForEncodingUtils.writeVarInt(bytes.length, outputStream);
        outputStream.write(bytes);
        return len += bytes.length;
    }

    public static int write(String s, ByteBuffer buffer) {
        if (s == null) {
            return ReadWriteIOUtils.write(-1, buffer);
        }
        int len = 0;
        byte[] bytes = s.getBytes();
        len += ReadWriteIOUtils.write(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int writeVar(String s, ByteBuffer buffer) {
        if (s == null) {
            return ReadWriteForEncodingUtils.writeVarInt(-1, buffer);
        }
        int len = 0;
        byte[] bytes = s.getBytes();
        len += ReadWriteForEncodingUtils.writeVarInt(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        int len = 0;
        len += ReadWriteIOUtils.write(byteBuffer.capacity(), outputStream);
        byte[] bytes = byteBuffer.array();
        outputStream.write(bytes);
        return len += bytes.length;
    }

    public static void writeWithoutSize(ByteBuffer byteBuffer, int offset, int len, OutputStream outputStream) throws IOException {
        byte[] bytes = byteBuffer.array();
        outputStream.write(bytes, offset, len);
    }

    public static int write(ByteBuffer byteBuffer, ByteBuffer buffer) {
        int len = 0;
        len += ReadWriteIOUtils.write(byteBuffer.capacity(), buffer);
        byte[] bytes = byteBuffer.array();
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(CompressionType compressionType, OutputStream outputStream) throws IOException {
        byte n = compressionType.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(CompressionType compressionType, ByteBuffer buffer) {
        byte n = compressionType.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static int write(TSDataType dataType, OutputStream outputStream) throws IOException {
        byte n = dataType.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(TSDataType dataType, ByteBuffer buffer) {
        byte n = dataType.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static int write(TSEncoding encoding, OutputStream outputStream) throws IOException {
        byte n = encoding.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(TSEncoding encoding, ByteBuffer buffer) {
        byte n = encoding.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        return (byte)inputStream.read();
    }

    public static short readShort(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[2];
        int readLen = inputStream.read(bytes);
        if (readLen != 2) {
            throw new IOException(String.format(RETURN_ERROR, 2, readLen));
        }
        return BytesUtils.bytesToShort(bytes);
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4];
        int readLen = inputStream.read(bytes);
        if (readLen != 4) {
            throw new IOException(String.format(RETURN_ERROR, 4, readLen));
        }
        return BytesUtils.bytesToFloat(bytes);
    }

    public static float readFloat(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[4];
        byteBuffer.get(bytes);
        return BytesUtils.bytesToFloat(bytes);
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[8];
        int readLen = inputStream.read(bytes);
        if (readLen != 8) {
            throw new IOException(String.format(RETURN_ERROR, 8, readLen));
        }
        return BytesUtils.bytesToDouble(bytes);
    }

    public static double readDouble(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[8];
        byteBuffer.get(bytes);
        return BytesUtils.bytesToDouble(bytes);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4];
        int readLen = inputStream.read(bytes);
        if (readLen != 4) {
            throw new IOException(String.format(RETURN_ERROR, 4, readLen));
        }
        return BytesUtils.bytesToInt(bytes);
    }

    public static int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static int read(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return -1;
        }
        return buffer.get() & 0xFF;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[8];
        int readLen = inputStream.read(bytes);
        if (readLen != 8) {
            throw new IOException(String.format(RETURN_ERROR, 8, readLen));
        }
        return BytesUtils.bytesToLong(bytes);
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static String readString(InputStream inputStream) throws IOException {
        int strLength = ReadWriteIOUtils.readInt(inputStream);
        if (strLength <= 0) {
            return null;
        }
        byte[] bytes = new byte[strLength];
        int readLen = inputStream.read(bytes, 0, strLength);
        if (readLen != strLength) {
            throw new IOException(String.format(RETURN_ERROR, strLength, readLen));
        }
        return new String(bytes, 0, strLength);
    }

    public static String readVarIntString(InputStream inputStream) throws IOException {
        int strLength = ReadWriteForEncodingUtils.readVarInt(inputStream);
        if (strLength <= 0) {
            return null;
        }
        byte[] bytes = new byte[strLength];
        int readLen = inputStream.read(bytes, 0, strLength);
        if (readLen != strLength) {
            throw new IOException(String.format(RETURN_ERROR, strLength, readLen));
        }
        return new String(bytes, 0, strLength);
    }

    public static String readString(ByteBuffer buffer) {
        int strLength = ReadWriteIOUtils.readInt(buffer);
        if (strLength < 0) {
            return null;
        }
        if (strLength == 0) {
            return "";
        }
        byte[] bytes = new byte[strLength];
        buffer.get(bytes, 0, strLength);
        return new String(bytes, 0, strLength);
    }

    public static String readVarIntString(ByteBuffer buffer) {
        int strLength = ReadWriteForEncodingUtils.readVarInt(buffer);
        if (strLength < 0) {
            return null;
        }
        if (strLength == 0) {
            return "";
        }
        byte[] bytes = new byte[strLength];
        buffer.get(bytes, 0, strLength);
        return new String(bytes, 0, strLength);
    }

    public static String readStringWithLength(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        return new String(bytes, 0, length);
    }

    public static ByteBuffer getByteBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteBuffer getByteBuffer(int i) {
        return ByteBuffer.allocate(4).putInt(0, i);
    }

    public static ByteBuffer getByteBuffer(long n) {
        return ByteBuffer.allocate(8).putLong(0, n);
    }

    public static ByteBuffer getByteBuffer(float f) {
        return ByteBuffer.allocate(4).putFloat(0, f);
    }

    public static ByteBuffer getByteBuffer(double d) {
        return ByteBuffer.allocate(8).putDouble(0, d);
    }

    public static ByteBuffer getByteBuffer(boolean i) {
        return ByteBuffer.allocate(1).put(i ? (byte)1 : 0);
    }

    public static String readStringFromDirectByteBuffer(ByteBuffer buffer) throws CharacterCodingException {
        return StandardCharsets.UTF_8.newDecoder().decode(buffer.duplicate()).toString();
    }

    public static byte[] readBytes(InputStream inputStream, int length) throws IOException {
        int len;
        byte[] bytes = new byte[length];
        int offset = 0;
        while (bytes.length - offset > 0 && (len = inputStream.read(bytes, offset, bytes.length - offset)) != -1) {
            offset += len;
        }
        return bytes;
    }

    public static Map<String, String> readMap(ByteBuffer buffer) {
        int length = ReadWriteIOUtils.readInt(buffer);
        if (length == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String key = ReadWriteIOUtils.readString(buffer);
            String value = ReadWriteIOUtils.readString(buffer);
            map.put(key, value);
        }
        return map;
    }

    public static List<Map<String, String>> readMaps(ByteBuffer buffer, int totalSize) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(totalSize);
        for (int i = 0; i < totalSize; ++i) {
            results.add(ReadWriteIOUtils.readMap(buffer));
        }
        return results;
    }

    public static byte[] readBytesWithSelfDescriptionLength(InputStream inputStream) throws IOException {
        int length = ReadWriteIOUtils.readInt(inputStream);
        return ReadWriteIOUtils.readBytes(inputStream, length);
    }

    public static Binary readBinary(ByteBuffer buffer) {
        int length = ReadWriteIOUtils.readInt(buffer);
        byte[] bytes = ReadWriteIOUtils.readBytes(buffer, length);
        return new Binary(bytes);
    }

    public static Binary readBinary(InputStream inputStream) throws IOException {
        int length = ReadWriteIOUtils.readInt(inputStream);
        byte[] bytes = ReadWriteIOUtils.readBytes(inputStream, length);
        return new Binary(bytes);
    }

    public static byte[] readByteBufferWithSelfDescriptionLength(ByteBuffer buffer) {
        int byteLength = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        byte[] bytes = new byte[byteLength];
        buffer.get(bytes);
        return bytes;
    }

    public static int readAsPossible(TsFileInput input, long position, ByteBuffer buffer) throws IOException {
        int read;
        int length = 0;
        while (buffer.hasRemaining() && (read = input.read(buffer, position)) != -1) {
            length += read;
            input.read(buffer, position += (long)read);
        }
        return length;
    }

    public static int readAsPossible(TsFileInput input, ByteBuffer buffer) throws IOException {
        int read;
        int length = 0;
        while (buffer.hasRemaining() && (read = input.read(buffer)) != -1) {
            length += read;
        }
        return length;
    }

    public static int readAsPossible(TsFileInput input, ByteBuffer target, long offset, int len) throws IOException {
        int read;
        int length = 0;
        int limit = target.limit();
        if (target.remaining() > len) {
            target.limit(target.position() + len);
        }
        while (length < len && target.hasRemaining() && (read = input.read(target, offset)) != -1) {
            length += read;
            offset += (long)read;
        }
        target.limit(limit);
        return length;
    }

    public static List<String> readStringList(InputStream inputStream) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readString(inputStream));
        }
        return list;
    }

    public static List<String> readStringList(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readString(buffer));
        }
        return list;
    }

    public static CompressionType readCompressionType(InputStream inputStream) throws IOException {
        byte n = ReadWriteIOUtils.readByte(inputStream);
        return CompressionType.deserialize(n);
    }

    public static CompressionType readCompressionType(ByteBuffer buffer) {
        byte n = buffer.get();
        return CompressionType.deserialize(n);
    }

    public static TSDataType readDataType(InputStream inputStream) throws IOException {
        byte n = ReadWriteIOUtils.readByte(inputStream);
        return TSDataType.deserialize(n);
    }

    public static TSDataType readDataType(ByteBuffer buffer) {
        byte n = buffer.get();
        return TSDataType.deserialize(n);
    }

    public static TSEncoding readEncoding(InputStream inputStream) throws IOException {
        byte n = ReadWriteIOUtils.readByte(inputStream);
        return TSEncoding.deserialize(n);
    }

    public static TSEncoding readEncoding(ByteBuffer buffer) {
        byte n = buffer.get();
        return TSEncoding.deserialize(n);
    }

    public static boolean checkIfMagicString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        boolean res = Arrays.equals(ReadWriteIOUtils.readBytes(byteBuffer, magicStringBytes.length), magicStringBytes);
        byteBuffer.reset();
        return res;
    }

    public static boolean checkIfMagicString(InputStream inputStream) throws IOException {
        return inputStream.available() <= magicStringBytes.length;
    }

    public static void writeObject(Object value, DataOutputStream outputStream) {
        try {
            if (value instanceof Long) {
                outputStream.write(ClassSerializeId.LONG.ordinal());
                outputStream.writeLong((Long)value);
            } else if (value instanceof Double) {
                outputStream.write(ClassSerializeId.DOUBLE.ordinal());
                outputStream.writeDouble((Double)value);
            } else if (value instanceof Integer) {
                outputStream.write(ClassSerializeId.INTEGER.ordinal());
                outputStream.writeInt((Integer)value);
            } else if (value instanceof Float) {
                outputStream.write(ClassSerializeId.FLOAT.ordinal());
                outputStream.writeFloat(((Float)value).floatValue());
            } else if (value instanceof Binary) {
                outputStream.write(ClassSerializeId.BINARY.ordinal());
                byte[] bytes = ((Binary)value).getValues();
                outputStream.writeInt(bytes.length);
                outputStream.write(bytes);
            } else if (value instanceof Boolean) {
                outputStream.write(ClassSerializeId.BOOLEAN.ordinal());
                outputStream.write(Boolean.TRUE.equals(value) ? 1 : 0);
            } else if (value == null) {
                outputStream.write(ClassSerializeId.NULL.ordinal());
            } else {
                outputStream.write(ClassSerializeId.STRING.ordinal());
                byte[] bytes = value.toString().getBytes();
                outputStream.writeInt(bytes.length);
                outputStream.write(bytes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Object readObject(ByteBuffer buffer) {
        ClassSerializeId serializeId = ClassSerializeId.values()[buffer.get()];
        switch (serializeId) {
            case BOOLEAN: {
                return buffer.get() == 1;
            }
            case FLOAT: {
                return Float.valueOf(buffer.getFloat());
            }
            case DOUBLE: {
                return buffer.getDouble();
            }
            case LONG: {
                return buffer.getLong();
            }
            case INTEGER: {
                return buffer.getInt();
            }
            case BINARY: {
                int length = buffer.getInt();
                byte[] bytes = new byte[length];
                buffer.get(bytes);
                return new Binary(bytes);
            }
            case NULL: {
                return null;
            }
        }
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes);
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.remaining());
        while (original.hasRemaining()) {
            clone.put(original.get());
        }
        clone.flip();
        return clone;
    }

    static enum ClassSerializeId {
        LONG,
        DOUBLE,
        INTEGER,
        FLOAT,
        BINARY,
        BOOLEAN,
        STRING,
        NULL;

    }
}

