/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.pool.SessionDataSetWrapper;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    public static final String SESSION_POOL_IS_CLOSED = "Session pool is closed";
    public static final String CLOSE_THE_SESSION_FAILED = "close the session failed.";
    private static final int RETRY = 3;
    private static final int FINAL_RETRY = 2;
    private final ConcurrentLinkedDeque<Session> queue = new ConcurrentLinkedDeque();
    private final ConcurrentMap<Session, Session> occupied = new ConcurrentHashMap<Session, Session>();
    private int size = 0;
    private int maxSize = 0;
    private final long waitToGetSessionTimeoutInMs;
    private final String ip;
    private final int port;
    private final String user;
    private final String password;
    private final int fetchSize;
    private final ZoneId zoneId;
    private final boolean enableCacheLeader;
    private final int connectionTimeoutInMs;
    private final boolean enableCompression;
    private boolean closed;

    public SessionPool(String ip, int port, String user, String password, int maxSize) {
        this(ip, port, user, password, maxSize, 5000, 60000L, false, null, true, 0);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, boolean enableCompression) {
        this(ip, port, user, password, maxSize, 5000, 60000L, enableCompression, null, true, 0);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, boolean enableCompression, boolean enableCacheLeader) {
        this(ip, port, user, password, maxSize, 5000, 60000L, enableCompression, null, enableCacheLeader, 0);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, ZoneId zoneId) {
        this(ip, port, user, password, maxSize, 5000, 60000L, false, zoneId, true, 0);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, int fetchSize, long waitToGetSessionTimeoutInMs, boolean enableCompression, ZoneId zoneId, boolean enableCacheLeader, int connectionTimeoutInMs) {
        this.maxSize = maxSize;
        this.ip = ip;
        this.port = port;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        this.enableCompression = enableCompression;
        this.zoneId = zoneId;
        this.enableCacheLeader = enableCacheLeader;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws IoTDBConnectionException {
        SessionPool sessionPool;
        Session session = this.queue.poll();
        if (this.closed) {
            throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
        }
        if (session != null) {
            return session;
        }
        boolean shouldCreate = false;
        long start = System.currentTimeMillis();
        while (session == null) {
            sessionPool = this;
            synchronized (sessionPool) {
                if (this.size < this.maxSize) {
                    ++this.size;
                    shouldCreate = true;
                    break;
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("no more sessions can be created, wait... queue.size={}", (Object)this.queue.size());
                    }
                    this.wait(1000L);
                    long timeOut = Math.min(this.waitToGetSessionTimeoutInMs, 60000L);
                    if (System.currentTimeMillis() - start > timeOut) {
                        logger.warn("the SessionPool has wait for {} seconds to get a new connection: {}:{} with {}, {}", new Object[]{(System.currentTimeMillis() - start) / 1000L, this.ip, this.port, this.user, this.password});
                        logger.warn("current occupied size {}, queue size {}, considered size {} ", new Object[]{this.occupied.size(), this.queue.size(), this.size});
                        if (System.currentTimeMillis() - start > this.waitToGetSessionTimeoutInMs) {
                            throw new IoTDBConnectionException(String.format("timeout to get a connection from %s:%s", this.ip, this.port));
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                session = this.queue.poll();
                if (this.closed) {
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
            }
        }
        if (shouldCreate) {
            if (logger.isDebugEnabled()) {
                logger.debug("Create a new Session {}, {}, {}, {}", new Object[]{this.ip, this.port, this.user, this.password});
            }
            session = new Session(this.ip, this.port, this.user, this.password, this.fetchSize, this.zoneId, this.enableCacheLeader);
            try {
                session.open(this.enableCompression, this.connectionTimeoutInMs);
                sessionPool = this;
                synchronized (sessionPool) {
                    if (this.closed) {
                        session.close();
                        throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                    }
                }
            }
            catch (IoTDBConnectionException e) {
                SessionPool sessionPool2 = this;
                synchronized (sessionPool2) {
                    --this.size;
                    this.notify();
                    if (logger.isDebugEnabled()) {
                        logger.debug("open session failed, reduce the count and notify others...");
                    }
                }
                throw e;
            }
        }
        return session;
    }

    public int currentAvailableSize() {
        return this.queue.size();
    }

    public int currentOccupiedSize() {
        return this.occupied.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBack(Session session) {
        this.queue.push(session);
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            this.notify();
        }
    }

    private void occupy(Session session) {
        this.occupied.put(session, session);
    }

    public synchronized void close() {
        for (Session session : this.queue) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        for (Session session : this.occupied.keySet()) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        logger.info("closing the session pool, cleaning queues...");
        this.closed = true;
        this.queue.clear();
        this.occupied.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet(SessionDataSetWrapper wrapper) {
        boolean putback = true;
        try {
            wrapper.sessionDataSet.closeOperationHandle();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            this.tryConstructNewSession();
            putback = false;
        }
        finally {
            Session session = (Session)this.occupied.remove(wrapper.session);
            if (putback && session != null) {
                this.putBack(wrapper.session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConstructNewSession() {
        Session session = new Session(this.ip, this.port, this.user, this.password, this.fetchSize, this.zoneId, this.enableCacheLeader);
        try {
            session.open(this.enableCompression, this.connectionTimeoutInMs);
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                if (this.closed) {
                    session.close();
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
                this.queue.push(session);
                this.notify();
            }
        }
        catch (IoTDBConnectionException e) {
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                --this.size;
                this.notify();
                if (logger.isDebugEnabled()) {
                    logger.debug("open session failed, reduce the count and notify others...");
                }
            }
        }
    }

    private void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e2) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e2);
            }
        }
    }

    private void cleanSessionAndMayThrowConnectionException(Session session, int times, IoTDBConnectionException e) throws IoTDBConnectionException {
        this.closeSession(session);
        this.tryConstructNewSession();
        if (times == 2) {
            throw new IoTDBConnectionException(String.format("retry to execute statement on %s:%s failed %d times: %s", this.ip, this.port, 3, e.getMessage()), (Throwable)e);
        }
    }

    public void insertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablet(tablet);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablets(tablets);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(paths);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(String path, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(path, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(List<String> paths, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(paths, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(paths, startTime, endTime);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void setStorageGroup(String storageGroupId) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.setStorageGroup(storageGroupId);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("setStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroup(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroups(List<String> storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroups(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroups failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createMultiTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                boolean resp = session.checkTimeseriesExists(path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("checkTimeseriesExists failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return false;
    }

    public SessionDataSetWrapper executeQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public void executeNonQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.executeNonQueryStatement(sql);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeNonQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public SessionDataSetWrapper executeRawDataQuery(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeRawDataQuery(paths, startTime, endTime);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeRawDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }
}

