/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class TimeseriesSchema
implements Comparable<TimeseriesSchema>,
Serializable {
    private String fullPath;
    private TSDataType type;
    private TSEncoding encoding;
    private transient TSEncodingBuilder encodingConverter;
    private CompressionType compressor;
    private Map<String, String> props = new HashMap<String, String>();

    public TimeseriesSchema() {
    }

    public TimeseriesSchema(String fullPath, TSDataType tsDataType) {
        this(fullPath, tsDataType, TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    public TimeseriesSchema(String fullPath, TSDataType type, TSEncoding encoding) {
        this(fullPath, type, encoding, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    public TimeseriesSchema(String fullPath, TSDataType type, TSEncoding encoding, CompressionType compressionType) {
        this(fullPath, type, encoding, compressionType, Collections.emptyMap());
    }

    public TimeseriesSchema(String fullPath, TSDataType type, TSEncoding encoding, CompressionType compressionType, Map<String, String> props) {
        this.type = type;
        this.fullPath = fullPath;
        this.encoding = encoding;
        this.props = props == null ? Collections.emptyMap() : props;
        this.compressor = compressionType;
    }

    public static TimeseriesSchema deserializeFrom(ByteBuffer buffer) {
        TimeseriesSchema timeseriesSchema = new TimeseriesSchema();
        timeseriesSchema.fullPath = ReadWriteIOUtils.readString(buffer);
        timeseriesSchema.type = ReadWriteIOUtils.readDataType(buffer);
        timeseriesSchema.encoding = ReadWriteIOUtils.readEncoding(buffer);
        timeseriesSchema.compressor = ReadWriteIOUtils.readCompressionType(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            timeseriesSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                String value = ReadWriteIOUtils.readString(buffer);
                timeseriesSchema.props.put(key, value);
            }
        }
        return timeseriesSchema;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public TSEncoding getEncodingType() {
        return this.encoding;
    }

    public TSDataType getType() {
        return this.type;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Encoder getTimeEncoder() {
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSDataType.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType());
        return TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType);
    }

    public Encoder getValueEncoder() {
        if (this.encodingConverter == null) {
            this.encodingConverter = TSEncodingBuilder.getEncodingBuilder(this.encoding);
            this.encodingConverter.initFromProps(this.props);
        }
        return this.encodingConverter.getEncoder(this.type);
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.fullPath, outputStream);
        byteLen += ReadWriteIOUtils.write(this.type, outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        byteLen += ReadWriteIOUtils.write(this.compressor, outputStream);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), outputStream);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.fullPath, buffer);
        byteLen += ReadWriteIOUtils.write(this.type, buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        byteLen += ReadWriteIOUtils.write(this.compressor, buffer);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), buffer);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), buffer);
            }
        }
        return byteLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesSchema that = (TimeseriesSchema)o;
        return this.type == that.type && this.encoding == that.encoding && Objects.equals(this.fullPath, that.fullPath) && Objects.equals((Object)this.compressor, (Object)that.compressor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.encoding, this.fullPath, this.compressor});
    }

    @Override
    public int compareTo(TimeseriesSchema o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.fullPath.compareTo(o.fullPath);
    }

    public String toString() {
        StringContainer sc = new StringContainer("");
        sc.addTail("[", this.fullPath, ",", this.type.toString(), ",", this.encoding.toString(), ",", this.props.toString(), ",", this.compressor.toString());
        sc.addTail("]");
        return sc.toString();
    }
}

