/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PlainDecoder
extends Decoder {
    public PlainDecoder() {
        super(TSEncoding.PLAIN);
    }

    @Override
    public boolean readBoolean(ByteBuffer buffer) {
        return buffer.get() != 0;
    }

    @Override
    public short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        return ReadWriteForEncodingUtils.readVarInt(buffer);
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        return buffer.getFloat();
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        int length = this.readInt(buffer);
        byte[] buf = new byte[length];
        buffer.get(buf, 0, buf.length);
        return new Binary(buf);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        return buffer.remaining() > 0;
    }

    @Override
    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supproted by PlainDecoder");
    }

    @Override
    public void reset() {
    }
}

