/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.TerminalUtils;

public class ConsoleProgressBarConsumer
implements ProgressBarConsumer {
    private static int consoleRightMargin = 2;
    int predefinedMaxLength = -1;
    final PrintStream out;

    public ConsoleProgressBarConsumer(PrintStream out) {
        this.out = out;
    }

    public ConsoleProgressBarConsumer(PrintStream out, int predefinedMaxLength) {
        this.predefinedMaxLength = predefinedMaxLength;
        this.out = out;
    }

    @Override
    public int getMaxRenderedLength() {
        if (this.predefinedMaxLength <= 0) {
            return TerminalUtils.getTerminalWidth() - consoleRightMargin;
        }
        return this.predefinedMaxLength;
    }

    @Override
    public void accept(String str) {
        int acceptedLength = Math.min(str.length(), this.getMaxRenderedLength());
        this.out.print('\r' + str.substring(0, acceptedLength));
    }

    @Override
    public void close() {
        this.out.println();
        this.out.flush();
    }
}

