/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.MetaData;
import com.bugsnag.callbacks.DeviceCallback;
import java.util.HashMap;
import java.util.Map;

class Diagnostics {
    String context;
    Map<String, Object> app;
    Map<String, Object> device;
    Map<String, String> user = new HashMap<String, String>();
    MetaData metaData = new MetaData();

    Diagnostics(Configuration configuration) {
        this.app = this.getDefaultAppInfo(configuration);
        this.device = this.getDefaultDeviceInfo();
    }

    private Map<String, Object> getDefaultDeviceInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hostname", DeviceCallback.getHostnameValue());
        map.put("osName", System.getProperty("os.name"));
        map.put("osVersion", System.getProperty("os.version"));
        map.put("runtimeVersions", this.getRuntimeVersions());
        return map;
    }

    private Map<String, String> getRuntimeVersions() {
        HashMap<String, String> runtimeVersions = new HashMap<String, String>();
        runtimeVersions.put("javaType", System.getProperty("java.runtime.name"));
        runtimeVersions.put("javaVersion", System.getProperty("java.runtime.version"));
        return runtimeVersions;
    }

    private Map<String, Object> getDefaultAppInfo(Configuration configuration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (configuration.releaseStage != null) {
            map.put("releaseStage", configuration.releaseStage);
        }
        if (configuration.appVersion != null) {
            map.put("version", configuration.appVersion);
        }
        return map;
    }

    static void addDeviceRuntimeVersion(Map<String, Object> device, String key, Object value) {
        HashMap<String, Object> runtimeVersions;
        Object obj = device.get("runtimeVersions");
        if (obj instanceof Map) {
            runtimeVersions = (HashMap<String, Object>)obj;
        } else {
            runtimeVersions = new HashMap<String, Object>();
            device.put("runtimeVersions", runtimeVersions);
        }
        runtimeVersions.put(key, value);
    }
}

