/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.time.ZoneId;
import org.apache.iotdb.cluster.query.ClusterConcatPathOptimizer;
import org.apache.iotdb.cluster.query.ClusterPhysicalGenerator;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;

public class ClusterPlanner
extends Planner {
    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId, int fetchSize) throws QueryProcessException {
        Operator operator = this.logicalGenerator.generate(sqlStr, zoneId);
        operator = this.logicalOptimize(operator);
        ClusterPhysicalGenerator physicalGenerator = new ClusterPhysicalGenerator();
        return physicalGenerator.transformToPhysicalPlan(operator, fetchSize);
    }

    protected ConcatPathOptimizer getConcatPathOptimizer() {
        return new ClusterConcatPathOptimizer();
    }
}

