/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition.slot;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotNodeAdditionResult;
import org.apache.iotdb.cluster.partition.slot.SlotNodeRemovalResult;
import org.apache.iotdb.cluster.partition.slot.SlotStrategy;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotPartitionTable
implements PartitionTable {
    private static final Logger logger = LoggerFactory.getLogger(SlotPartitionTable.class);
    private static SlotStrategy slotStrategy = new SlotStrategy.DefaultStrategy();
    private int replicationNum = ClusterDescriptor.getInstance().getConfig().getReplicationNum();
    private List<Node> nodeRing = new ArrayList<Node>();
    private ReadWriteLock nodeRingLock = new ReentrantReadWriteLock();
    private int totalSlotNumbers;
    private Map<Node, List<Integer>> nodeSlotMap = new ConcurrentHashMap<Node, List<Integer>>();
    private Node[] slotNodes = new Node[10000];
    private Map<Node, Map<Integer, Node>> previousNodeMap = new ConcurrentHashMap<Node, Map<Integer, Node>>();
    private List<PartitionGroup> localGroups;
    private Node thisNode;
    private List<PartitionGroup> globalGroups;
    private long lastLogIndex = -1L;

    public SlotPartitionTable(Node thisNode) {
        this.thisNode = thisNode;
    }

    public SlotPartitionTable(Collection<Node> nodes, Node thisNode) {
        this(nodes, thisNode, 10000);
    }

    private SlotPartitionTable(Collection<Node> nodes, Node thisNode, int totalSlotNumbers) {
        this.thisNode = thisNode;
        this.totalSlotNumbers = totalSlotNumbers;
        this.init(nodes);
    }

    public static SlotStrategy getSlotStrategy() {
        return slotStrategy;
    }

    public static void setSlotStrategy(SlotStrategy slotStrategy) {
        SlotPartitionTable.slotStrategy = slotStrategy;
    }

    private void init(Collection<Node> nodes) {
        logger.info("Initializing a new partition table");
        this.nodeRing.addAll(nodes);
        this.nodeRing.sort(Comparator.comparingInt(Node::getNodeIdentifier));
        this.localGroups = this.getPartitionGroups(this.thisNode);
        this.assignPartitions();
    }

    private void assignPartitions() {
        int nodeNum = this.nodeRing.size();
        int slotsPerNode = this.totalSlotNumbers / nodeNum;
        for (Node node : this.nodeRing) {
            this.nodeSlotMap.put(node, new ArrayList());
        }
        for (int i = 0; i < this.totalSlotNumbers; ++i) {
            int nodeIdx = i / slotsPerNode;
            if (nodeIdx >= nodeNum) {
                --nodeIdx;
            }
            this.nodeSlotMap.get(this.nodeRing.get(nodeIdx)).add(i);
        }
        for (Map.Entry<Node, List<Integer>> entry : this.nodeSlotMap.entrySet()) {
            for (Integer slot : entry.getValue()) {
                this.slotNodes[slot.intValue()] = entry.getKey();
            }
        }
    }

    private List<PartitionGroup> getPartitionGroups(Node node) {
        ArrayList<PartitionGroup> ret = new ArrayList<PartitionGroup>();
        int nodeIndex = this.nodeRing.indexOf(node);
        for (int i = 0; i < this.replicationNum; ++i) {
            int startIndex = nodeIndex - i;
            if (startIndex < 0) {
                startIndex += this.nodeRing.size();
            }
            ret.add(this.getHeaderGroup(this.nodeRing.get(startIndex)));
        }
        logger.debug("The partition groups of {} are: {}", (Object)node, ret);
        return ret;
    }

    @Override
    public PartitionGroup getHeaderGroup(Node node) {
        PartitionGroup ret = new PartitionGroup();
        int nodeIndex = this.nodeRing.indexOf(node);
        if (nodeIndex == -1) {
            logger.error("Node {} is not in the cluster", (Object)node);
            return null;
        }
        int endIndex = nodeIndex + this.replicationNum;
        if (endIndex > this.nodeRing.size()) {
            ret.addAll(this.nodeRing.subList(nodeIndex, this.nodeRing.size()));
            ret.addAll(this.nodeRing.subList(0, endIndex - this.nodeRing.size()));
        } else {
            ret.addAll(this.nodeRing.subList(nodeIndex, endIndex));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionGroup route(String storageGroupName, long timestamp) {
        Lock readLock = this.nodeRingLock.readLock();
        readLock.lock();
        try {
            Node node = this.routeToHeaderByTime(storageGroupName, timestamp);
            PartitionGroup partitionGroup = this.getHeaderGroup(node);
            return partitionGroup;
        }
        finally {
            readLock.unlock();
        }
    }

    public PartitionGroup route(int slot) {
        if (slot >= this.slotNodes.length || slot < 0) {
            logger.warn("Invalid slot to route: {}, stack trace: {}", (Object)slot, (Object)Thread.currentThread().getStackTrace());
            return null;
        }
        Node node = this.slotNodes[slot];
        logger.debug("The slot of {} is held by {}", (Object)slot, (Object)node);
        if (node == null) {
            logger.warn("The slot {} is incorrect", (Object)slot);
            return null;
        }
        return this.getHeaderGroup(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node routeToHeaderByTime(String storageGroupName, long timestamp) {
        Lock readLock = this.nodeRingLock.readLock();
        readLock.lock();
        try {
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(storageGroupName, timestamp, this.getTotalSlotNumbers());
            Node node = this.slotNodes[slot];
            logger.trace("The slot of {}@{} is {}, held by {}", new Object[]{storageGroupName, timestamp, slot, node});
            Node node2 = node;
            return node2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAdditionResult addNode(Node node) {
        Lock writeLock = this.nodeRingLock.writeLock();
        writeLock.lock();
        try {
            if (this.nodeRing.contains(node)) {
                NodeAdditionResult nodeAdditionResult = null;
                return nodeAdditionResult;
            }
            this.nodeRing.add(node);
            this.nodeRing.sort(Comparator.comparingInt(Node::getNodeIdentifier));
            ArrayList<PartitionGroup> retiredGroups = new ArrayList<PartitionGroup>();
            for (int i = 0; i < this.localGroups.size(); ++i) {
                PartitionGroup oldGroup = this.localGroups.get(i);
                Node header = oldGroup.getHeader();
                PartitionGroup newGrp = this.getHeaderGroup(header);
                if (newGrp.contains(node) && newGrp.contains(this.thisNode)) {
                    this.localGroups.set(i, newGrp);
                    continue;
                }
                if (!newGrp.contains(node) || newGrp.contains(this.thisNode)) continue;
                retiredGroups.add(newGrp);
            }
            Iterator<PartitionGroup> groupIterator = this.localGroups.iterator();
            block5: while (groupIterator.hasNext()) {
                PartitionGroup partitionGroup = groupIterator.next();
                for (PartitionGroup retiredGroup : retiredGroups) {
                    if (!retiredGroup.getHeader().equals(partitionGroup.getHeader())) continue;
                    groupIterator.remove();
                    continue block5;
                }
            }
        }
        finally {
            writeLock.unlock();
        }
        SlotNodeAdditionResult result = new SlotNodeAdditionResult();
        PartitionGroup newGroup = this.getHeaderGroup(node);
        if (newGroup.contains(this.thisNode)) {
            this.localGroups.add(newGroup);
        }
        result.setNewGroup(newGroup);
        this.calculateGlobalGroups();
        result.setLostSlots(this.moveSlotsToNew(node));
        return result;
    }

    private Map<Node, Set<Integer>> moveSlotsToNew(Node newNode) {
        HashMap<Node, Set<Integer>> result = new HashMap<Node, Set<Integer>>();
        ArrayList<Integer> newSlots = new ArrayList<Integer>();
        HashMap<Integer, Node> previousHolders = new HashMap<Integer, Node>();
        int newAvg = this.totalSlotNumbers / this.nodeRing.size();
        for (Map.Entry<Node, List<Integer>> entry : this.nodeSlotMap.entrySet()) {
            List<Integer> slots = entry.getValue();
            int transferNum = slots.size() - newAvg;
            if (transferNum <= 0) continue;
            List<Integer> slotsToMove = slots.subList(slots.size() - transferNum, slots.size());
            newSlots.addAll(slotsToMove);
            for (Integer slot : slotsToMove) {
                previousHolders.put(slot, entry.getKey());
                this.slotNodes[slot.intValue()] = newNode;
            }
            result.computeIfAbsent(entry.getKey(), n -> new HashSet()).addAll(slotsToMove);
            slotsToMove.clear();
        }
        this.nodeSlotMap.put(newNode, newSlots);
        this.previousNodeMap.put(newNode, previousHolders);
        return result;
    }

    @Override
    public List<PartitionGroup> getLocalGroups() {
        return this.localGroups;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.totalSlotNumbers);
            dataOutputStream.writeInt(this.nodeSlotMap.size());
            for (Map.Entry<Node, List<Integer>> entry : this.nodeSlotMap.entrySet()) {
                NodeSerializeUtils.serialize(entry.getKey(), dataOutputStream);
                SerializeUtils.serializeIntList(entry.getValue(), (DataOutputStream)dataOutputStream);
            }
            dataOutputStream.writeInt(this.previousNodeMap.size());
            for (Map.Entry<Node, Object> entry : this.previousNodeMap.entrySet()) {
                dataOutputStream.writeInt(entry.getKey().getNodeIdentifier());
                Map prevHolders = (Map)entry.getValue();
                dataOutputStream.writeInt(prevHolders.size());
                for (Map.Entry integerNodeEntry : prevHolders.entrySet()) {
                    dataOutputStream.writeInt((Integer)integerNodeEntry.getKey());
                    dataOutputStream.writeInt(((Node)integerNodeEntry.getValue()).getNodeIdentifier());
                }
            }
            dataOutputStream.writeLong(this.lastLogIndex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        logger.info("Initializing the partition table from buffer");
        this.totalSlotNumbers = buffer.getInt();
        int size = buffer.getInt();
        HashMap<Integer, Node> idNodeMap = new HashMap<Integer, Node>();
        for (int i = 0; i < size; ++i) {
            Node node = new Node();
            ArrayList slots = new ArrayList();
            NodeSerializeUtils.deserialize(node, buffer);
            SerializeUtils.deserializeIntList(slots, (ByteBuffer)buffer);
            this.nodeSlotMap.put(node, slots);
            idNodeMap.put(node.getNodeIdentifier(), node);
            for (Integer slot : slots) {
                this.slotNodes[slot.intValue()] = node;
            }
        }
        int prevNodeMapSize = buffer.getInt();
        this.previousNodeMap = new HashMap<Node, Map<Integer, Node>>();
        for (int i = 0; i < prevNodeMapSize; ++i) {
            int nodeId = buffer.getInt();
            Node node = (Node)idNodeMap.get(nodeId);
            HashMap<Integer, Node> prevHolders = new HashMap<Integer, Node>();
            int holderNum = buffer.getInt();
            for (int i1 = 0; i1 < holderNum; ++i1) {
                int slot = buffer.getInt();
                Node holder = (Node)idNodeMap.get(buffer.getInt());
                prevHolders.put(slot, holder);
            }
            this.previousNodeMap.put(node, prevHolders);
        }
        this.lastLogIndex = buffer.getLong();
        this.nodeRing.addAll(this.nodeSlotMap.keySet());
        this.nodeRing.sort(Comparator.comparingInt(Node::getNodeIdentifier));
        logger.info("All known nodes: {}", this.nodeRing);
        this.localGroups = this.getPartitionGroups(this.thisNode);
    }

    @Override
    public List<Node> getAllNodes() {
        return this.nodeRing;
    }

    public Map<Integer, Node> getPreviousNodeMap(Node node) {
        return this.previousNodeMap.get(node);
    }

    public List<Integer> getNodeSlots(Node header) {
        return this.nodeSlotMap.get(header);
    }

    public Map<Node, List<Integer>> getAllNodeSlots() {
        return this.nodeSlotMap;
    }

    public int getTotalSlotNumbers() {
        return this.totalSlotNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotPartitionTable that = (SlotPartitionTable)o;
        return this.totalSlotNumbers == that.totalSlotNumbers && Objects.equals(this.nodeRing, that.nodeRing) && Objects.equals(this.nodeSlotMap, that.nodeSlotMap) && Arrays.equals(this.slotNodes, that.slotNodes) && Objects.equals(this.previousNodeMap, that.previousNodeMap);
    }

    public int hashCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRemovalResult removeNode(Node target) {
        Lock writeLock = this.nodeRingLock.writeLock();
        writeLock.lock();
        try {
            PartitionGroup newGrp;
            Node header;
            if (!this.nodeRing.contains(target)) {
                NodeRemovalResult nodeRemovalResult = null;
                return nodeRemovalResult;
            }
            SlotNodeRemovalResult result = new SlotNodeRemovalResult();
            result.setRemovedGroup(this.getHeaderGroup(target));
            this.nodeRing.remove(target);
            int removedGroupIdx = -1;
            for (int i = 0; i < this.localGroups.size(); ++i) {
                PartitionGroup oldGroup = this.localGroups.get(i);
                header = oldGroup.getHeader();
                if (header.equals(target)) {
                    removedGroupIdx = i;
                    continue;
                }
                newGrp = this.getHeaderGroup(header);
                this.localGroups.set(i, newGrp);
            }
            if (removedGroupIdx != -1) {
                this.localGroups.remove(removedGroupIdx);
                int thisNodeIdx = this.nodeRing.indexOf(this.thisNode);
                int headerNodeIdx = thisNodeIdx - (this.replicationNum - 1);
                headerNodeIdx = headerNodeIdx < 0 ? headerNodeIdx + this.nodeRing.size() : headerNodeIdx;
                header = this.nodeRing.get(headerNodeIdx);
                newGrp = this.getHeaderGroup(header);
                this.localGroups.add(newGrp);
                result.setNewGroup(newGrp);
            }
            this.calculateGlobalGroups();
            Map<Node, List<Integer>> nodeListMap = this.retrieveSlots(target);
            result.setNewSlotOwners(nodeListMap);
            SlotNodeRemovalResult slotNodeRemovalResult = result;
            return slotNodeRemovalResult;
        }
        finally {
            writeLock.unlock();
        }
    }

    private Map<Node, List<Integer>> retrieveSlots(Node target) {
        HashMap<Node, List<Integer>> newHolderSlotMap = new HashMap<Node, List<Integer>>();
        List<Integer> slots = this.nodeSlotMap.remove(target);
        for (int i = 0; i < slots.size(); ++i) {
            Node newHolder;
            int slot = slots.get(i);
            this.slotNodes[slot] = newHolder = this.nodeRing.get(i % this.nodeRing.size());
            this.nodeSlotMap.get(newHolder).add(slot);
            newHolderSlotMap.computeIfAbsent(newHolder, n -> new ArrayList()).add(slot);
        }
        return newHolderSlotMap;
    }

    @Override
    public List<PartitionGroup> getGlobalGroups() {
        Lock readLock = this.nodeRingLock.readLock();
        readLock.lock();
        try {
            if (this.globalGroups == null) {
                this.calculateGlobalGroups();
            }
            List<PartitionGroup> list = this.globalGroups;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    private void calculateGlobalGroups() {
        this.globalGroups = new ArrayList<PartitionGroup>();
        for (Node n : this.getAllNodes()) {
            this.globalGroups.add(this.getHeaderGroup(n));
        }
    }

    public synchronized long getLastLogIndex() {
        return this.lastLogIndex;
    }

    public synchronized void setLastLogIndex(long lastLogIndex) {
        this.lastLogIndex = Math.max(this.lastLogIndex, lastLogIndex);
    }
}

