/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class AddNodeLog
extends Log {
    private Node newNode;

    public Node getNewNode() {
        return this.newNode;
    }

    public void setNewNode(Node newNode) {
        this.newNode = newNode;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte(Log.Types.ADD_NODE.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            NodeSerializeUtils.serialize(this.newNode, dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.newNode = new Node();
        NodeSerializeUtils.deserialize(this.newNode, buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddNodeLog that = (AddNodeLog)o;
        return Objects.equals(this.newNode, that.newNode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.newNode);
    }
}

