/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.io.Closeable;
import java.net.SocketException;
import org.apache.iotdb.cluster.client.sync.SyncClientFactory;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncDataClient
extends TSDataService.Client
implements Closeable {
    Node node;
    SyncClientPool pool;

    public SyncDataClient(TProtocol prot) {
        super(prot);
    }

    public SyncDataClient(TProtocolFactory protocolFactory, Node node, SyncClientPool pool) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, node.getInternalIp(), node.getDataPort(), RaftServer.getConnectionTimeoutInMS()))));
        this.node = node;
        this.pool = pool;
        this.getInputProtocol().getTransport().open();
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).getTimeOut();
    }

    public void putBack() {
        if (this.pool != null) {
            this.pool.putClient(this.node, (RaftService.Client)this);
        } else {
            TProtocol inputProtocol = this.getInputProtocol();
            if (inputProtocol != null) {
                inputProtocol.getTransport().close();
            }
        }
    }

    @Override
    public void close() {
        this.putBack();
    }

    public String toString() {
        return "DataClient{node=" + this.node + '}';
    }

    public Node getNode() {
        return this.node;
    }

    public static class FactorySync
    implements SyncClientFactory {
        private TProtocolFactory protocolFactory;

        public FactorySync(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        public SyncDataClient getSyncClient(Node node, SyncClientPool pool) throws TTransportException {
            return new SyncDataClient(this.protocolFactory, node, pool);
        }
    }
}

