/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import org.apache.iotdb.cluster.client.async.AsyncClientFactory;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;

public class AsyncMetaHeartbeatClient
extends AsyncMetaClient {
    private AsyncMetaHeartbeatClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, Node node, AsyncClientPool pool) throws IOException {
        super(protocolFactory, clientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)node.getInternalIp(), (int)(node.getMetaPort() + 1), (int)RaftServer.getConnectionTimeoutInMS()));
        this.node = node;
        this.pool = pool;
    }

    @Override
    public String toString() {
        return "AsyncMetaHeartbeatClient{node=" + super.getNode() + ",metaHeartbeatPort=" + (super.getNode().getMetaPort() + 1) + '}';
    }

    public static class FactoryAsync
    extends AsyncClientFactory {
        public FactoryAsync(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        @Override
        public RaftService.AsyncClient getAsyncClient(Node node, AsyncClientPool pool) throws IOException {
            TAsyncClientManager manager = managers[this.clientCnt.incrementAndGet() % managers.length];
            manager = manager == null ? new TAsyncClientManager() : manager;
            return new AsyncMetaHeartbeatClient(this.protocolFactory, manager, node, pool);
        }
    }
}

