/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class SerializeUtils {
    private SerializeUtils() {
    }

    public static void serialize(String str, DataOutputStream dataOutputStream) {
        try {
            byte[] strBytes = str.getBytes(TSFileConfig.STRING_CHARSET);
            dataOutputStream.writeInt(strBytes.length);
            dataOutputStream.write(strBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String deserializeString(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] strBytes = new byte[length];
        buffer.get(strBytes);
        return new String(strBytes, TSFileConfig.STRING_CHARSET);
    }

    public static void serializeStringList(List<String> strs, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(strs.size());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String str : strs) {
            SerializeUtils.serialize(str, dataOutputStream);
        }
    }

    public static List<String> deserializeStringList(ByteBuffer buffer) {
        int length = buffer.getInt();
        ArrayList<String> result = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            result.add(SerializeUtils.deserializeString(buffer));
        }
        return result;
    }

    public static void serializeIntList(List<Integer> ints, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(ints.size());
            for (Integer anInt : ints) {
                dataOutputStream.writeInt(anInt);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deserializeIntList(List<Integer> ints, ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            ints.add(buffer.getInt());
        }
    }

    public static void serializeIntSet(Set<Integer> ints, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(ints.size());
            for (Integer anInt : ints) {
                dataOutputStream.writeInt(anInt);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deserializeIntSet(Set<Integer> ints, ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            ints.add(buffer.getInt());
        }
    }

    public static void serializeBatchData(BatchData batchData, DataOutputStream outputStream) {
        try {
            int length = batchData.length();
            TSDataType dataType = batchData.getDataType();
            outputStream.writeInt(length);
            outputStream.write(dataType.ordinal());
            outputStream.write(batchData.getBatchDataType().ordinal());
            batchData.serializeData(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BatchData deserializeBatchData(ByteBuffer buffer) {
        if (buffer == null || buffer.limit() - buffer.position() == 0) {
            return null;
        }
        int length = buffer.getInt();
        TSDataType dataType = TSDataType.values()[buffer.get()];
        BatchData batchData = BatchData.BatchDataType.deserialize((byte)buffer.get(), (TSDataType)dataType);
        switch (dataType) {
            case INT32: {
                for (int i = 0; i < length; ++i) {
                    batchData.putInt(buffer.getLong(), buffer.getInt());
                }
                break;
            }
            case INT64: {
                for (int i = 0; i < length; ++i) {
                    batchData.putLong(buffer.getLong(), buffer.getLong());
                }
                break;
            }
            case TEXT: {
                for (int i = 0; i < length; ++i) {
                    long time = buffer.getLong();
                    int len = buffer.getInt();
                    byte[] bytes = new byte[len];
                    buffer.get(bytes);
                    batchData.putBinary(time, new Binary(bytes));
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    batchData.putFloat(buffer.getLong(), buffer.getFloat());
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    batchData.putDouble(buffer.getLong(), buffer.getDouble());
                }
                break;
            }
            case BOOLEAN: {
                for (int i = 0; i < length; ++i) {
                    batchData.putBoolean(buffer.getLong(), buffer.get() == 1);
                }
                break;
            }
        }
        batchData.resetBatchData();
        return batchData;
    }

    private static void serializeTextTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeInt(timeValuePair.getValue().getBinary().getLength());
            dataOutputStream.write(timeValuePair.getValue().getBinary().getValues());
        }
    }

    private static void serializeBooleanTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeBoolean(timeValuePair.getValue().getBoolean());
        }
    }

    private static void serializeIntTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeInt(timeValuePair.getValue().getInt());
        }
    }

    private static void serializeLongTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeLong(timeValuePair.getValue().getLong());
        }
    }

    private static void serializeFloatTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeFloat(timeValuePair.getValue().getFloat());
        }
    }

    private static void serializeDoubleTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) throws IOException {
        for (TimeValuePair timeValuePair : timeValuePairs) {
            dataOutputStream.writeLong(timeValuePair.getTimestamp());
            if (timeValuePair.getTimestamp() == Long.MIN_VALUE) continue;
            dataOutputStream.writeDouble(timeValuePair.getValue().getDouble());
        }
    }

    public static void serializeTVPairs(List<TimeValuePair> timeValuePairs, DataOutputStream dataOutputStream) {
        try {
            TSDataType dataType = timeValuePairs.get(0).getValue().getDataType();
            dataOutputStream.write(dataType.ordinal());
            dataOutputStream.writeInt(timeValuePairs.size());
            switch (timeValuePairs.get(0).getValue().getDataType()) {
                case TEXT: {
                    SerializeUtils.serializeTextTVPairs(timeValuePairs, dataOutputStream);
                    break;
                }
                case BOOLEAN: {
                    SerializeUtils.serializeBooleanTVPairs(timeValuePairs, dataOutputStream);
                    break;
                }
                case INT64: {
                    SerializeUtils.serializeLongTVPairs(timeValuePairs, dataOutputStream);
                    break;
                }
                case INT32: {
                    SerializeUtils.serializeIntTVPairs(timeValuePairs, dataOutputStream);
                    break;
                }
                case FLOAT: {
                    SerializeUtils.serializeFloatTVPairs(timeValuePairs, dataOutputStream);
                    break;
                }
                case DOUBLE: {
                    SerializeUtils.serializeDoubleTVPairs(timeValuePairs, dataOutputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void serializeTVPair(TimeValuePair timeValuePair, DataOutputStream dataOutputStream) {
        if (timeValuePair.getValue() == null) {
            return;
        }
        TSDataType dataType = timeValuePair.getValue().getDataType();
        try {
            dataOutputStream.write(dataType.ordinal());
            switch (dataType) {
                case TEXT: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeInt(timeValuePair.getValue().getBinary().getLength());
                    dataOutputStream.write(timeValuePair.getValue().getBinary().getValues());
                    break;
                }
                case BOOLEAN: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeBoolean(timeValuePair.getValue().getBoolean());
                    break;
                }
                case INT64: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeLong(timeValuePair.getValue().getLong());
                    break;
                }
                case INT32: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeInt(timeValuePair.getValue().getInt());
                    break;
                }
                case FLOAT: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeFloat(timeValuePair.getValue().getFloat());
                    break;
                }
                case DOUBLE: {
                    dataOutputStream.writeLong(timeValuePair.getTimestamp());
                    if (timeValuePair.getTimestamp() == Long.MIN_VALUE) break;
                    dataOutputStream.writeDouble(timeValuePair.getValue().getDouble());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void deserializeDoubleTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            long time = buffer.getLong();
            TimeValuePair pair = time != Long.MIN_VALUE ? new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getDouble())) : new TimeValuePair(time, null);
            ret.add(pair);
        }
    }

    private static void deserializeFloatTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            long time = buffer.getLong();
            TimeValuePair pair = time != Long.MIN_VALUE ? new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)Float.valueOf(buffer.getFloat()))) : new TimeValuePair(time, null);
            ret.add(pair);
        }
    }

    private static void deserializeIntTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            long time = buffer.getLong();
            TimeValuePair pair = time != Long.MIN_VALUE ? new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getInt())) : new TimeValuePair(time, null);
            ret.add(pair);
        }
    }

    private static void deserializeLongTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            long time = buffer.getLong();
            TimeValuePair pair = time != Long.MIN_VALUE ? new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getLong())) : new TimeValuePair(time, null);
            ret.add(pair);
        }
    }

    private static void deserializeBooleanTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            long time = buffer.getLong();
            TimeValuePair pair = time != Long.MIN_VALUE ? new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)(buffer.get() == 1 ? 1 : 0))) : new TimeValuePair(time, null);
            ret.add(pair);
        }
    }

    private static void deserializeTextTVPairs(ByteBuffer buffer, List<TimeValuePair> ret, int size, TSDataType dataType) {
        for (int i = 0; i < size; ++i) {
            TimeValuePair pair;
            long time = buffer.getLong();
            if (time != Long.MIN_VALUE) {
                int bytesLen = buffer.getInt();
                byte[] bytes = new byte[bytesLen];
                buffer.get(bytes);
                TsPrimitiveType primitiveType = TsPrimitiveType.getByType((TSDataType)dataType, (Object)new Binary(bytes));
                pair = new TimeValuePair(time, primitiveType);
            } else {
                pair = new TimeValuePair(time, null);
            }
            ret.add(pair);
        }
    }

    public static List<TimeValuePair> deserializeTVPairs(ByteBuffer buffer) {
        if (buffer == null || buffer.limit() == 0) {
            return Collections.emptyList();
        }
        TSDataType dataType = TSDataType.values()[buffer.get()];
        int size = buffer.getInt();
        ArrayList<TimeValuePair> ret = new ArrayList<TimeValuePair>(size);
        switch (dataType) {
            case DOUBLE: {
                SerializeUtils.deserializeDoubleTVPairs(buffer, ret, size, dataType);
                break;
            }
            case FLOAT: {
                SerializeUtils.deserializeFloatTVPairs(buffer, ret, size, dataType);
                break;
            }
            case INT32: {
                SerializeUtils.deserializeIntTVPairs(buffer, ret, size, dataType);
                break;
            }
            case INT64: {
                SerializeUtils.deserializeLongTVPairs(buffer, ret, size, dataType);
                break;
            }
            case BOOLEAN: {
                SerializeUtils.deserializeBooleanTVPairs(buffer, ret, size, dataType);
                break;
            }
            case TEXT: {
                SerializeUtils.deserializeTextTVPairs(buffer, ret, size, dataType);
            }
        }
        return ret;
    }

    public static TimeValuePair deserializeTVPair(ByteBuffer buffer) {
        if (buffer == null || buffer.limit() - buffer.position() == 0) {
            return null;
        }
        TSDataType dataType = TSDataType.values()[buffer.get()];
        long time = buffer.getLong();
        if (time == Long.MIN_VALUE) {
            return new TimeValuePair(time, null);
        }
        switch (dataType) {
            case DOUBLE: {
                return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getDouble()));
            }
            case FLOAT: {
                return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)Float.valueOf(buffer.getFloat())));
            }
            case INT32: {
                return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getInt()));
            }
            case INT64: {
                return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)buffer.getLong()));
            }
            case BOOLEAN: {
                return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)dataType, (Object)(buffer.get() == 1 ? 1 : 0)));
            }
            case TEXT: {
                int bytesLen = buffer.getInt();
                byte[] bytes = new byte[bytesLen];
                buffer.get(bytes);
                TsPrimitiveType primitiveType = TsPrimitiveType.getByType((TSDataType)dataType, (Object)new Binary(bytes));
                return new TimeValuePair(time, primitiveType);
            }
        }
        return null;
    }

    public static ByteBuffer serializeFilter(Filter filter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        filter.serialize(dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static void serializeObject(Object object, DataOutputStream dataOutputStream) {
        ReadWriteIOUtils.writeObject((Object)object, (DataOutputStream)dataOutputStream);
    }

    public static void serializeObjects(Object[] object, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(object.length);
            for (Object o : object) {
                ReadWriteIOUtils.writeObject((Object)o, (DataOutputStream)dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Object deserializeObject(ByteBuffer buffer) {
        if (buffer == null || buffer.limit() == 0) {
            return null;
        }
        return ReadWriteIOUtils.readObject((ByteBuffer)buffer);
    }

    public static Object[] deserializeObjects(ByteBuffer buffer) {
        if (buffer == null || buffer.limit() == 0) {
            return new Object[0];
        }
        int size = buffer.getInt();
        Object[] ret = new Object[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ReadWriteIOUtils.readObject((ByteBuffer)buffer);
        }
        return ret;
    }

    public static ByteBuffer serializeLongs(long[] longs) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (long aLong : longs) {
                dataOutputStream.writeLong(aLong);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static long[] deserializeLongs(ByteBuffer buffer) {
        int size = (buffer.limit() - buffer.position()) / 8;
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = buffer.getLong();
        }
        return ret;
    }
}

