/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift;

import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServiceThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ThriftServiceThread.class);
    private TServerTransport serverTransport;
    private TServer poolServer;
    private CountDownLatch threadStopLatch;
    private String serviceName;
    private TProtocolFactory protocolFactory;
    private TThreadPoolServer.Args poolArgs;

    public ThriftServiceThread(TProcessor processor, String serviceName, String threadsName, String bindAddress, int port, int maxWorkerThreads, int timeoutMs, TServerEventHandler serverEventHandler, boolean compress) {
        this.protocolFactory = compress ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        this.serviceName = serviceName;
        try {
            this.serverTransport = this.openTransport(bindAddress, port);
            this.poolArgs = new TThreadPoolServer.Args(this.serverTransport).maxWorkerThreads(maxWorkerThreads).minWorkerThreads(CommonUtils.getCpuCores()).stopTimeoutVal(timeoutMs);
            this.poolArgs.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(this.poolArgs, threadsName);
            this.poolArgs.processor(processor);
            this.poolArgs.protocolFactory(this.protocolFactory);
            this.poolArgs.transportFactory((TTransportFactory)RpcTransportFactory.INSTANCE);
            this.poolServer = new TThreadPoolServer(this.poolArgs);
            this.poolServer.setServerEventHandler(serverEventHandler);
        }
        catch (TTransportException e) {
            this.close();
            if (this.threadStopLatch == null) {
                logger.debug("Stop Count Down latch is null");
            } else {
                logger.debug("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
            }
            if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
                this.threadStopLatch.countDown();
            }
            logger.debug("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)serviceName);
            throw new RPCServiceException(String.format("%s: failed to start %s, because ", "IoTDB", serviceName), e);
        }
    }

    public TServerTransport openTransport(String bindAddress, int port) throws TTransportException {
        return new TServerSocket(new InetSocketAddress(bindAddress, port));
    }

    public void setThreadStopLatch(CountDownLatch threadStopLatch) {
        this.threadStopLatch = threadStopLatch;
    }

    @Override
    public void run() {
        logger.info("The {} service thread begin to run...", (Object)this.serviceName);
        try {
            this.poolServer.serve();
        }
        catch (Exception e) {
            throw new RPCServiceException(String.format("%s: %s exit, because ", "IoTDB", this.serviceName), e);
        }
        finally {
            this.close();
            if (this.threadStopLatch == null) {
                logger.debug("Stop Count Down latch is null");
            } else {
                logger.debug("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
            }
            if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
                this.threadStopLatch.countDown();
            }
            logger.debug("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)this.serviceName);
        }
    }

    public synchronized void close() {
        if (this.poolServer != null) {
            this.poolServer.setShouldStop(true);
            this.poolServer.stop();
            this.poolServer = null;
        }
        if (this.serverTransport != null) {
            this.serverTransport.close();
            this.serverTransport = null;
        }
    }

    public boolean isServing() {
        if (this.poolServer != null) {
            return this.poolServer.isServing();
        }
        return false;
    }
}

