/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure.primitive;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.datastructure.SerializableList;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableIntList
implements SerializableList {
    private static final int ARRAY_CAPACITY_THRESHOLD = 1000;
    private final SerializableList.SerializationRecorder serializationRecorder;
    private int capacity = 16;
    private List<int[]> list;
    private int writeCurListIndex;
    private int writeCurArrayIndex;
    private int count;

    public static SerializableIntList newSerializableIntList(long queryId) {
        SerializableList.SerializationRecorder recorder = new SerializableList.SerializationRecorder(queryId);
        return new SerializableIntList(recorder);
    }

    public static int calculateCapacity(float memoryLimitInMB) throws QueryProcessException {
        float memoryLimitInB = memoryLimitInMB * 1048576.0f / 2.0f;
        int size = 1000 * (int)(memoryLimitInB / 4000.0f);
        if (size <= 0) {
            throw new QueryProcessException("Memory is not enough for current query.");
        }
        return size;
    }

    public SerializableIntList(SerializableList.SerializationRecorder serializationRecorder) {
        this.serializationRecorder = serializationRecorder;
        this.init();
    }

    public void put(int value) {
        if (this.writeCurArrayIndex == this.capacity) {
            if (1000 <= this.capacity) {
                this.list.add(new int[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = 0;
            } else {
                int newCapacity = this.capacity << 1;
                int[] newValueData = new int[newCapacity];
                System.arraycopy(this.list.get(0), 0, newValueData, 0, this.capacity);
                this.list.set(0, newValueData);
                this.capacity = newCapacity;
            }
        }
        this.list.get((int)this.writeCurListIndex)[this.writeCurArrayIndex] = value;
        ++this.writeCurArrayIndex;
        ++this.count;
    }

    public int get(int index) {
        return this.list.get(index / this.capacity)[index % this.capacity];
    }

    public int size() {
        return this.count;
    }

    @Override
    public void release() {
        this.list = null;
    }

    @Override
    public void init() {
        this.list = new ArrayList<int[]>();
        this.list.add(new int[this.capacity]);
        this.writeCurListIndex = 0;
        this.writeCurArrayIndex = 0;
        this.count = 0;
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        this.serializationRecorder.setSerializedElementSize(this.count);
        int serializedByteLength = 0;
        for (int i = 0; i < this.count; ++i) {
            serializedByteLength += ReadWriteIOUtils.write((int)this.get(i), (OutputStream)outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        for (int i = 0; i < serializedElementSize; ++i) {
            this.put(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public SerializableList.SerializationRecorder getSerializationRecorder() {
        return this.serializationRecorder;
    }
}

