/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.util.Set;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ValueFill
extends IFill
implements Cloneable {
    private String value;
    private TsPrimitiveType tsPrimitiveType;

    public ValueFill(String value, TSDataType dataType) {
        this.value = value;
        this.dataType = dataType;
        this.parseTsPrimitiveType();
    }

    @Override
    public IFill copy() {
        return (IFill)this.clone();
    }

    public Object clone() {
        ValueFill valueFill = null;
        try {
            valueFill = (ValueFill)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return valueFill;
    }

    @Override
    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) {
        this.queryTime = queryTime;
    }

    @Override
    public TimeValuePair getFillResult() {
        switch (this.dataType) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TEXT: {
                return new TimeValuePair(this.queryTime, this.tsPrimitiveType);
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
    }

    @Override
    void constructFilter() {
    }

    private void parseTsPrimitiveType() {
        switch (this.dataType) {
            case BOOLEAN: {
                this.tsPrimitiveType = new TsPrimitiveType.TsBoolean(Boolean.parseBoolean(this.value));
                break;
            }
            case INT32: {
                this.tsPrimitiveType = new TsPrimitiveType.TsInt(Integer.parseInt(this.value));
                break;
            }
            case INT64: {
                this.tsPrimitiveType = new TsPrimitiveType.TsLong(Long.parseLong(this.value));
                break;
            }
            case FLOAT: {
                this.tsPrimitiveType = new TsPrimitiveType.TsFloat(Float.parseFloat(this.value));
                break;
            }
            case DOUBLE: {
                this.tsPrimitiveType = new TsPrimitiveType.TsDouble(Double.parseDouble(this.value));
                break;
            }
            case TEXT: {
                this.tsPrimitiveType = new TsPrimitiveType.TsBinary(Binary.valueOf((String)this.value));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
            }
        }
    }
}

